/*
 * Copyright (C) 2000-2025 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */
#ifndef HAVE_XITK_SKIN_H
#define HAVE_XITK_SKIN_H

struct xitk_skin_element_info_s {
  /* all */
  int x, y;
  int visibility, enability;
  xitk_part_image_t pixmap_img;
  /* label_length, button list max_buttons, slider_radius, browser_entries */
  int size;
  /* button list direction, slider_type */
  int type;
  /* label */
  int label_alignment, label_y, label_printable, label_staticity;
  int label_animation, label_animation_step;
  int label_height;
  unsigned int label_animation_timer;
  unsigned int label_color_bg, label_color, label_color_focus, label_color_click;
  const char *label_fontname;
  xitk_image_t *label_pixmap_font_img, *label_pixmap_highlight_font_img;
  /* slider */
  xitk_part_image_t slider_pixmap_pad_img;
};

/** generic disabled color: shift half way towards gray. */
#define xitk_disabled_color(_rgb) ((((uint32_t)_rgb >> 2) & 0x3f3f3f) + 0x606060)

/** get an empty xitk_skin_config_t *. */
xitk_skin_config_t *xitk_skin_new (xitk_t *xitk);
/** load or replace the skin configfile. NULL filename just unloads.
 *  return -2 (load failed), -1 (skin unusable), 0 (no version), skin version. */
#define XITK_SKIN_LOAD_TRUSTED 1 /** << run scripts verbatim */
#define XITK_SKIN_LOAD_FIRST 2 /** << just after install */
int xitk_skin_load (xitk_skin_config_t *skonfig, const char *path, const char *filename, unsigned int flags);

/** meta info. */
typedef enum {
  XITK_SKIN_path = 0,
  XITK_SKIN_skinfile,
  XITK_SKIN_name,
  XITK_SKIN_author,
  XITK_SKIN_date,
  XITK_SKIN_url,
  XITK_SKIN_logo,
  XITK_SKIN_animation,
  XITK_SKIN_load_command,
  XITK_SKIN_unload_command,
  XITK_SKIN_LAST
} xitk_skin_meta_t;
const char *xitk_skin_get_meta (xitk_skin_config_t *skonfig, xitk_skin_meta_t what);
/** query element by name. */
const xitk_skin_element_info_t *xitk_skin_get_info (xitk_skin_config_t *skin, const char *element_name);

/** unload and free. */
void xitk_skin_delete (xitk_skin_config_t **skonfig);

#endif

