/*
 * Copyright (C) 2002 Stefan Holst
 * Copyright (C) 2025 The xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA.
 *
 * oxine data structures
 */

#ifndef HAVE_OXINE_H
#define HAVE_OXINE_H

#include <stdlib.h>
#include <sys/types.h>
#include <xine.h>

/** we probably dont need this lock because we call all this with xitk lock already. */
#undef OXINE_LOCK

#ifndef __COMMON_H__
typedef struct oxine_s oxine_t;
typedef struct gGui_s gGui_t;
#endif

#include "otk.h"
#include "odk.h"

typedef struct oxine_window_s oxine_window_t;

typedef enum {
  oxine_win_id_main = 0,
  oxine_win_id_playlist,
  oxine_win_id_mediamarks,
  oxine_win_id_LAST
} oxine_win_id_t;

typedef enum {
  oxine_win_action_show = 1,
  oxine_win_action_hide,
  oxine_win_action_update,
  oxine_win_action_delete,
  oxine_win_action_LAST
} oxine_win_action_t;

typedef struct {
  oxine_t *oxine;
  int (*main) (oxine_t *oxine, oxine_win_id_t id, oxine_win_action_t action);
} oxine_session_t;

struct oxine_s {
#ifdef OXINE_LOCK
  struct {
    pthread_mutex_t  mutex;
    pthread_cond_t   unlocked;
    int              locks;
  }                  instance;
#endif
  xine_t             *xine;
  gGui_t             *gui;
  xitk_t             *xitk;

  otk_t              *otk;
  odk_t              *odk;

  oxine_session_t    *sessions[oxine_win_id_LAST];
  oxine_win_id_t      last_win;

  otk_widget_t       *main_window;
  otk_widget_t       *pauseplay;

  int                cd_is_mounted;
  int                cd_in_use;
  /* int                need_draw; */

  const char         *cd_mountpoint;
  const char         *cd_device;

  int                mm_sort_type;

  int                win_x, win_y, win_w, win_h;

  char               *pos_str;

  /** stream info blending */
  char               *lines[3];
  otk_widget_t       *info_window;
  int                 info_window_job;
  void (*media_info_close_cb)(void *data);

  int                 shutdown;
};

oxine_t *oxine_init (gGui_t *gui);
int oxine_win_main (oxine_t *oxine, oxine_win_id_t id, oxine_win_action_t action);
void oxine_exit (oxine_t **oxine);

void oxine_menu (oxine_t *oxine);
int oxine_is_visible (oxine_t *oxine);
int oxine_action_event (oxine_t *oxine, int xine_event_type);
void oxine_adapt (oxine_t *oxine);
#ifdef OXINE_EVENT_H
#  define OXINE_EVENT_HANDLED 1
#  define OXINE_EVENT_WIDGET_HELD 2
int oxine_event (oxine_t *oxine, const oxine_event_t *e);
#endif
void oxine_playlist_update (oxine_t *oxine);

#endif
