/*
 * Copyright 2009-2020 The VOTCA Development Team (http://www.votca.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef VOTCA_TOOLS_EIGENSYSTEM_H
#define VOTCA_TOOLS_EIGENSYSTEM_H

// Local VOTCA includes
#include "eigen.h"

namespace votca {
namespace tools {

class EigenSystem {
 public:
  // returns eigenvalues
  const Eigen::VectorXd& eigenvalues() const { return eigenvalues_; }
  Eigen::VectorXd& eigenvalues() { return eigenvalues_; }
  // returns eigenvectors
  const Eigen::MatrixXd& eigenvectors() const { return eigenvectors_; }
  Eigen::MatrixXd& eigenvectors() { return eigenvectors_; }
  // returns left eigenvectors or other in case of nonhermititan problem
  const Eigen::MatrixXd& eigenvectors2() const { return eigenvectors_2_; }
  Eigen::MatrixXd& eigenvectors2() { return eigenvectors_2_; }

  Eigen::ComputationInfo info() const { return info_; }
  Eigen::ComputationInfo& info() { return info_; }

  void clear() {
    info_ = Eigen::Success;
    eigenvalues_.resize(0);
    eigenvectors_.resize(0, 0);
    eigenvectors_2_.resize(0, 0);
  }

 private:
  Eigen::ComputationInfo info_ = Eigen::Success;
  Eigen::VectorXd eigenvalues_;
  Eigen::MatrixXd eigenvectors_;
  Eigen::MatrixXd eigenvectors_2_;
};

}  // namespace tools
}  // namespace votca
#endif  // VOTCA_TOOLS_EIGENSYSTEM_H
