/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien
	CALISTE, laboratoire L_Sim, (2011-2013)
  
	Adresse mèl :
	BILLARD, non joignable par mèl ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien
	CALISTE, laboratoire L_Sim, (2011-2013)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include "forces.h"

#include <visu_configFile.h>


#define FLAG_RESOURCE_FORCES_USED   "forces_are_on"
#define DESC_RESOURCE_FORCES_USED   "Control if the forces are drawn when available ; boolean (0 or 1)"
static gboolean RESOURCE_FORCES_USED_DEFAULT = FALSE;
#define FLAG_RESOURCE_FORCES_SCALE   "forces_scale"
#define DESC_RESOURCE_FORCES_SCALE   "Scaling factor (or automatic) for the force rendering ; float (-1 for auto or a positive value)"
static float RESOURCE_FORCES_SCALE_DEFAULT = -1.f;
static void exportResourceForces(GString *data, VisuData *dataObj);


/**
 * SECTION:forces
 * @short_description: Draw arrows at each node to represent forces.
 *
 * <para>A specialised #VisuGlExtNodeVectors to represent forces on nodes.</para>
 */

/**
 * VisuGlExtForcesClass:
 * @parent: the parent class;
 *
 * A short way to identify #_VisuGlExtForcesClass structure.
 *
 * Since: 3.7
 */
/**
 * VisuGlExtForces:
 *
 * An opaque structure.
 *
 * Since: 3.7
 */

/* Local callbacks. */
static void onEntryUsed(VisuGlExtForces *forces, VisuConfigFileEntry *entry, VisuConfigFile *obj);
static void onEntryNorm(VisuGlExtForces *forces, VisuConfigFileEntry *entry, VisuConfigFile *obj);

G_DEFINE_TYPE(VisuGlExtForces, visu_gl_ext_forces, VISU_TYPE_GL_EXT_NODE_VECTORS)

static void visu_gl_ext_forces_class_init(VisuGlExtForcesClass *klass _U_)
{
  float rg[2] = {-G_MAXFLOAT, G_MAXFLOAT};
  VisuConfigFileEntry *resourceEntry;

  g_debug("Visu GlExt Forces: creating the class of the object.");
  /* g_debug("                - adding new signals ;"); */

  /* Resources for forces extensions. */
  resourceEntry = visu_config_file_addBooleanEntry(VISU_CONFIG_FILE_RESOURCE,
                                                   FLAG_RESOURCE_FORCES_USED,
                                                   DESC_RESOURCE_FORCES_USED,
                                                   &RESOURCE_FORCES_USED_DEFAULT, FALSE);
  visu_config_file_entry_setVersion(resourceEntry, 3.7f);
  resourceEntry = visu_config_file_addFloatArrayEntry(VISU_CONFIG_FILE_RESOURCE,
                                                      FLAG_RESOURCE_FORCES_SCALE,
                                                      DESC_RESOURCE_FORCES_SCALE,
                                                      1, &RESOURCE_FORCES_SCALE_DEFAULT, rg, FALSE);
  visu_config_file_entry_setVersion(resourceEntry, 3.7f);
  visu_config_file_addExportFunction(VISU_CONFIG_FILE_RESOURCE,
                                     exportResourceForces);
}

static void visu_gl_ext_forces_init(VisuGlExtForces *obj)
{
  g_debug("Visu GlExt Forces: initializing a new object (%p).",
	      (gpointer)obj);
  
  /* Private data. */
  g_signal_connect_object(VISU_CONFIG_FILE_RESOURCE, "parsed::" FLAG_RESOURCE_FORCES_USED,
                          G_CALLBACK(onEntryUsed), (gpointer)obj, G_CONNECT_SWAPPED);
  g_signal_connect_object(VISU_CONFIG_FILE_RESOURCE, "parsed::" FLAG_RESOURCE_FORCES_SCALE,
                          G_CALLBACK(onEntryNorm), (gpointer)obj, G_CONNECT_SWAPPED);
}

/**
 * visu_gl_ext_forces_new:
 * @name: (allow-none): the name to give to the extension.
 *
 * Creates a new #VisuGlExt to draw forces.
 *
 * Since: 3.7
 *
 * Returns: a pointer to the #VisuGlExt it created or
 * NULL otherwise.
 */
VisuGlExtForces* visu_gl_ext_forces_new(const gchar *name)
{
  char *name_ = "Forces";
  char *description = _("Draw forces with vectors.");
  VisuGlExtNodeVectors *forces;

  g_debug("Visu GlExt Forces: new object.");
  forces = VISU_GL_EXT_NODE_VECTORS(g_object_new(VISU_TYPE_GL_EXT_FORCES,
                                                 "name", (name)?name:name_, "label", _(name),
                                                 "description", description, NULL));
  visu_gl_ext_node_vectors_setTranslation(forces, 1.1f);
  visu_gl_ext_node_vectors_setRenderedSize(forces, -2.f);
  visu_gl_ext_node_vectors_setNormalisation(forces, RESOURCE_FORCES_SCALE_DEFAULT);
  visu_gl_ext_node_vectors_setLabelThreshold(forces, -0.85f);
  
  return VISU_GL_EXT_FORCES(forces);
}


/* Callbacks. */
static void onEntryUsed(VisuGlExtForces *forces, VisuConfigFileEntry *entry _U_, VisuConfigFile *obj _U_)
{
  visu_gl_ext_setActive(VISU_GL_EXT(forces), RESOURCE_FORCES_USED_DEFAULT);
}
static void onEntryNorm(VisuGlExtForces *forces, VisuConfigFileEntry *entry _U_, VisuConfigFile *obj _U_)
{
  visu_gl_ext_node_vectors_setNormalisation(VISU_GL_EXT_NODE_VECTORS(forces),
                                            RESOURCE_FORCES_SCALE_DEFAULT);
}

/* Resources. */
static void exportResourceForces(GString *data, VisuData *dataObj _U_)
{
  visu_config_file_exportComment(data, DESC_RESOURCE_FORCES_USED);
  visu_config_file_exportEntry(data, FLAG_RESOURCE_FORCES_USED, NULL,
                               "%d", RESOURCE_FORCES_USED_DEFAULT);
  visu_config_file_exportComment(data, DESC_RESOURCE_FORCES_SCALE);
  visu_config_file_exportEntry(data, FLAG_RESOURCE_FORCES_SCALE, NULL,
                               "%f", RESOURCE_FORCES_SCALE_DEFAULT);
  visu_config_file_exportComment(data, "");
}
