# 2025-09-02 Triage Log

A relatively quiet week. [#144841](https://github.com/rust-lang/rust/pull/144841) added an
optimization for incremental builds that provided a very nice win for the `nalgebra` crate. [#143290](https://github.com/rust-lang/rust/pull/143290) should help avoid instantiating async functions repeatedly in
downstream crates.

Triage done by **@kobzol**..-
Revision range: [ee361e8f..75ee9ffd](https://perf.rust-lang.org/?start=ee361e8fca1c30e13e7a31cc82b64c045339d3a8&end=75ee9ffd5ed3649c0a09493057adaa8feebb2035&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.1%, 13.6%]  | 30    |
| Improvements ✅ <br /> (primary)   | -1.9% | [-7.0%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.7%, -0.1%] | 23    |
| All ❌✅ (primary)                 | -1.2% | [-7.0%, 0.4%]  | 24    |


1 Regression, 3 Improvements, 6 Mixed; 5 of them in rollups
45 artifact comparisons made in total

#### Regressions

pub async fn impl is monomorphized when func itself is monomorphized [#143290](https://github.com/rust-lang/rust/pull/143290) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=84a17470220e7adf249b18d7c0178dfbede89462&end=c0bb3b98bb7aac24a37635e5d36d961e0b14f435&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -             | 0     |
| Regressions ❌ <br /> (secondary)  | 6.1% | [0.9%, 13.5%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | -    | -             | 0     |

- The regression is expected, as we now do more work for async fns in their crate, with the hope of reducing the amount of work required in downstream crates.
- Marked as triaged.

#### Improvements

Rollup of 6 pull requests [#145916](https://github.com/rust-lang/rust/pull/145916) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=269d5b56bcfdf2be82213e72ef9a2e4c592a8c6b&end=4f808ba6bf9f1c8dde30d009e73386d984491587&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -2.7% | [-2.9%, -2.5%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |


Rollup of 6 pull requests [#145970](https://github.com/rust-lang/rust/pull/145970) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=35d55b34bffd51384ac430cc20852b7d16dd5a90&end=f2824da98d44c4a4e17bf39eb45103c8fc249117&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.1%] | 32    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.9%, -0.1%] | 10    |
| All ❌✅ (primary)                 | -0.4% | [-0.9%, -0.1%] | 32    |


Rollup of 6 pull requests [#146072](https://github.com/rust-lang/rust/pull/146072) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=828e45ad11ce4ab56dd64e93f1fb5dd8f0c0ae93&end=be4e9b77ab5502b7beda0b787fb3c978a7b4db79&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.0%  | [0.0%, 0.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 3     |


#### Mixed

Rollup of 9 pull requests [#145906](https://github.com/rust-lang/rust/pull/145906) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=160e7623e8cbbf1feab2b6e2a24733a98c7bde9c&end=176d8dbce6a7a7a4541d1c980d4a85dfb76ce1f1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 10    |

- More wins than regressions, and the two regressions are small, in `incr-unchanged` and in secondary benchmarks.
- Marked as triaged.

Access less HIR attributes from typeck [#144841](https://github.com/rust-lang/rust/pull/144841) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=176d8dbce6a7a7a4541d1c980d4a85dfb76ce1f1&end=269d5b56bcfdf2be82213e72ef9a2e4c592a8c6b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 2.8%  | [2.6%, 3.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-7.0%, -0.2%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -1.3% | [-7.0%, 0.4%]  | 21    |

- More improvements than regressions, and a very nice incremental win on nalgebra.
- Marked as triaged.

Region inference: Use outlives-static constraints in constraint search [#140737](https://github.com/rust-lang/rust/pull/140737) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4f808ba6bf9f1c8dde30d009e73386d984491587&end=b2dd217dd0a099fb87601657ec480bf3e92b30a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.4%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.3%]   | 9     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 6     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.4%]   | 13    |

- Looks like a small number of real regressions.
- Not marking as triaged yet, following up on the PR.

Use captures(address) instead of captures(none) for indirect args [#145877](https://github.com/rust-lang/rust/pull/145877) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cdb45c87e2cd43495379f7e867e3cc15dcee9f93&end=d36f964125163c2e698de5559efefb8217b8b7f0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8%  | [0.1%, 1.5%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 1.5%]   | 14    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 3     |
| All ❌✅ (primary)                 | 0.5%  | [-0.2%, 1.5%]  | 3     |

- The syn results are noise.
- This is a correctness fix, marked as triaged.

Rollup of 9 pull requests [#145958](https://github.com/rust-lang/rust/pull/145958) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b41634205b549a62cfa55363d1e00c4143d30033&end=1f7dcc878d73c45cc40018aac6e5c767446df110&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 2.4%  | [0.2%, 3.0%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.4%, -0.0%] | 11    |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 3     |

- The match-stress results are noise, the externs wins look real, and then there's one tiny regression on unicode-normalization.
- Marked as triaged.

`-Znext-solver`: support non-defining uses in closures [#145925](https://github.com/rust-lang/rust/pull/145925) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7aef4bec4bec16cb6204d51eb633873e23b18771&end=75ee9ffd5ed3649c0a09493057adaa8feebb2035&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.6%]   | 33    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.0%, 0.8%]   | 29    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.3%, 0.6%]  | 36    |

- The regressions look real, following up on the PR.
- Not marking as triaged yet.
