% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-equality.R
\name{expect_equivalent}
\alias{expect_equivalent}
\title{Is an object equal to the expected value, ignoring attributes?}
\usage{
expect_equivalent(
  object,
  expected,
  ...,
  info = NULL,
  label = NULL,
  expected.label = NULL
)
}
\arguments{
\item{object}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{...}{Passed on to \code{\link[=compare]{compare()}}.}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert
use only.}

\item{expected.label}{Used to customise failure messages. For expert
use only.}
}
\description{
Compares \code{object} and \code{expected} using \code{\link[=all.equal]{all.equal()}} and
\code{check.attributes = FALSE}.
}
\section{3rd edition}{

\ifelse{html}{\figure{lifecycle-deprecated.svg}{options: alt='Deprecated lifecycle'}}{\strong{Deprecated}}

\code{expect_equivalent()} is deprecated in the 3rd edition. Instead use
\code{expect_equal(ignore_attr = TRUE)}.
}

\examples{
#' # expect_equivalent() ignores attributes
a <- b <- 1:3
names(b) <- letters[1:3]
\dontrun{
expect_equal(a, b)
}
expect_equivalent(a, b)
}
\keyword{internal}
