% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLMnet.R
\name{GLMnet}
\alias{GLMnet}
\title{Formula interface for glmnet}
\usage{
GLMnet(
  formula,
  data,
  lambda = NULL,
  alpha = 1,
  cv = TRUE,
  nfolds = 10,
  type.measure = "deviance",
  selector = "min",
  family,
  ...
)
}
\arguments{
\item{formula}{Formula where the left hand side specifies either a single variable (continuous, binary or categorical),
or as a survival outcome (time, event), and the right hand side specifies the linear predictor.
Survival outcome can either be specified via \link[survival]{Surv} or via \link[prodlim]{Hist}.
Variables on the right hand side of the formula can be marked as \code{unpenalized}, see examples.
#' For survival outcome, a penalized Cox regression model is fitted. For this the formula may specify variables for which the baseline hazard function should be stratified, see examples.}

\item{data}{The data used to fit the model.}

\item{lambda}{A hyperparameter passed to glmnet. If set to NULL, then lambda is chosen by cross-validation,
via the function \link[glmnet]{cv.glmnet}}

\item{alpha}{The elasticnet mixing parameter, with 0<=alpha<= 1. \code{alpha =1} is the lasso penalty, and \code{alpha=0} the ridge penalty.}

\item{cv}{Whether to use cross-validation or not. Default is TRUE.}

\item{nfolds}{Passed on to \link[glmnet]{cv.glmnet}. Number of folds for cross-validation. The default is 10.}

\item{type.measure}{Passed on to \link[glmnet]{cv.glmnet}. Loss to use for cross-validation. Default is deviance.}

\item{selector}{On of \code{'min'}, \code{'1se'}, \code{'undersmooth'} where the first two are described in the help page of \link[glmnet]{cv.glmnet}
              and the latter is the smallest lambda value where the model could fit. Default is \code{'min'}.
When \code{'undersmooth'} is specified no cross-validation is performed.}

\item{family}{Passed on to \link[glmnet]{glmnet} and \link[glmnet]{cv.glmnet}. For binary outcome the default is \code{"binomial"} and for survival \code{"cox"}.}

\item{\dots}{Additional arguments that are passed on to \link[glmnet]{glmnet} and \link[glmnet]{cv.glmnet}.}
}
\value{
A glmnet object enhanced with the call, the terms to create the design matrix, and in the survival case
with the Breslow estimate of the baseline hazard function.
}
\description{
Fit glmnet models via a formula and a data set for use with \code{\link{predictRisk}}.
}
\examples{
library(survival)
set.seed(8)
d <- sampleData(87,outcome="survival")
test <- sampleData(5,outcome="survival")

# penalized logistic regression
g <- GLMnet(X2~X1+X8,data=d)
predictRisk(g,newdata=test)
\dontrun{
g1 <- GLMnet(X2~X1+X8,data=d,lambda=0,gamma=0.5)
g2 <- GLMnet(X2~X1+X8,data=d,relax=TRUE)
}
# penalized Cox regression

f0 <- GLMnet(Surv(time,event)~X1+X2+X8+X9,data=d,lambda=0)
predictRisk(f0,newdata=test,times=3)
f <- GLMnet(Surv(time,event)~X1+X2+X8+X9,data=d)
f
predictCox(f,newdata=test,times=5,product.limit=TRUE)
predictRisk(f,newdata=test,times=1)

f1 <- GLMnet(Surv(time,event)~X1+X2+unpenalized(X8)+X9,data=d)

predictRisk(f1,newdata=test,times=1)
}
\seealso{
\link[glmnet]{glmnet}
}
