% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/years.R
\name{plot_f}
\alias{plot_f}
\title{Plot the absolute risk (observed and population curve)}
\usage{
plot_f(
  years,
  xlab = "Time interval",
  ylab = "Absolute risk",
  xbreak,
  ybreak,
  xlimits,
  ylimits,
  show.legend = TRUE
)
}
\arguments{
\item{years}{the object obtained using function \code{years}.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{xbreak}{the breaks on the x axis (this is supplied to \code{scale_x_continuous}).}

\item{ybreak}{the breaks on the y axis (this is supplied to \code{scale_y_continuous}).}

\item{xlimits}{define the limits on the x axis (this is supplied to \code{scale_x_continuous}).}

\item{ylimits}{define the limits on the y axis (this is supplied to \code{scale_y_continuous}).}

\item{show.legend}{if TRUE, the legend is shown on the graph.}
}
\value{
A ggplot object
}
\description{
Plots the estimated observed and population curve for the
life years difference (Manevski, Ruzic Gorenjec, Andersen, Pohar Perme, 2022).
}
\details{
A ggplot2 implementation for plotting the observed and population curves. The type of curves is
dependent upon the measure calculated using \code{years} function (argument \code{measure}).
}
\seealso{
\code{\link{years}}, \code{\link{plot_years}}
}
