\name{rs.diff}
\alias{rs.diff}
\alias{print.rsdiff}




\title{Test Net Survival Curve Differences}

\description{
     Tests if there is a difference between two or more net survival curves using a log-rank type test.
}
\usage{
     rs.diff(formula, data, ratetable = relsurv::slopop, na.action,precision=1,rmap) 
}
\arguments{
\item{formula}{
A formula expression as for other survival models, of the form \code{Surv(time, status) ~ predictors}.
Each combination of predictor values defines a subgroup. A \code{strata} term may be used to produce a stratified test. 

 NOTE: The follow-up time must be in days. 
}
\item{data}{
a data.frame in which to interpret the variables named in the
          \code{formula}. 

}
\item{ratetable}{
a table of event rates, organized as a \code{ratetable} object,
          such as \code{slopop}.  
}
\item{na.action}{a missing-data filter function, applied to the model.frame,
          after any subset argument has been used.  Default is
          \code{options()$na.action}.} 


\item{precision}{Precision for numerical integration. Default is 1, which means that daily intervals are taken, the value may be decreased to get a higher precision or increased to achieve a faster calculation. The calculation intervals always include at least all times of event and censoring as border points.
}
\item{rmap}{an optional list to be used if the variables are not
          organized and named in the same way as in the \code{ratetable} object. See details below.}

}

\details{
NOTE: The follow-up time must be specified in days. The \code{ratetable} being used may have different variable names and formats than the user's data set, this is dealt with by the \code{rmap} argument. For example, if age is in years in the data set but in days in the \code{ratetable} object, age=age*365.241 should be used. The calendar year can be in any date format (date, Date and POSIXt are allowed), the date formats in the \code{ratetable} and in the data may differ. 
}

\value{
 a \code{rsdiff} object; can be printed with \code{print}.

}

\references{
Package: Pohar Perme, M., Pavlic, K. (2018) "Nonparametric Relative Survival Analysis with the {R} Package {relsurv}". Journal of Statistical Software. 87(8), 1-27,  doi: "10.18637/jss.v087.i08" 
Theory: Graffeo, N., Castell, F., Belot, A. and Giorgi, R. (2016) "A log-rank-type test to compare net survival distributions. Biometrics. doi: 10.1111/biom.12477"
Theory: Pavlic, K., Pohar Perme, M. (2017) "On comparison of net survival curves. BMC Med Res Meth. doi: 10.1186/s12874-017-0351-3"
}




\examples{
data(slopop)
data(rdata)
#calculate the relative survival curve
#note that the variable year is given in days since 01.01.1960 and that 
#age must be multiplied by 365.241 in order to be expressed in days.
rs.diff(Surv(time,cens)~sex,rmap=list(age=age*365.241),
		ratetable=slopop,data=rdata)
}


\seealso{
\code{rs.surv},
\code{survdiff}
}

\keyword{survival}
