% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.r
\name{saturate}
\alias{saturate}
\title{Make a munsell colour more saturated}
\usage{
saturate(col, steps = 1)
}
\arguments{
\item{col}{character vector of Munsell colours}

\item{steps}{number of steps to take in increasing chroma}
}
\value{
character vector of Munsell colours
}
\description{
Increases the chroma of the Munsell colour by step steps (multiples of 2).
}
\examples{
saturate("5PB 2/4")
cols <- c("5PB 2/2", "5Y 7/6")
p <- plot_mnsl(c(cols, saturate(cols), saturate(cols, 2)))
p + ggplot2::facet_wrap(~ names, ncol = 2)
}
