% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-beeswarm.R
\name{offset_beeswarm}
\alias{offset_beeswarm}
\title{An internal function to calculate new positions for geom_beeswarm}
\usage{
offset_beeswarm(
  data,
  yLim.expand,
  xRange,
  yRange,
  method = "swarm",
  cex = 1,
  side = 0L,
  priority = "ascending",
  fast = TRUE,
  corral = "none",
  corral.width = 0.2
)
}
\arguments{
\item{data}{A data.frame containing plotting data in columns x and y.
Usually obtained from data processed by ggplot2.}

\item{yLim.expand}{y data limits plus a small expansion using \code{grDevices::extendrange}}

\item{xRange}{x axis scale range}

\item{yRange}{y axis scale range}

\item{method}{Method for arranging points (see Details below)}

\item{cex}{Scaling for adjusting point spacing (see \code{\link[beeswarm:swarmx]{beeswarm::swarmx()}}).
Values between 1 (default) and 3 tend to work best.}

\item{side}{Direction to perform jittering: 0: both directions;
1: to the right or upwards; -1: to the left or downwards.}

\item{priority}{Method used to perform point layout (see Details below)}

\item{fast}{Use compiled version of swarm algorithm? This option is ignored
for all methods expect \code{"swarm"} and \code{"compactswarm"}.}

\item{corral}{\code{string}. Method used to adjust points that would be placed to
wide horizontally, default is \code{"none"}. See details below.}

\item{corral.width}{\code{numeric}. Width of the corral, default is \code{0.9}.}
}
\description{
An internal function to calculate new positions for geom_beeswarm
}
\details{
\strong{method:} specifies the algorithm used to avoid overlapping points. The
default \code{"swarm"} method places points in increasing order. If a point would
overlap with an existing point, it is shifted sideways (along the group axis)
by a minimal amount sufficient to avoid overlap.

While the \code{"swarm"} method places points in a predetermined
order, the \code{"compactswarm"} method uses a greedy strategy to determine which
point will be placed next. This often leads to a more tightly-packed layout.
The strategy is very simple: on each iteration, a point that can be placed as
close as possible to the non-data axis is chosen and placed. If there are two
or more equally good points, \code{priority} is used to break ties.

The other 3 methods first discretise the values along the data axis, in order
to create more efficient packing. The \code{"square"} method places points on a
square grid, whereas \code{"hex"} uses a hexagonal grid. \code{"centre"}/\code{"center"}
uses a square grid to produce a symmetric swarm. The number of break points
for discretisation is determined by a combination of the available plotting
area and the \code{cex} argument.

\strong{priority:} controls the order in which points are placed, which generally
has a noticeable effect on the plot appearance. \code{"ascending"} gives the
'traditional' beeswarm plot. \code{"descending"} is the opposite. \code{"density"}
prioritizes points with higher local density. \code{"random"} places points in a
random order. \code{"none"} places points in the order provided.

\strong{corral:} By default, swarms from different groups are not prevented from
overlapping, i.e. \verb{"corral = "none"}. Thus, datasets that are very large or
unevenly distributed may produce ugly overlapping beeswarms. To control
runaway points one can use the following methods. \code{"gutter"} collects runaway
points along the boundary between groups. \code{"wrap"} implement periodic boundaries.
\code{"random"} places runaway points randomly in the region. \code{"omit"} omits runaway
points.
}
\seealso{
\code{\link[=geom_beeswarm]{geom_beeswarm()}}, \code{\link[=position_quasirandom]{position_quasirandom()}},
\code{\link[beeswarm:swarmx]{beeswarm::swarmx()}}

Other position adjustments: 
\code{\link{position_beeswarm}()},
\code{\link{position_quasirandom}()}
}
\concept{position adjustments}
\keyword{internal}
