% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_codebook.R
\name{data_codebook}
\alias{data_codebook}
\alias{print_html.data_codebook}
\title{Generate a codebook of a data frame.}
\usage{
data_codebook(
  data,
  select = NULL,
  exclude = NULL,
  variable_label_width = NULL,
  value_label_width = NULL,
  max_values = 10,
  range_at = 6,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

\method{print_html}{data_codebook}(
  x,
  font_size = "100\%",
  line_padding = 3,
  row_color = "#eeeeee",
  ...
)
}
\arguments{
\item{data}{A data frame, or an object that can be coerced to a data frame.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{variable_label_width}{Length of variable labels. Longer labels will be
wrapped at \code{variable_label_width} chars. If \code{NULL}, longer labels will not
be split into multiple lines. Only applies to \emph{labelled data}.}

\item{value_label_width}{Length of value labels. Longer labels will be
shortened, where the remaining part is truncated. Only applies to
\emph{labelled data} or factor levels.}

\item{max_values}{Number of maximum values that should be displayed. Can be
used to avoid too many rows when variables have lots of unique values.}

\item{range_at}{Indicates how many unique values in a numeric vector are
needed in order to print a range for that variable instead of a frequency
table for all numeric values. Can be useful if the data contains numeric
variables with only a few unique values and where full frequency tables
instead of value ranges should be displayed.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods.}

\item{x}{A (grouped) data frame, a vector or a statistical model (for
\code{unstandardize()} cannot be a model).}

\item{font_size}{For HTML tables, the font size.}

\item{line_padding}{For HTML tables, the distance (in pixel) between lines.}

\item{row_color}{For HTML tables, the fill color for odd rows.}
}
\value{
A formatted data frame, summarizing the content of the data frame.
Returned columns include the column index of the variables in the original
data frame (\code{ID}), column name, variable label (if data is labelled), type
of variable, number of missing values, unique values (or value range),
value labels (for labelled data), and a frequency table (N for each value).
Most columns are formatted as character vectors.
}
\description{
\code{data_codebook()} generates codebooks from data frames, i.e. overviews
of all variables and some more information about each variable (like
labels, values or value range, frequencies, amount of missing values).
}
\note{
There are methods to \code{print()} the data frame in a nicer output, as
well methods for printing in markdown or HTML format (\code{print_md()} and
\code{print_html()}).
}
\examples{
data(iris)
data_codebook(iris, select = starts_with("Sepal"))

data(efc)
data_codebook(efc)

# shorten labels
data_codebook(efc, variable_label_width = 20, value_label_width = 15)

# automatic range for numerics at more than 5 unique values
data(mtcars)
data_codebook(mtcars, select = starts_with("c"))

# force all values to be displayed
data_codebook(mtcars, select = starts_with("c"), range_at = 100)
}
