#ifndef dt_FREAD_LOOKUPS_H
#define dt_FREAD_LOOKUPS_H

// characters re-interpreted as hex digits (or 99 for characters that are not
// valid digits). Thus, this table maps
//   '0' .. '9'  into  0 .. 9
//   'a' .. 'f'  into  10 .. 15
//   'A' .. 'F'  into  10 .. 15
//   everything else into 99
const uint8_t hexdigits[256] = {
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x00 - 0x0F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x10 - 0x1F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x20 - 0x2F
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  99, 99, 99, 99, 99, 99,  // 0x30 - 0x3F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x40 - 0x4F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x50 - 0x5F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x60 - 0x6F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x70 - 0x7F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x80 - 0x8F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0x90 - 0x9F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xA0 - 0xAF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xB0 - 0xBF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xC0 - 0xCF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xD0 - 0xDF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 0xE0 - 0xEF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99   // 0xF0 - 0xFF
};

const uint8_t normYearDays[12] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
const uint16_t cumDaysCycleMonthsNorm[12] = {
  0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
};
const uint8_t leapYearDays[12] = {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
const uint16_t cumDaysCycleMonthsLeap[12] = {
  0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335
};

// pattern of leap days repeats every 400 years, starting with e.g. 1600.
//   to facilitate working with 1970-01-01 UTC epoch time, days are expressed
//   relative to 1970 % 400. 401st element is 365*400+100-3,
//   the total number of days in 400 years [100 leap years - 3 non-leap centuries]
const int32_t cumDaysCycleYears[401] = {
-135140, -134774, -134409, -134044,
-133679, -133313, -132948, -132583,
-132218, -131852, -131487, -131122,
-130757, -130391, -130026, -129661,
-129296, -128930, -128565, -128200,
-127835, -127469, -127104, -126739,
-126374, -126008, -125643, -125278,
-124913, -124547, -124182, -123817,
-123452, -123086, -122721, -122356,
-121991, -121625, -121260, -120895,
-120530, -120164, -119799, -119434,
-119069, -118703, -118338, -117973,
-117608, -117242, -116877, -116512,
-116147, -115781, -115416, -115051,
-114686, -114320, -113955, -113590,
-113225, -112859, -112494, -112129,
-111764, -111398, -111033, -110668,
-110303, -109937, -109572, -109207,
-108842, -108476, -108111, -107746,
-107381, -107015, -106650, -106285,
-105920, -105554, -105189, -104824,
-104459, -104093, -103728, -103363,
-102998, -102632, -102267, -101902,
-101537, -101171, -100806, -100441,
-100076,  -99710,  -99345,  -98980,
 -98615,  -98250,  -97885,  -97520,
 -97155,  -96789,  -96424,  -96059,
 -95694,  -95328,  -94963,  -94598,
 -94233,  -93867,  -93502,  -93137,
 -92772,  -92406,  -92041,  -91676,
 -91311,  -90945,  -90580,  -90215,
 -89850,  -89484,  -89119,  -88754,
 -88389,  -88023,  -87658,  -87293,
 -86928,  -86562,  -86197,  -85832,
 -85467,  -85101,  -84736,  -84371,
 -84006,  -83640,  -83275,  -82910,
 -82545,  -82179,  -81814,  -81449,
 -81084,  -80718,  -80353,  -79988,
 -79623,  -79257,  -78892,  -78527,
 -78162,  -77796,  -77431,  -77066,
 -76701,  -76335,  -75970,  -75605,
 -75240,  -74874,  -74509,  -74144,
 -73779,  -73413,  -73048,  -72683,
 -72318,  -71952,  -71587,  -71222,
 -70857,  -70491,  -70126,  -69761,
 -69396,  -69030,  -68665,  -68300,
 -67935,  -67569,  -67204,  -66839,
 -66474,  -66108,  -65743,  -65378,
 -65013,  -64647,  -64282,  -63917,
 -63552,  -63186,  -62821,  -62456,
 -62091,  -61726,  -61361,  -60996,
 -60631,  -60265,  -59900,  -59535,
 -59170,  -58804,  -58439,  -58074,
 -57709,  -57343,  -56978,  -56613,
 -56248,  -55882,  -55517,  -55152,
 -54787,  -54421,  -54056,  -53691,
 -53326,  -52960,  -52595,  -52230,
 -51865,  -51499,  -51134,  -50769,
 -50404,  -50038,  -49673,  -49308,
 -48943,  -48577,  -48212,  -47847,
 -47482,  -47116,  -46751,  -46386,
 -46021,  -45655,  -45290,  -44925,
 -44560,  -44194,  -43829,  -43464,
 -43099,  -42733,  -42368,  -42003,
 -41638,  -41272,  -40907,  -40542,
 -40177,  -39811,  -39446,  -39081,
 -38716,  -38350,  -37985,  -37620,
 -37255,  -36889,  -36524,  -36159,
 -35794,  -35428,  -35063,  -34698,
 -34333,  -33967,  -33602,  -33237,
 -32872,  -32506,  -32141,  -31776,
 -31411,  -31045,  -30680,  -30315,
 -29950,  -29584,  -29219,  -28854,
 -28489,  -28123,  -27758,  -27393,
 -27028,  -26662,  -26297,  -25932,
 -25567,  -25202,  -24837,  -24472,
 -24107,  -23741,  -23376,  -23011,
 -22646,  -22280,  -21915,  -21550,
 -21185,  -20819,  -20454,  -20089,
 -19724,  -19358,  -18993,  -18628,
 -18263,  -17897,  -17532,  -17167,
 -16802,  -16436,  -16071,  -15706,
 -15341,  -14975,  -14610,  -14245,
 -13880,  -13514,  -13149,  -12784,
 -12419,  -12053,  -11688,  -11323,
 -10958,  -10592,  -10227,   -9862,
  -9497,   -9131,   -8766,   -8401,
  -8036,   -7670,   -7305,   -6940,
  -6575,   -6209,   -5844,   -5479,
  -5114,   -4748,   -4383,   -4018,
  -3653,   -3287,   -2922,   -2557,
  -2192,   -1826,   -1461,   -1096,
   -731,    -365,       0,     365,
    730,    1096,    1461,    1826,
   2191,    2557,    2922,    3287,
   3652,    4018,    4383,    4748,
   5113,    5479,    5844,    6209,
   6574,    6940,    7305,    7670,
   8035,    8401,    8766,    9131,
   9496,    9862,   10227,   10592,
146097// total days in 400 years
};

const long double pow10lookup[301] = {
1.0E0L,
1.0E1L,
1.0E2L,
1.0E3L,
1.0E4L,
1.0E5L,
1.0E6L,
1.0E7L,
1.0E8L,
1.0E9L,
1.0E10L,
1.0E11L,
1.0E12L,
1.0E13L,
1.0E14L,
1.0E15L,
1.0E16L,
1.0E17L,
1.0E18L,
1.0E19L,
1.0E20L,
1.0E21L,
1.0E22L,
1.0E23L,
1.0E24L,
1.0E25L,
1.0E26L,
1.0E27L,
1.0E28L,
1.0E29L,
1.0E30L,
1.0E31L,
1.0E32L,
1.0E33L,
1.0E34L,
1.0E35L,
1.0E36L,
1.0E37L,
1.0E38L,
1.0E39L,
1.0E40L,
1.0E41L,
1.0E42L,
1.0E43L,
1.0E44L,
1.0E45L,
1.0E46L,
1.0E47L,
1.0E48L,
1.0E49L,
1.0E50L,
1.0E51L,
1.0E52L,
1.0E53L,
1.0E54L,
1.0E55L,
1.0E56L,
1.0E57L,
1.0E58L,
1.0E59L,
1.0E60L,
1.0E61L,
1.0E62L,
1.0E63L,
1.0E64L,
1.0E65L,
1.0E66L,
1.0E67L,
1.0E68L,
1.0E69L,
1.0E70L,
1.0E71L,
1.0E72L,
1.0E73L,
1.0E74L,
1.0E75L,
1.0E76L,
1.0E77L,
1.0E78L,
1.0E79L,
1.0E80L,
1.0E81L,
1.0E82L,
1.0E83L,
1.0E84L,
1.0E85L,
1.0E86L,
1.0E87L,
1.0E88L,
1.0E89L,
1.0E90L,
1.0E91L,
1.0E92L,
1.0E93L,
1.0E94L,
1.0E95L,
1.0E96L,
1.0E97L,
1.0E98L,
1.0E99L,
1.0E100L,
1.0E101L,
1.0E102L,
1.0E103L,
1.0E104L,
1.0E105L,
1.0E106L,
1.0E107L,
1.0E108L,
1.0E109L,
1.0E110L,
1.0E111L,
1.0E112L,
1.0E113L,
1.0E114L,
1.0E115L,
1.0E116L,
1.0E117L,
1.0E118L,
1.0E119L,
1.0E120L,
1.0E121L,
1.0E122L,
1.0E123L,
1.0E124L,
1.0E125L,
1.0E126L,
1.0E127L,
1.0E128L,
1.0E129L,
1.0E130L,
1.0E131L,
1.0E132L,
1.0E133L,
1.0E134L,
1.0E135L,
1.0E136L,
1.0E137L,
1.0E138L,
1.0E139L,
1.0E140L,
1.0E141L,
1.0E142L,
1.0E143L,
1.0E144L,
1.0E145L,
1.0E146L,
1.0E147L,
1.0E148L,
1.0E149L,
1.0E150L,
1.0E151L,
1.0E152L,
1.0E153L,
1.0E154L,
1.0E155L,
1.0E156L,
1.0E157L,
1.0E158L,
1.0E159L,
1.0E160L,
1.0E161L,
1.0E162L,
1.0E163L,
1.0E164L,
1.0E165L,
1.0E166L,
1.0E167L,
1.0E168L,
1.0E169L,
1.0E170L,
1.0E171L,
1.0E172L,
1.0E173L,
1.0E174L,
1.0E175L,
1.0E176L,
1.0E177L,
1.0E178L,
1.0E179L,
1.0E180L,
1.0E181L,
1.0E182L,
1.0E183L,
1.0E184L,
1.0E185L,
1.0E186L,
1.0E187L,
1.0E188L,
1.0E189L,
1.0E190L,
1.0E191L,
1.0E192L,
1.0E193L,
1.0E194L,
1.0E195L,
1.0E196L,
1.0E197L,
1.0E198L,
1.0E199L,
1.0E200L,
1.0E201L,
1.0E202L,
1.0E203L,
1.0E204L,
1.0E205L,
1.0E206L,
1.0E207L,
1.0E208L,
1.0E209L,
1.0E210L,
1.0E211L,
1.0E212L,
1.0E213L,
1.0E214L,
1.0E215L,
1.0E216L,
1.0E217L,
1.0E218L,
1.0E219L,
1.0E220L,
1.0E221L,
1.0E222L,
1.0E223L,
1.0E224L,
1.0E225L,
1.0E226L,
1.0E227L,
1.0E228L,
1.0E229L,
1.0E230L,
1.0E231L,
1.0E232L,
1.0E233L,
1.0E234L,
1.0E235L,
1.0E236L,
1.0E237L,
1.0E238L,
1.0E239L,
1.0E240L,
1.0E241L,
1.0E242L,
1.0E243L,
1.0E244L,
1.0E245L,
1.0E246L,
1.0E247L,
1.0E248L,
1.0E249L,
1.0E250L,
1.0E251L,
1.0E252L,
1.0E253L,
1.0E254L,
1.0E255L,
1.0E256L,
1.0E257L,
1.0E258L,
1.0E259L,
1.0E260L,
1.0E261L,
1.0E262L,
1.0E263L,
1.0E264L,
1.0E265L,
1.0E266L,
1.0E267L,
1.0E268L,
1.0E269L,
1.0E270L,
1.0E271L,
1.0E272L,
1.0E273L,
1.0E274L,
1.0E275L,
1.0E276L,
1.0E277L,
1.0E278L,
1.0E279L,
1.0E280L,
1.0E281L,
1.0E282L,
1.0E283L,
1.0E284L,
1.0E285L,
1.0E286L,
1.0E287L,
1.0E288L,
1.0E289L,
1.0E290L,
1.0E291L,
1.0E292L,
1.0E293L,
1.0E294L,
1.0E295L,
1.0E296L,
1.0E297L,
1.0E298L,
1.0E299L,
1.0E300L
};

#endif
