% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card_body}
\alias{card_body}
\alias{card_body_fill}
\alias{card_title}
\alias{card_header}
\alias{card_footer}
\alias{card_image}
\alias{as.card_item}
\alias{is.card_item}
\title{Card items}
\usage{
card_body(..., fill = FALSE, height = NULL, class = NULL)

card_body_fill(
  ...,
  gap = NULL,
  max_height = NULL,
  max_height_full_screen = max_height,
  min_height = NULL,
  class = NULL
)

card_title(..., container = htmltools::h5)

card_header(..., class = NULL, container = htmltools::div)

card_footer(..., class = NULL)

card_image(
  file,
  ...,
  href = NULL,
  border_radius = c("top", "bottom", "all", "none"),
  mime_type = NULL,
  class = NULL,
  height = NULL,
  width = NULL,
  container = card_body_fill
)

as.card_item(x)

is.card_item(x)
}
\arguments{
\item{...}{Unnamed arguments can be any valid child of an \link[htmltools:builder]{htmltools tag}. Named arguments become HTML attributes on returned
UI element.}

\item{fill}{whether to allow the \code{card_body()} to grow and shrink to fit its
\code{card()}.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}).}

\item{class}{Additional CSS classes for the returned UI element.}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}.}

\item{max_height, max_height_full_screen, min_height}{Any valid \link[htmltools:validateCssUnit]{CSS length unit}.}

\item{container}{a function to generate an HTML element to contain the image.}

\item{file}{a file path pointing an image. The image will be base64 encoded
and provided to the \code{src} attribute of the \verb{<img>}. Alternatively, you may
set this value to \code{NULL} and provide the \code{src} yourself.}

\item{href}{an optional URL to link to.}

\item{border_radius}{where to apply \code{border-radius} on the image.}

\item{mime_type}{the mime type of the \code{file}.}

\item{width}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g., \code{width="100\%"}).}

\item{x}{an object to test (or coerce to) a card item.}
}
\value{
An \code{\link[htmltools:builder]{htmltools::div()}} tag.
}
\description{
Components designed to be provided as direct children of a \code{\link[=card]{card()}}. For a
general overview of the \code{\link[=card]{card()}} API, see \href{https://rstudio.github.io/bslib/articles/cards.html}{this article}.
}
\section{Functions}{
\itemize{
\item \code{card_body()}: A general container for the "main content" of a \code{\link[=card]{card()}}.

\item \code{card_body_fill()}: Similar to \code{card_body(fill = TRUE)}, but also marks the
return element as a "fill container" (via \code{\link[htmltools:bindFillRole]{htmltools::bindFillRole()}}) so
that its immediate children are allowed to grow and shrink to fit.

\item \code{card_title()}: Similar to \code{card_header()} but without the border and background color.

\item \code{card_header()}: A header (with border and background color) for the \code{card()}. Typically appears before a \code{card_body()}.

\item \code{card_footer()}: A header (with border and background color) for the \code{card()}. Typically appears after a \code{card_body()}.

\item \code{card_image()}: Include static (i.e., pre-generated) images.

\item \code{as.card_item()}: Mark an object as a card item. This will prevent the
\code{\link[=card]{card()}} from putting the object inside a \code{wrapper} (i.e., a
\code{card_body()}).

}}
\seealso{
\code{\link[=card]{card()}} for creating a card component.

\code{\link[=navs_tab_card]{navs_tab_card()}} for cards with multiple tabs.

\code{\link[=layout_column_wrap]{layout_column_wrap()}} for laying out multiple cards (or multiple
columns inside a card).
}
