% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatCor}
\alias{spatCor}
\alias{spatCor,SpatialExperiment-method}
\title{Compute Spatial Autocorrelation for SpatialExperiment objects}
\usage{
\S4method{spatCor}{SpatialExperiment}(spe, na.rm = FALSE, alternative = "two.sided", squared = TRUE)
}
\arguments{
\item{spe}{An object of \code{SpatialExperiment} class.}

\item{na.rm}{A logical indicating whether missing values should be removed.}

\item{alternative}{A character string specifying the alternative hypothesis tested against the null hypothesis of no spatial autocorrelation;
must be one of "two.sided", "less", or "greater", or any unambiguous abbreviation of these.}

\item{squared}{A logical indicating whether the inverse distance weight matrix should be squared or not.}
}
\value{
A \code{data.frame} with the same row names as the original \code{SpatialExperiment} object.
Columns include the observed Moran's I statistic, the expected Moran's I statistic under no spatial autocorrelation, the expected
standard deviation under no spatial autocorrelation, and the p-value of the test.
}
\description{
Computes spatial autocorrelation using Moran's I statistic
for a \code{SpatialExperiment} object, using an inverse squared distance weight matrix as default,
or an inverse distance weight matrix as an alternative. It also tests for spatial autocorrelation
assuming normality.
}
