; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define void @long_chain_ambiguous_i64_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, i64* %a, i64* %b, i64* %c, i64* %result) {
; MIPS32-LABEL: long_chain_ambiguous_i64_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -72
; MIPS32-NEXT:    .cfi_def_cfa_offset 72
; MIPS32-NEXT:    addiu $1, $sp, 88
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    addiu $2, $sp, 92
; MIPS32-NEXT:    lw $2, 0($2)
; MIPS32-NEXT:    addiu $3, $sp, 96
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    ori $8, $zero, 1
; MIPS32-NEXT:    and $8, $4, $8
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $4, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $8, $BB0_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %pre.PHI.1
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB0_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.2: # %pre.PHI.1.0
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB0_5
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_4: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_5: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB0_6: # %b.PHI.1
; MIPS32-NEXT:    ldc1 $f0, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB0_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.7: # %b.PHI.1
; MIPS32-NEXT:    j $BB0_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_8: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_9: # %pre.PHI.2
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB0_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %pre.PHI.2
; MIPS32-NEXT:    j $BB0_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_11: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB0_13
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_12: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB0_13: # %b.PHI.2
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB0_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.14: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB0_15: # %b.PHI.3
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f2, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $3, $2, $1
; MIPS32-NEXT:    movn.d $f0, $f2, $3
; MIPS32-NEXT:    lw $3, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $3, $1
; MIPS32-NEXT:    mov.d $f4, $f2
; MIPS32-NEXT:    movn.d $f4, $f0, $1
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f4, 0($1)
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load i64, i64* %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load i64, i64* %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load i64, i64* %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi i64 [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store i64 %phi1, i64* %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load i64, i64* %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load i64, i64* %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi i64 [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store i64 %phi2, i64* %result
  ret void

b.PHI.3:
  %phi3 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, i64 %phi3, i64 %phi4
  %sel_3_1.2 = select i1 %cnd1, i64 %sel_1.2, i64 %phi3
  store i64 %sel_3_1.2, i64* %result
  store i64 %phi3, i64* %result
  ret void

}

define void @long_chain_i64_in_gpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, i64* %a, i64* %b, i64* %c, i64* %result) {
; MIPS32-LABEL: long_chain_i64_in_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -80
; MIPS32-NEXT:    .cfi_def_cfa_offset 80
; MIPS32-NEXT:    addiu $1, $sp, 96
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    addiu $2, $sp, 100
; MIPS32-NEXT:    lw $2, 0($2)
; MIPS32-NEXT:    addiu $3, $sp, 104
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    ori $8, $zero, 0
; MIPS32-NEXT:    ori $9, $zero, 1
; MIPS32-NEXT:    and $9, $4, $9
; MIPS32-NEXT:    sw $1, 76($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $4, 72($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $8, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $9, $BB1_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %pre.PHI.1
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB1_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.2: # %pre.PHI.1.0
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB1_5
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    sw $2, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_4: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    sw $2, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_5: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    sw $2, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 40($sp) # 4-byte Folded Spill
; MIPS32-NEXT:  $BB1_6: # %b.PHI.1
; MIPS32-NEXT:    lw $1, 40($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ori $3, $zero, 1
; MIPS32-NEXT:    lw $4, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $3, $4, $3
; MIPS32-NEXT:    move $5, $2
; MIPS32-NEXT:    move $6, $1
; MIPS32-NEXT:    lw $7, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $8, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $1, 36($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 32($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $8, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $3, $BB1_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.7: # %b.PHI.1
; MIPS32-NEXT:    j $BB1_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_8: # %b.PHI.1.end
; MIPS32-NEXT:    lw $1, 32($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $1, 0($2)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $2, $3
; MIPS32-NEXT:    lw $4, 36($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $4, 0($3)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_9: # %pre.PHI.2
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB1_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %pre.PHI.2
; MIPS32-NEXT:    j $BB1_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_11: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    sw $2, 12($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 8($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    j $BB1_13
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_12: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 0($1)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $1, $3
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    sw $2, 12($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 8($sp) # 4-byte Folded Spill
; MIPS32-NEXT:  $BB1_13: # %b.PHI.2
; MIPS32-NEXT:    lw $1, 8($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ori $3, $zero, 1
; MIPS32-NEXT:    lw $4, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $3, $4, $3
; MIPS32-NEXT:    move $5, $2
; MIPS32-NEXT:    move $6, $1
; MIPS32-NEXT:    move $7, $2
; MIPS32-NEXT:    move $8, $1
; MIPS32-NEXT:    sw $1, 4($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 0($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $8, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $3, $BB1_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.14: # %b.PHI.2.end
; MIPS32-NEXT:    lw $1, 0($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $1, 0($2)
; MIPS32-NEXT:    ori $3, $zero, 4
; MIPS32-NEXT:    addu $3, $2, $3
; MIPS32-NEXT:    lw $4, 4($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $4, 0($3)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB1_15: # %b.PHI.3
; MIPS32-NEXT:    lw $1, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $2, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $3, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $4, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ori $5, $zero, 1
; MIPS32-NEXT:    lw $6, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $7, $6, $5
; MIPS32-NEXT:    movn $2, $4, $7
; MIPS32-NEXT:    movn $1, $3, $7
; MIPS32-NEXT:    lw $7, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $5, $7, $5
; MIPS32-NEXT:    move $8, $4
; MIPS32-NEXT:    movn $8, $2, $5
; MIPS32-NEXT:    move $2, $3
; MIPS32-NEXT:    movn $2, $1, $5
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sw $8, 0($1)
; MIPS32-NEXT:    ori $5, $zero, 4
; MIPS32-NEXT:    addu $5, $1, $5
; MIPS32-NEXT:    sw $2, 0($5)
; MIPS32-NEXT:    sw $4, 0($1)
; MIPS32-NEXT:    ori $2, $zero, 4
; MIPS32-NEXT:    addu $2, $1, $2
; MIPS32-NEXT:    sw $3, 0($2)
; MIPS32-NEXT:    addiu $sp, $sp, 80
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load i64, i64* %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load i64, i64* %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load i64, i64* %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi i64 [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store i64 %phi1, i64* %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load i64, i64* %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load i64, i64* %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi i64 [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store i64 %phi2, i64* %result
  ret void

b.PHI.3:
  %phi3 = phi i64 [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi i64 [ %phi2, %b.PHI.2], [ 0, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, i64 %phi3, i64 %phi4
  %sel_3_1.2 = select i1 %cnd1, i64 %sel_1.2, i64 %phi3
  store i64 %sel_3_1.2, i64* %result
  store i64 %phi3, i64* %result
  ret void
}

define void @long_chain_ambiguous_double_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, double* %a, double* %b, double* %c, double* %result) {
; MIPS32-LABEL: long_chain_ambiguous_double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -72
; MIPS32-NEXT:    .cfi_def_cfa_offset 72
; MIPS32-NEXT:    addiu $1, $sp, 88
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    addiu $2, $sp, 92
; MIPS32-NEXT:    lw $2, 0($2)
; MIPS32-NEXT:    addiu $3, $sp, 96
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    ori $8, $zero, 1
; MIPS32-NEXT:    and $8, $4, $8
; MIPS32-NEXT:    sw $1, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $4, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 56($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 52($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 48($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 44($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    bnez $8, $BB2_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %pre.PHI.1
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB2_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.2: # %pre.PHI.1.0
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB2_5
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_4: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_5: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 48($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB2_6: # %b.PHI.1
; MIPS32-NEXT:    ldc1 $f0, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    sdc1 $f0, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB2_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.7: # %b.PHI.1
; MIPS32-NEXT:    j $BB2_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_8: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_9: # %pre.PHI.2
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB2_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %pre.PHI.2
; MIPS32-NEXT:    j $BB2_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_11: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 52($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB2_13
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_12: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB2_13: # %b.PHI.2
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB2_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.14: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB2_15: # %b.PHI.3
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f2, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 56($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $3, $2, $1
; MIPS32-NEXT:    movn.d $f0, $f2, $3
; MIPS32-NEXT:    lw $3, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $3, $1
; MIPS32-NEXT:    mov.d $f4, $f2
; MIPS32-NEXT:    movn.d $f4, $f0, $1
; MIPS32-NEXT:    lw $1, 44($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f4, 0($1)
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 72
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load double, double* %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load double, double* %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load double, double* %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi double [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store double %phi1, double* %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load double, double* %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load double, double* %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi double [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store double %phi2, double* %result
  ret void

b.PHI.3:
  %phi3 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, double %phi3, double %phi4
  %sel_3_1.2 = select i1 %cnd1, double %sel_1.2, double %phi3
  store double %sel_3_1.2, double* %result
  store double %phi3, double* %result
  ret void
}


define void @long_chain_double_in_fpr(i1 %cnd0, i1 %cnd1, i1 %cnd2, double* %a, double* %b, double* %c, double* %result) {
; MIPS32-LABEL: long_chain_double_in_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -88
; MIPS32-NEXT:    .cfi_def_cfa_offset 88
; MIPS32-NEXT:    addiu $1, $sp, 104
; MIPS32-NEXT:    lw $1, 0($1)
; MIPS32-NEXT:    addiu $2, $sp, 108
; MIPS32-NEXT:    lw $2, 0($2)
; MIPS32-NEXT:    addiu $3, $sp, 112
; MIPS32-NEXT:    lw $3, 0($3)
; MIPS32-NEXT:    ori $8, $zero, 0
; MIPS32-NEXT:    ori $9, $zero, 0
; MIPS32-NEXT:    mtc1 $9, $f0
; MIPS32-NEXT:    mtc1 $8, $f1
; MIPS32-NEXT:    ori $8, $zero, 1
; MIPS32-NEXT:    and $8, $4, $8
; MIPS32-NEXT:    sw $1, 84($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $4, 80($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $5, 76($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $6, 72($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $7, 68($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $2, 64($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $3, 60($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f0, 48($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $8, $BB3_9
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.1: # %pre.PHI.1
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB3_4
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.2: # %pre.PHI.1.0
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB3_5
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.3: # %b.PHI.1.0
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_4: # %b.PHI.1.1
; MIPS32-NEXT:    lw $1, 84($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_6
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_5: # %b.PHI.1.2
; MIPS32-NEXT:    lw $1, 64($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 40($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB3_6: # %b.PHI.1
; MIPS32-NEXT:    ldc1 $f0, 40($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    ldc1 $f4, 48($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 32($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f4, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB3_8
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.7: # %b.PHI.1
; MIPS32-NEXT:    j $BB3_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_8: # %b.PHI.1.end
; MIPS32-NEXT:    ldc1 $f0, 32($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_9: # %pre.PHI.2
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 80($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    bnez $1, $BB3_11
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.10: # %pre.PHI.2
; MIPS32-NEXT:    j $BB3_12
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_11: # %b.PHI.2.0
; MIPS32-NEXT:    lw $1, 68($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    j $BB3_13
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_12: # %b.PHI.2.1
; MIPS32-NEXT:    lw $1, 84($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f0, 0($1)
; MIPS32-NEXT:    sdc1 $f0, 8($sp) # 8-byte Folded Spill
; MIPS32-NEXT:  $BB3_13: # %b.PHI.2
; MIPS32-NEXT:    ldc1 $f0, 8($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $2, $1
; MIPS32-NEXT:    mov.d $f2, $f0
; MIPS32-NEXT:    mov.d $f4, $f0
; MIPS32-NEXT:    sdc1 $f0, 0($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f2, 24($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    sdc1 $f4, 16($sp) # 8-byte Folded Spill
; MIPS32-NEXT:    bnez $1, $BB3_15
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  # %bb.14: # %b.PHI.2.end
; MIPS32-NEXT:    ldc1 $f0, 0($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f0, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
; MIPS32-NEXT:  $BB3_15: # %b.PHI.3
; MIPS32-NEXT:    ldc1 $f0, 16($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ldc1 $f2, 24($sp) # 8-byte Folded Reload
; MIPS32-NEXT:    ori $1, $zero, 1
; MIPS32-NEXT:    lw $2, 72($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $3, $2, $1
; MIPS32-NEXT:    movn.d $f0, $f2, $3
; MIPS32-NEXT:    lw $3, 76($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    and $1, $3, $1
; MIPS32-NEXT:    mov.d $f4, $f2
; MIPS32-NEXT:    movn.d $f4, $f0, $1
; MIPS32-NEXT:    lw $1, 60($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    sdc1 $f4, 0($1)
; MIPS32-NEXT:    sdc1 $f2, 0($1)
; MIPS32-NEXT:    addiu $sp, $sp, 88
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  br i1 %cnd0, label %pre.PHI.2, label %pre.PHI.1

pre.PHI.1:
  br i1 %cnd1, label %b.PHI.1.1, label %pre.PHI.1.0

pre.PHI.1.0:
  br i1 %cnd2, label %b.PHI.1.2, label %b.PHI.1.0

b.PHI.1.0:
  %phi1.0 = load double, double* %a
  br label %b.PHI.1

b.PHI.1.1:
  %phi1.1 = load double, double* %b
  br label %b.PHI.1

b.PHI.1.2:
  %phi1.2 = load double, double* %c
  br label %b.PHI.1

b.PHI.1:
  %phi1 = phi double [ %phi1.0, %b.PHI.1.0 ], [ %phi1.1, %b.PHI.1.1 ], [ %phi1.2, %b.PHI.1.2 ]
  br i1 %cnd2, label %b.PHI.1.end, label %b.PHI.3

b.PHI.1.end:
  store double %phi1, double* %result
  ret void

pre.PHI.2:
  br i1 %cnd0, label %b.PHI.2.0, label %b.PHI.2.1

b.PHI.2.0:
  %phi2.0 = load double, double* %a
  br label %b.PHI.2

b.PHI.2.1:
  %phi2.1 = load double, double* %b
  br label %b.PHI.2

b.PHI.2:
  %phi2 = phi double [ %phi2.0, %b.PHI.2.0 ], [ %phi2.1, %b.PHI.2.1 ]
   br i1 %cnd1, label %b.PHI.3, label %b.PHI.2.end

b.PHI.2.end:
  store double %phi2, double* %result
  ret void

b.PHI.3:
  %phi3 = phi double [ %phi2, %b.PHI.2], [ %phi1, %b.PHI.1 ]
  %phi4 = phi double [ %phi2, %b.PHI.2], [ 0.0, %b.PHI.1 ]
  %sel_1.2 = select i1 %cnd2, double %phi3, double %phi4
  %sel_3_1.2 = select i1 %cnd1, double %sel_1.2, double %phi3
  store double %sel_3_1.2, double* %result
  store double %phi3, double* %result
  ret void
}

