// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: blendpd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
blendpd $0, 485498096, %xmm6

// CHECK: blendpd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x74,0x82,0x40,0x00]
blendpd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: blendpd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x74,0x82,0xc0,0x00]
blendpd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: blendpd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x74,0x02,0x40,0x00]
blendpd $0, 64(%rdx,%rax), %xmm6

// CHECK: blendpd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x72,0x40,0x00]
blendpd $0, 64(%rdx), %xmm6

// CHECK: blendpd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0x32,0x00]
blendpd $0, (%rdx), %xmm6

// CHECK: blendpd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0d,0xf6,0x00]
blendpd $0, %xmm6, %xmm6

// CHECK: blendps $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
blendps $0, 485498096, %xmm6

// CHECK: blendps $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x74,0x82,0x40,0x00]
blendps $0, 64(%rdx,%rax,4), %xmm6

// CHECK: blendps $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x74,0x82,0xc0,0x00]
blendps $0, -64(%rdx,%rax,4), %xmm6

// CHECK: blendps $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x74,0x02,0x40,0x00]
blendps $0, 64(%rdx,%rax), %xmm6

// CHECK: blendps $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x72,0x40,0x00]
blendps $0, 64(%rdx), %xmm6

// CHECK: blendps $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0x32,0x00]
blendps $0, (%rdx), %xmm6

// CHECK: blendps $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0c,0xf6,0x00]
blendps $0, %xmm6, %xmm6

// CHECK: blendvpd %xmm0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
blendvpd %xmm0, 485498096, %xmm6

// CHECK: blendvpd %xmm0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x74,0x82,0x40]
blendvpd %xmm0, 64(%rdx,%rax,4), %xmm6

// CHECK: blendvpd %xmm0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x74,0x82,0xc0]
blendvpd %xmm0, -64(%rdx,%rax,4), %xmm6

// CHECK: blendvpd %xmm0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x74,0x02,0x40]
blendvpd %xmm0, 64(%rdx,%rax), %xmm6

// CHECK: blendvpd %xmm0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x72,0x40]
blendvpd %xmm0, 64(%rdx), %xmm6

// CHECK: blendvpd %xmm0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0x32]
blendvpd %xmm0, (%rdx), %xmm6

// CHECK: blendvpd %xmm0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x15,0xf6]
blendvpd %xmm0, %xmm6, %xmm6

// CHECK: blendvps %xmm0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
blendvps %xmm0, 485498096, %xmm6

// CHECK: blendvps %xmm0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x74,0x82,0x40]
blendvps %xmm0, 64(%rdx,%rax,4), %xmm6

// CHECK: blendvps %xmm0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x74,0x82,0xc0]
blendvps %xmm0, -64(%rdx,%rax,4), %xmm6

// CHECK: blendvps %xmm0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x74,0x02,0x40]
blendvps %xmm0, 64(%rdx,%rax), %xmm6

// CHECK: blendvps %xmm0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x72,0x40]
blendvps %xmm0, 64(%rdx), %xmm6

// CHECK: blendvps %xmm0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0x32]
blendvps %xmm0, (%rdx), %xmm6

// CHECK: blendvps %xmm0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x14,0xf6]
blendvps %xmm0, %xmm6, %xmm6

// CHECK: dppd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
dppd $0, 485498096, %xmm6

// CHECK: dppd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x74,0x82,0x40,0x00]
dppd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: dppd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x74,0x82,0xc0,0x00]
dppd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: dppd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x74,0x02,0x40,0x00]
dppd $0, 64(%rdx,%rax), %xmm6

// CHECK: dppd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x72,0x40,0x00]
dppd $0, 64(%rdx), %xmm6

// CHECK: dppd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0x32,0x00]
dppd $0, (%rdx), %xmm6

// CHECK: dppd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x41,0xf6,0x00]
dppd $0, %xmm6, %xmm6

// CHECK: dpps $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
dpps $0, 485498096, %xmm6

// CHECK: dpps $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x74,0x82,0x40,0x00]
dpps $0, 64(%rdx,%rax,4), %xmm6

// CHECK: dpps $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x74,0x82,0xc0,0x00]
dpps $0, -64(%rdx,%rax,4), %xmm6

// CHECK: dpps $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x74,0x02,0x40,0x00]
dpps $0, 64(%rdx,%rax), %xmm6

// CHECK: dpps $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x72,0x40,0x00]
dpps $0, 64(%rdx), %xmm6

// CHECK: dpps $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0x32,0x00]
dpps $0, (%rdx), %xmm6

// CHECK: dpps $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x40,0xf6,0x00]
dpps $0, %xmm6, %xmm6

// CHECK: extractps $0, %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
extractps $0, %xmm6, 485498096

// CHECK: extractps $0, %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x72,0x40,0x00]
extractps $0, %xmm6, 64(%rdx)

// CHECK: extractps $0, %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x74,0x82,0x40,0x00]
extractps $0, %xmm6, 64(%rdx,%rax,4)

// CHECK: extractps $0, %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x74,0x82,0xc0,0x00]
extractps $0, %xmm6, -64(%rdx,%rax,4)

// CHECK: extractps $0, %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x74,0x02,0x40,0x00]
extractps $0, %xmm6, 64(%rdx,%rax)

// CHECK: extractps $0, %xmm6, %r13d
// CHECK: encoding: [0x66,0x41,0x0f,0x3a,0x17,0xf5,0x00]
extractps $0, %xmm6, %r13d

// CHECK: extractps $0, %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x17,0x32,0x00]
extractps $0, %xmm6, (%rdx)

// CHECK: insertps $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
insertps $0, 485498096, %xmm6

// CHECK: insertps $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x74,0x82,0x40,0x00]
insertps $0, 64(%rdx,%rax,4), %xmm6

// CHECK: insertps $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x74,0x82,0xc0,0x00]
insertps $0, -64(%rdx,%rax,4), %xmm6

// CHECK: insertps $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x74,0x02,0x40,0x00]
insertps $0, 64(%rdx,%rax), %xmm6

// CHECK: insertps $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x72,0x40,0x00]
insertps $0, 64(%rdx), %xmm6

// CHECK: insertps $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0x32,0x00]
insertps $0, (%rdx), %xmm6

// CHECK: insertps $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x21,0xf6,0x00]
insertps $0, %xmm6, %xmm6

// CHECK: movntdqa 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movntdqa 485498096, %xmm6

// CHECK: movntdqa 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x74,0x82,0x40]
movntdqa 64(%rdx,%rax,4), %xmm6

// CHECK: movntdqa -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x74,0x82,0xc0]
movntdqa -64(%rdx,%rax,4), %xmm6

// CHECK: movntdqa 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x74,0x02,0x40]
movntdqa 64(%rdx,%rax), %xmm6

// CHECK: movntdqa 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x72,0x40]
movntdqa 64(%rdx), %xmm6

// CHECK: movntdqa (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2a,0x32]
movntdqa (%rdx), %xmm6

// CHECK: mpsadbw $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
mpsadbw $0, 485498096, %xmm6

// CHECK: mpsadbw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x74,0x82,0x40,0x00]
mpsadbw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: mpsadbw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x74,0x82,0xc0,0x00]
mpsadbw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: mpsadbw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x74,0x02,0x40,0x00]
mpsadbw $0, 64(%rdx,%rax), %xmm6

// CHECK: mpsadbw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x72,0x40,0x00]
mpsadbw $0, 64(%rdx), %xmm6

// CHECK: mpsadbw $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0x32,0x00]
mpsadbw $0, (%rdx), %xmm6

// CHECK: mpsadbw $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x42,0xf6,0x00]
mpsadbw $0, %xmm6, %xmm6

// CHECK: packusdw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
packusdw 485498096, %xmm6

// CHECK: packusdw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x74,0x82,0x40]
packusdw 64(%rdx,%rax,4), %xmm6

// CHECK: packusdw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x74,0x82,0xc0]
packusdw -64(%rdx,%rax,4), %xmm6

// CHECK: packusdw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x74,0x02,0x40]
packusdw 64(%rdx,%rax), %xmm6

// CHECK: packusdw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x72,0x40]
packusdw 64(%rdx), %xmm6

// CHECK: packusdw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0x32]
packusdw (%rdx), %xmm6

// CHECK: packusdw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x2b,0xf6]
packusdw %xmm6, %xmm6

// CHECK: pblendvb %xmm0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pblendvb %xmm0, 485498096, %xmm6

// CHECK: pblendvb %xmm0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x74,0x82,0x40]
pblendvb %xmm0, 64(%rdx,%rax,4), %xmm6

// CHECK: pblendvb %xmm0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x74,0x82,0xc0]
pblendvb %xmm0, -64(%rdx,%rax,4), %xmm6

// CHECK: pblendvb %xmm0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x74,0x02,0x40]
pblendvb %xmm0, 64(%rdx,%rax), %xmm6

// CHECK: pblendvb %xmm0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x72,0x40]
pblendvb %xmm0, 64(%rdx), %xmm6

// CHECK: pblendvb %xmm0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0x32]
pblendvb %xmm0, (%rdx), %xmm6

// CHECK: pblendvb %xmm0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x10,0xf6]
pblendvb %xmm0, %xmm6, %xmm6

// CHECK: pblendw $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pblendw $0, 485498096, %xmm6

// CHECK: pblendw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x74,0x82,0x40,0x00]
pblendw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pblendw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x74,0x82,0xc0,0x00]
pblendw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pblendw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x74,0x02,0x40,0x00]
pblendw $0, 64(%rdx,%rax), %xmm6

// CHECK: pblendw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x72,0x40,0x00]
pblendw $0, 64(%rdx), %xmm6

// CHECK: pblendw $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0x32,0x00]
pblendw $0, (%rdx), %xmm6

// CHECK: pblendw $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0e,0xf6,0x00]
pblendw $0, %xmm6, %xmm6

// CHECK: pcmpeqq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpeqq 485498096, %xmm6

// CHECK: pcmpeqq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x74,0x82,0x40]
pcmpeqq 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x74,0x82,0xc0]
pcmpeqq -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x74,0x02,0x40]
pcmpeqq 64(%rdx,%rax), %xmm6

// CHECK: pcmpeqq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x72,0x40]
pcmpeqq 64(%rdx), %xmm6

// CHECK: pcmpeqq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0x32]
pcmpeqq (%rdx), %xmm6

// CHECK: pcmpeqq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x29,0xf6]
pcmpeqq %xmm6, %xmm6

// CHECK: pextrb $0, %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pextrb $0, %xmm6, 485498096

// CHECK: pextrb $0, %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x72,0x40,0x00]
pextrb $0, %xmm6, 64(%rdx)

// CHECK: pextrb $0, %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x74,0x82,0x40,0x00]
pextrb $0, %xmm6, 64(%rdx,%rax,4)

// CHECK: pextrb $0, %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x74,0x82,0xc0,0x00]
pextrb $0, %xmm6, -64(%rdx,%rax,4)

// CHECK: pextrb $0, %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x74,0x02,0x40,0x00]
pextrb $0, %xmm6, 64(%rdx,%rax)

// CHECK: pextrb $0, %xmm6, %r13d
// CHECK: encoding: [0x66,0x41,0x0f,0x3a,0x14,0xf5,0x00]
pextrb $0, %xmm6, %r13d

// CHECK: pextrb $0, %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x14,0x32,0x00]
pextrb $0, %xmm6, (%rdx)

// CHECK: pextrd $0, %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pextrd $0, %xmm6, 485498096

// CHECK: pextrd $0, %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x72,0x40,0x00]
pextrd $0, %xmm6, 64(%rdx)

// CHECK: pextrd $0, %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x74,0x82,0x40,0x00]
pextrd $0, %xmm6, 64(%rdx,%rax,4)

// CHECK: pextrd $0, %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x74,0x82,0xc0,0x00]
pextrd $0, %xmm6, -64(%rdx,%rax,4)

// CHECK: pextrd $0, %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x74,0x02,0x40,0x00]
pextrd $0, %xmm6, 64(%rdx,%rax)

// CHECK: pextrd $0, %xmm6, %r13d
// CHECK: encoding: [0x66,0x41,0x0f,0x3a,0x16,0xf5,0x00]
pextrd $0, %xmm6, %r13d

// CHECK: pextrd $0, %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x16,0x32,0x00]
pextrd $0, %xmm6, (%rdx)

// CHECK: pextrq $0, %xmm6, 485498096
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pextrq $0, %xmm6, 485498096

// CHECK: pextrq $0, %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x72,0x40,0x00]
pextrq $0, %xmm6, 64(%rdx)

// CHECK: pextrq $0, %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x74,0x82,0x40,0x00]
pextrq $0, %xmm6, 64(%rdx,%rax,4)

// CHECK: pextrq $0, %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x74,0x82,0xc0,0x00]
pextrq $0, %xmm6, -64(%rdx,%rax,4)

// CHECK: pextrq $0, %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x74,0x02,0x40,0x00]
pextrq $0, %xmm6, 64(%rdx,%rax)

// CHECK: pextrq $0, %xmm6, %r15
// CHECK: encoding: [0x66,0x49,0x0f,0x3a,0x16,0xf7,0x00]
pextrq $0, %xmm6, %r15

// CHECK: pextrq $0, %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x16,0x32,0x00]
pextrq $0, %xmm6, (%rdx)

// CHECK: pextrw $0, %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pextrw $0, %xmm6, 485498096

// CHECK: pextrw $0, %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x72,0x40,0x00]
pextrw $0, %xmm6, 64(%rdx)

// CHECK: pextrw $0, %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x74,0x82,0x40,0x00]
pextrw $0, %xmm6, 64(%rdx,%rax,4)

// CHECK: pextrw $0, %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x74,0x82,0xc0,0x00]
pextrw $0, %xmm6, -64(%rdx,%rax,4)

// CHECK: pextrw $0, %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x74,0x02,0x40,0x00]
pextrw $0, %xmm6, 64(%rdx,%rax)

// CHECK: pextrw $0, %xmm6, %r13d
// CHECK: encoding: [0x66,0x44,0x0f,0xc5,0xee,0x00]
pextrw $0, %xmm6, %r13d

// CHECK: pextrw $0, %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x3a,0x15,0x32,0x00]
pextrw $0, %xmm6, (%rdx)

// CHECK: phminposuw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
phminposuw 485498096, %xmm6

// CHECK: phminposuw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x74,0x82,0x40]
phminposuw 64(%rdx,%rax,4), %xmm6

// CHECK: phminposuw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x74,0x82,0xc0]
phminposuw -64(%rdx,%rax,4), %xmm6

// CHECK: phminposuw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x74,0x02,0x40]
phminposuw 64(%rdx,%rax), %xmm6

// CHECK: phminposuw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x72,0x40]
phminposuw 64(%rdx), %xmm6

// CHECK: phminposuw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0x32]
phminposuw (%rdx), %xmm6

// CHECK: phminposuw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x41,0xf6]
phminposuw %xmm6, %xmm6

// CHECK: pinsrb $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrb $0, 485498096, %xmm6

// CHECK: pinsrb $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x74,0x82,0x40,0x00]
pinsrb $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pinsrb $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x74,0x82,0xc0,0x00]
pinsrb $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pinsrb $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x74,0x02,0x40,0x00]
pinsrb $0, 64(%rdx,%rax), %xmm6

// CHECK: pinsrb $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x72,0x40,0x00]
pinsrb $0, 64(%rdx), %xmm6

// CHECK: pinsrb $0, %r13d, %xmm6
// CHECK: encoding: [0x66,0x41,0x0f,0x3a,0x20,0xf5,0x00]
pinsrb $0, %r13d, %xmm6

// CHECK: pinsrb $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x20,0x32,0x00]
pinsrb $0, (%rdx), %xmm6

// CHECK: pinsrd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrd $0, 485498096, %xmm6

// CHECK: pinsrd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x74,0x82,0x40,0x00]
pinsrd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pinsrd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x74,0x82,0xc0,0x00]
pinsrd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pinsrd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x74,0x02,0x40,0x00]
pinsrd $0, 64(%rdx,%rax), %xmm6

// CHECK: pinsrd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x72,0x40,0x00]
pinsrd $0, 64(%rdx), %xmm6

// CHECK: pinsrd $0, %r13d, %xmm6
// CHECK: encoding: [0x66,0x41,0x0f,0x3a,0x22,0xf5,0x00]
pinsrd $0, %r13d, %xmm6

// CHECK: pinsrd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x22,0x32,0x00]
pinsrd $0, (%rdx), %xmm6

// CHECK: pinsrq $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrq $0, 485498096, %xmm6

// CHECK: pinsrq $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x74,0x82,0x40,0x00]
pinsrq $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pinsrq $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x74,0x82,0xc0,0x00]
pinsrq $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pinsrq $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x74,0x02,0x40,0x00]
pinsrq $0, 64(%rdx,%rax), %xmm6

// CHECK: pinsrq $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x72,0x40,0x00]
pinsrq $0, 64(%rdx), %xmm6

// CHECK: pinsrq $0, %r15, %xmm6
// CHECK: encoding: [0x66,0x49,0x0f,0x3a,0x22,0xf7,0x00]
pinsrq $0, %r15, %xmm6

// CHECK: pinsrq $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x48,0x0f,0x3a,0x22,0x32,0x00]
pinsrq $0, (%rdx), %xmm6

// CHECK: pmaxsb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxsb 485498096, %xmm6

// CHECK: pmaxsb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x74,0x82,0x40]
pmaxsb 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x74,0x82,0xc0]
pmaxsb -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x74,0x02,0x40]
pmaxsb 64(%rdx,%rax), %xmm6

// CHECK: pmaxsb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x72,0x40]
pmaxsb 64(%rdx), %xmm6

// CHECK: pmaxsb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0x32]
pmaxsb (%rdx), %xmm6

// CHECK: pmaxsb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3c,0xf6]
pmaxsb %xmm6, %xmm6

// CHECK: pmaxsd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxsd 485498096, %xmm6

// CHECK: pmaxsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x74,0x82,0x40]
pmaxsd 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x74,0x82,0xc0]
pmaxsd -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x74,0x02,0x40]
pmaxsd 64(%rdx,%rax), %xmm6

// CHECK: pmaxsd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x72,0x40]
pmaxsd 64(%rdx), %xmm6

// CHECK: pmaxsd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0x32]
pmaxsd (%rdx), %xmm6

// CHECK: pmaxsd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3d,0xf6]
pmaxsd %xmm6, %xmm6

// CHECK: pmaxud 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxud 485498096, %xmm6

// CHECK: pmaxud 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x74,0x82,0x40]
pmaxud 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxud -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x74,0x82,0xc0]
pmaxud -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxud 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x74,0x02,0x40]
pmaxud 64(%rdx,%rax), %xmm6

// CHECK: pmaxud 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x72,0x40]
pmaxud 64(%rdx), %xmm6

// CHECK: pmaxud (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0x32]
pmaxud (%rdx), %xmm6

// CHECK: pmaxud %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3f,0xf6]
pmaxud %xmm6, %xmm6

// CHECK: pmaxuw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxuw 485498096, %xmm6

// CHECK: pmaxuw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x74,0x82,0x40]
pmaxuw 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxuw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x74,0x82,0xc0]
pmaxuw -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxuw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x74,0x02,0x40]
pmaxuw 64(%rdx,%rax), %xmm6

// CHECK: pmaxuw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x72,0x40]
pmaxuw 64(%rdx), %xmm6

// CHECK: pmaxuw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0x32]
pmaxuw (%rdx), %xmm6

// CHECK: pmaxuw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3e,0xf6]
pmaxuw %xmm6, %xmm6

// CHECK: pminsb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminsb 485498096, %xmm6

// CHECK: pminsb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x74,0x82,0x40]
pminsb 64(%rdx,%rax,4), %xmm6

// CHECK: pminsb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x74,0x82,0xc0]
pminsb -64(%rdx,%rax,4), %xmm6

// CHECK: pminsb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x74,0x02,0x40]
pminsb 64(%rdx,%rax), %xmm6

// CHECK: pminsb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x72,0x40]
pminsb 64(%rdx), %xmm6

// CHECK: pminsb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0x32]
pminsb (%rdx), %xmm6

// CHECK: pminsb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x38,0xf6]
pminsb %xmm6, %xmm6

// CHECK: pminsd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminsd 485498096, %xmm6

// CHECK: pminsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x74,0x82,0x40]
pminsd 64(%rdx,%rax,4), %xmm6

// CHECK: pminsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x74,0x82,0xc0]
pminsd -64(%rdx,%rax,4), %xmm6

// CHECK: pminsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x74,0x02,0x40]
pminsd 64(%rdx,%rax), %xmm6

// CHECK: pminsd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x72,0x40]
pminsd 64(%rdx), %xmm6

// CHECK: pminsd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0x32]
pminsd (%rdx), %xmm6

// CHECK: pminsd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x39,0xf6]
pminsd %xmm6, %xmm6

// CHECK: pminud 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminud 485498096, %xmm6

// CHECK: pminud 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x74,0x82,0x40]
pminud 64(%rdx,%rax,4), %xmm6

// CHECK: pminud -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x74,0x82,0xc0]
pminud -64(%rdx,%rax,4), %xmm6

// CHECK: pminud 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x74,0x02,0x40]
pminud 64(%rdx,%rax), %xmm6

// CHECK: pminud 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x72,0x40]
pminud 64(%rdx), %xmm6

// CHECK: pminud (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0x32]
pminud (%rdx), %xmm6

// CHECK: pminud %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3b,0xf6]
pminud %xmm6, %xmm6

// CHECK: pminuw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminuw 485498096, %xmm6

// CHECK: pminuw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x74,0x82,0x40]
pminuw 64(%rdx,%rax,4), %xmm6

// CHECK: pminuw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x74,0x82,0xc0]
pminuw -64(%rdx,%rax,4), %xmm6

// CHECK: pminuw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x74,0x02,0x40]
pminuw 64(%rdx,%rax), %xmm6

// CHECK: pminuw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x72,0x40]
pminuw 64(%rdx), %xmm6

// CHECK: pminuw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0x32]
pminuw (%rdx), %xmm6

// CHECK: pminuw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x3a,0xf6]
pminuw %xmm6, %xmm6

// CHECK: pmovsxbd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxbd 485498096, %xmm6

// CHECK: pmovsxbd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x74,0x82,0x40]
pmovsxbd 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x74,0x82,0xc0]
pmovsxbd -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x74,0x02,0x40]
pmovsxbd 64(%rdx,%rax), %xmm6

// CHECK: pmovsxbd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x72,0x40]
pmovsxbd 64(%rdx), %xmm6

// CHECK: pmovsxbd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0x32]
pmovsxbd (%rdx), %xmm6

// CHECK: pmovsxbd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x21,0xf6]
pmovsxbd %xmm6, %xmm6

// CHECK: pmovsxbq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxbq 485498096, %xmm6

// CHECK: pmovsxbq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x74,0x82,0x40]
pmovsxbq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x74,0x82,0xc0]
pmovsxbq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x74,0x02,0x40]
pmovsxbq 64(%rdx,%rax), %xmm6

// CHECK: pmovsxbq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x72,0x40]
pmovsxbq 64(%rdx), %xmm6

// CHECK: pmovsxbq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0x32]
pmovsxbq (%rdx), %xmm6

// CHECK: pmovsxbq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x22,0xf6]
pmovsxbq %xmm6, %xmm6

// CHECK: pmovsxbw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxbw 485498096, %xmm6

// CHECK: pmovsxbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x74,0x82,0x40]
pmovsxbw 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x74,0x82,0xc0]
pmovsxbw -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x74,0x02,0x40]
pmovsxbw 64(%rdx,%rax), %xmm6

// CHECK: pmovsxbw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x72,0x40]
pmovsxbw 64(%rdx), %xmm6

// CHECK: pmovsxbw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0x32]
pmovsxbw (%rdx), %xmm6

// CHECK: pmovsxbw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x20,0xf6]
pmovsxbw %xmm6, %xmm6

// CHECK: pmovsxdq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxdq 485498096, %xmm6

// CHECK: pmovsxdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x74,0x82,0x40]
pmovsxdq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x74,0x82,0xc0]
pmovsxdq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x74,0x02,0x40]
pmovsxdq 64(%rdx,%rax), %xmm6

// CHECK: pmovsxdq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x72,0x40]
pmovsxdq 64(%rdx), %xmm6

// CHECK: pmovsxdq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0x32]
pmovsxdq (%rdx), %xmm6

// CHECK: pmovsxdq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x25,0xf6]
pmovsxdq %xmm6, %xmm6

// CHECK: pmovsxwd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxwd 485498096, %xmm6

// CHECK: pmovsxwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x74,0x82,0x40]
pmovsxwd 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x74,0x82,0xc0]
pmovsxwd -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x74,0x02,0x40]
pmovsxwd 64(%rdx,%rax), %xmm6

// CHECK: pmovsxwd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x72,0x40]
pmovsxwd 64(%rdx), %xmm6

// CHECK: pmovsxwd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0x32]
pmovsxwd (%rdx), %xmm6

// CHECK: pmovsxwd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x23,0xf6]
pmovsxwd %xmm6, %xmm6

// CHECK: pmovsxwq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovsxwq 485498096, %xmm6

// CHECK: pmovsxwq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x74,0x82,0x40]
pmovsxwq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxwq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x74,0x82,0xc0]
pmovsxwq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovsxwq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x74,0x02,0x40]
pmovsxwq 64(%rdx,%rax), %xmm6

// CHECK: pmovsxwq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x72,0x40]
pmovsxwq 64(%rdx), %xmm6

// CHECK: pmovsxwq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0x32]
pmovsxwq (%rdx), %xmm6

// CHECK: pmovsxwq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x24,0xf6]
pmovsxwq %xmm6, %xmm6

// CHECK: pmovzxbd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxbd 485498096, %xmm6

// CHECK: pmovzxbd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x74,0x82,0x40]
pmovzxbd 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x74,0x82,0xc0]
pmovzxbd -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x74,0x02,0x40]
pmovzxbd 64(%rdx,%rax), %xmm6

// CHECK: pmovzxbd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x72,0x40]
pmovzxbd 64(%rdx), %xmm6

// CHECK: pmovzxbd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0x32]
pmovzxbd (%rdx), %xmm6

// CHECK: pmovzxbd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x31,0xf6]
pmovzxbd %xmm6, %xmm6

// CHECK: pmovzxbq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxbq 485498096, %xmm6

// CHECK: pmovzxbq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x74,0x82,0x40]
pmovzxbq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x74,0x82,0xc0]
pmovzxbq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x74,0x02,0x40]
pmovzxbq 64(%rdx,%rax), %xmm6

// CHECK: pmovzxbq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x72,0x40]
pmovzxbq 64(%rdx), %xmm6

// CHECK: pmovzxbq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0x32]
pmovzxbq (%rdx), %xmm6

// CHECK: pmovzxbq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x32,0xf6]
pmovzxbq %xmm6, %xmm6

// CHECK: pmovzxbw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxbw 485498096, %xmm6

// CHECK: pmovzxbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x74,0x82,0x40]
pmovzxbw 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x74,0x82,0xc0]
pmovzxbw -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x74,0x02,0x40]
pmovzxbw 64(%rdx,%rax), %xmm6

// CHECK: pmovzxbw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x72,0x40]
pmovzxbw 64(%rdx), %xmm6

// CHECK: pmovzxbw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0x32]
pmovzxbw (%rdx), %xmm6

// CHECK: pmovzxbw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x30,0xf6]
pmovzxbw %xmm6, %xmm6

// CHECK: pmovzxdq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxdq 485498096, %xmm6

// CHECK: pmovzxdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x74,0x82,0x40]
pmovzxdq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x74,0x82,0xc0]
pmovzxdq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x74,0x02,0x40]
pmovzxdq 64(%rdx,%rax), %xmm6

// CHECK: pmovzxdq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x72,0x40]
pmovzxdq 64(%rdx), %xmm6

// CHECK: pmovzxdq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0x32]
pmovzxdq (%rdx), %xmm6

// CHECK: pmovzxdq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x35,0xf6]
pmovzxdq %xmm6, %xmm6

// CHECK: pmovzxwd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxwd 485498096, %xmm6

// CHECK: pmovzxwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x74,0x82,0x40]
pmovzxwd 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x74,0x82,0xc0]
pmovzxwd -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x74,0x02,0x40]
pmovzxwd 64(%rdx,%rax), %xmm6

// CHECK: pmovzxwd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x72,0x40]
pmovzxwd 64(%rdx), %xmm6

// CHECK: pmovzxwd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0x32]
pmovzxwd (%rdx), %xmm6

// CHECK: pmovzxwd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x33,0xf6]
pmovzxwd %xmm6, %xmm6

// CHECK: pmovzxwq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmovzxwq 485498096, %xmm6

// CHECK: pmovzxwq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x74,0x82,0x40]
pmovzxwq 64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxwq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x74,0x82,0xc0]
pmovzxwq -64(%rdx,%rax,4), %xmm6

// CHECK: pmovzxwq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x74,0x02,0x40]
pmovzxwq 64(%rdx,%rax), %xmm6

// CHECK: pmovzxwq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x72,0x40]
pmovzxwq 64(%rdx), %xmm6

// CHECK: pmovzxwq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0x32]
pmovzxwq (%rdx), %xmm6

// CHECK: pmovzxwq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x34,0xf6]
pmovzxwq %xmm6, %xmm6

// CHECK: pmuldq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmuldq 485498096, %xmm6

// CHECK: pmuldq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x74,0x82,0x40]
pmuldq 64(%rdx,%rax,4), %xmm6

// CHECK: pmuldq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x74,0x82,0xc0]
pmuldq -64(%rdx,%rax,4), %xmm6

// CHECK: pmuldq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x74,0x02,0x40]
pmuldq 64(%rdx,%rax), %xmm6

// CHECK: pmuldq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x72,0x40]
pmuldq 64(%rdx), %xmm6

// CHECK: pmuldq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0x32]
pmuldq (%rdx), %xmm6

// CHECK: pmuldq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x28,0xf6]
pmuldq %xmm6, %xmm6

// CHECK: pmulld 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmulld 485498096, %xmm6

// CHECK: pmulld 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x74,0x82,0x40]
pmulld 64(%rdx,%rax,4), %xmm6

// CHECK: pmulld -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x74,0x82,0xc0]
pmulld -64(%rdx,%rax,4), %xmm6

// CHECK: pmulld 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x74,0x02,0x40]
pmulld 64(%rdx,%rax), %xmm6

// CHECK: pmulld 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x72,0x40]
pmulld 64(%rdx), %xmm6

// CHECK: pmulld (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0x32]
pmulld (%rdx), %xmm6

// CHECK: pmulld %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x40,0xf6]
pmulld %xmm6, %xmm6

// CHECK: ptest 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
ptest 485498096, %xmm6

// CHECK: ptest 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x74,0x82,0x40]
ptest 64(%rdx,%rax,4), %xmm6

// CHECK: ptest -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x74,0x82,0xc0]
ptest -64(%rdx,%rax,4), %xmm6

// CHECK: ptest 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x74,0x02,0x40]
ptest 64(%rdx,%rax), %xmm6

// CHECK: ptest 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x72,0x40]
ptest 64(%rdx), %xmm6

// CHECK: ptest (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0x32]
ptest (%rdx), %xmm6

// CHECK: ptest %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x38,0x17,0xf6]
ptest %xmm6, %xmm6

// CHECK: roundpd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
roundpd $0, 485498096, %xmm6

// CHECK: roundpd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x74,0x82,0x40,0x00]
roundpd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: roundpd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x74,0x82,0xc0,0x00]
roundpd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: roundpd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x74,0x02,0x40,0x00]
roundpd $0, 64(%rdx,%rax), %xmm6

// CHECK: roundpd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x72,0x40,0x00]
roundpd $0, 64(%rdx), %xmm6

// CHECK: roundpd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0x32,0x00]
roundpd $0, (%rdx), %xmm6

// CHECK: roundpd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x09,0xf6,0x00]
roundpd $0, %xmm6, %xmm6

// CHECK: roundps $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
roundps $0, 485498096, %xmm6

// CHECK: roundps $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x74,0x82,0x40,0x00]
roundps $0, 64(%rdx,%rax,4), %xmm6

// CHECK: roundps $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x74,0x82,0xc0,0x00]
roundps $0, -64(%rdx,%rax,4), %xmm6

// CHECK: roundps $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x74,0x02,0x40,0x00]
roundps $0, 64(%rdx,%rax), %xmm6

// CHECK: roundps $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x72,0x40,0x00]
roundps $0, 64(%rdx), %xmm6

// CHECK: roundps $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0x32,0x00]
roundps $0, (%rdx), %xmm6

// CHECK: roundps $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x08,0xf6,0x00]
roundps $0, %xmm6, %xmm6

// CHECK: roundsd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
roundsd $0, 485498096, %xmm6

// CHECK: roundsd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x74,0x82,0x40,0x00]
roundsd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: roundsd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x74,0x82,0xc0,0x00]
roundsd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: roundsd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x74,0x02,0x40,0x00]
roundsd $0, 64(%rdx,%rax), %xmm6

// CHECK: roundsd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x72,0x40,0x00]
roundsd $0, 64(%rdx), %xmm6

// CHECK: roundsd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0x32,0x00]
roundsd $0, (%rdx), %xmm6

// CHECK: roundsd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0b,0xf6,0x00]
roundsd $0, %xmm6, %xmm6

// CHECK: roundss $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
roundss $0, 485498096, %xmm6

// CHECK: roundss $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x74,0x82,0x40,0x00]
roundss $0, 64(%rdx,%rax,4), %xmm6

// CHECK: roundss $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x74,0x82,0xc0,0x00]
roundss $0, -64(%rdx,%rax,4), %xmm6

// CHECK: roundss $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x74,0x02,0x40,0x00]
roundss $0, 64(%rdx,%rax), %xmm6

// CHECK: roundss $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x72,0x40,0x00]
roundss $0, 64(%rdx), %xmm6

// CHECK: roundss $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0x32,0x00]
roundss $0, (%rdx), %xmm6

// CHECK: roundss $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x3a,0x0a,0xf6,0x00]
roundss $0, %xmm6, %xmm6

