/*
 *  Copyright 1994-2021 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include "bulfius.h"
#include "utils.h"


#define REPORTS_ENDPOINT "https://stats.biniou.net/lebiniou"


void
bulfius_post(const char *endpoint, json_t *body)
{
  struct _u_request req;
  gchar *url = g_strdup_printf("%s%s", REPORTS_ENDPOINT, endpoint);

  ulfius_init_request(&req);
#if ULFIUS_VERSION_NUMBER >= 0x020607
  ulfius_set_request_properties(&req, U_OPT_HTTP_URL, url, U_OPT_TIMEOUT, 2000, U_OPT_NONE);
#else
  req.http_url = o_strdup(url);
  req.timeout = 2000;
#endif
  req.http_verb = o_strdup("POST");
  g_free(url);
  ulfius_set_json_body_request(&req, body);

  int res = ulfius_send_http_request(&req, NULL);
  if (res != U_OK) {
    xdebug("[!] Error in http request: %d\n", res);
  }
  ulfius_clean_request(&req);
}
