/*
 * Copyright (C) 2022-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once

#include <cstdint>
#include <map>
#include <string>

namespace L0 {

// Each entry of this map corresponds to one particular graphics card type for example, DG1 A or B step.
// or XeHP_SDV. GUID string will help in identify the card type
const std::map<std::string, std::map<std::string, uint64_t>> guidToKeyOffsetMap = {
    {"0x490e01", // DG1 B stepping
     {{"PACKAGE_ENERGY", 0x420},
      {"COMPUTE_TEMPERATURES", 0x68},
      {"SOC_TEMPERATURES", 0x60},
      {"CORE_TEMPERATURES", 0x6c}}},
    {"0x490e", // DG1 A stepping
     {{"PACKAGE_ENERGY", 0x400},
      {"COMPUTE_TEMPERATURES", 0x68},
      {"SOC_TEMPERATURES", 0x60},
      {"CORE_TEMPERATURES", 0x6c}}},
    {"0x4f95", // For DG2 device
     {{"PACKAGE_ENERGY", 1032},
      {"SOC_TEMPERATURES", 56}}}, // SOC_TEMPERATURE contains GT_TEMP, DRAM_TEMP, SA_TEMP, DE_TEMP, PCIE_TEMP, TYPEC_TEMP
    {"0x4f9301",                  // For ATSM device
     {{"PACKAGE_ENERGY", 1032},
      {"SOC_TEMPERATURES", 56}}}, // SOC_TEMPERATURE contains GT_TEMP, DRAM_TEMP, SA_TEMP, DE_TEMP, PCIE_TEMP, TYPEC_TEMP
    {"0x4f9302",                  // For DG2 512EU / ATS-M1
     {{"PACKAGE_ENERGY", 1032},
      {"SOC_TEMPERATURES", 56},
      {"MC_CAPTURE_TIMESTAMP", 1088},
      {"IDI_READS[0]", 1096},
      {"IDI_READS[1]", 1104},
      {"IDI_READS[2]", 1112},
      {"IDI_READS[3]", 1120},
      {"IDI_READS[4]", 1128},
      {"IDI_READS[5]", 1136},
      {"IDI_READS[6]", 1144},
      {"IDI_READS[7]", 1152},
      {"IDI_READS[8]", 1160},
      {"IDI_READS[9]", 1168},
      {"IDI_READS[10]", 1176},
      {"IDI_READS[11]", 1184},
      {"IDI_READS[12]", 1192},
      {"IDI_READS[13]", 1200},
      {"IDI_READS[14]", 1208},
      {"IDI_READS[15]", 1216},
      {"IDI_WRITES[0]", 1224},
      {"IDI_WRITES[1]", 1232},
      {"IDI_WRITES[2]", 1240},
      {"IDI_WRITES[3]", 1248},
      {"IDI_WRITES[4]", 1256},
      {"IDI_WRITES[5]", 1264},
      {"IDI_WRITES[6]", 1272},
      {"IDI_WRITES[7]", 1280},
      {"IDI_WRITES[8]", 1288},
      {"IDI_WRITES[9]", 1296},
      {"IDI_WRITES[10]", 1304},
      {"IDI_WRITES[11]", 1312},
      {"IDI_WRITES[12]", 1320},
      {"IDI_WRITES[13]", 1328},
      {"IDI_WRITES[14]", 1336},
      {"IDI_WRITES[15]", 1344},
      {"DISPLAY_VC1_READS[0]", 1352},
      {"DISPLAY_VC1_READS[1]", 1360},
      {"DISPLAY_VC1_READS[2]", 1368},
      {"DISPLAY_VC1_READS[3]", 1376},
      {"DISPLAY_VC1_READS[4]", 1384},
      {"DISPLAY_VC1_READS[5]", 1392},
      {"DISPLAY_VC1_READS[6]", 1400},
      {"DISPLAY_VC1_READS[7]", 1408},
      {"DISPLAY_VC1_READS[8]", 1416},
      {"DISPLAY_VC1_READS[9]", 1424},
      {"DISPLAY_VC1_READS[10]", 1432},
      {"DISPLAY_VC1_READS[11]", 1440},
      {"DISPLAY_VC1_READS[12]", 1448},
      {"DISPLAY_VC1_READS[13]", 1456},
      {"DISPLAY_VC1_READS[14]", 1464},
      {"DISPLAY_VC1_READS[15]", 1472}}},
    {"0x4f9502", // For DG2 128EU / ATS-M3
     {{"PACKAGE_ENERGY", 1032},
      {"SOC_TEMPERATURES", 56},
      {"MC_CAPTURE_TIMESTAMP", 1088},
      {"IDI_READS[0]", 1096},
      {"IDI_READS[1]", 1104},
      {"IDI_READS[2]", 1112},
      {"IDI_READS[3]", 1120},
      {"IDI_READS[4]", 1128},
      {"IDI_READS[5]", 1136},
      {"IDI_READS[6]", 1144},
      {"IDI_READS[7]", 1152},
      {"IDI_READS[8]", 1160},
      {"IDI_READS[9]", 1168},
      {"IDI_READS[10]", 1176},
      {"IDI_READS[11]", 1184},
      {"IDI_READS[12]", 1192},
      {"IDI_READS[13]", 1200},
      {"IDI_READS[14]", 1208},
      {"IDI_READS[15]", 1216},
      {"IDI_WRITES[0]", 1224},
      {"IDI_WRITES[1]", 1232},
      {"IDI_WRITES[2]", 1240},
      {"IDI_WRITES[3]", 1248},
      {"IDI_WRITES[4]", 1256},
      {"IDI_WRITES[5]", 1264},
      {"IDI_WRITES[6]", 1272},
      {"IDI_WRITES[7]", 1280},
      {"IDI_WRITES[8]", 1288},
      {"IDI_WRITES[9]", 1296},
      {"IDI_WRITES[10]", 1304},
      {"IDI_WRITES[11]", 1312},
      {"IDI_WRITES[12]", 1320},
      {"IDI_WRITES[13]", 1328},
      {"IDI_WRITES[14]", 1336},
      {"IDI_WRITES[15]", 1344},
      {"DISPLAY_VC1_READS[0]", 1352},
      {"DISPLAY_VC1_READS[1]", 1360},
      {"DISPLAY_VC1_READS[2]", 1368},
      {"DISPLAY_VC1_READS[3]", 1376},
      {"DISPLAY_VC1_READS[4]", 1384},
      {"DISPLAY_VC1_READS[5]", 1392},
      {"DISPLAY_VC1_READS[6]", 1400},
      {"DISPLAY_VC1_READS[7]", 1408},
      {"DISPLAY_VC1_READS[8]", 1416},
      {"DISPLAY_VC1_READS[9]", 1424},
      {"DISPLAY_VC1_READS[10]", 1432},
      {"DISPLAY_VC1_READS[11]", 1440},
      {"DISPLAY_VC1_READS[12]", 1448},
      {"DISPLAY_VC1_READS[13]", 1456},
      {"DISPLAY_VC1_READS[14]", 1464},
      {"DISPLAY_VC1_READS[15]", 1472}}},
    {"0xb15a0edc", // For PVC device
     {{"HBM0MaxDeviceTemperature", 28},
      {"HBM1MaxDeviceTemperature", 36},
      {"TileMinTemperature", 40},
      {"TileMaxTemperature", 44},
      {"GTMinTemperature", 48},
      {"GTMaxTemperature", 52},
      {"VF0_VFID", 88},
      {"VF0_HBM0_READ", 92},
      {"VF0_HBM0_WRITE", 96},
      {"VF0_HBM1_READ", 104},
      {"VF0_HBM1_WRITE", 108},
      {"VF0_TIMESTAMP_L", 168},
      {"VF0_TIMESTAMP_H", 172},
      {"VF1_VFID", 176},
      {"VF1_HBM0_READ", 180},
      {"VF1_HBM0_WRITE", 184},
      {"VF1_HBM1_READ", 192},
      {"VF1_HBM1_WRITE", 196},
      {"VF1_TIMESTAMP_L", 256},
      {"VF1_TIMESTAMP_H", 260},
      {"HBM2MaxDeviceTemperature", 300},
      {"HBM3MaxDeviceTemperature", 308},
      {"VF0_HBM2_READ", 312},
      {"VF0_HBM2_WRITE", 316},
      {"VF0_HBM3_READ", 328},
      {"VF0_HBM3_WRITE", 332},
      {"VF1_HBM2_READ", 344},
      {"VF1_HBM2_WRITE", 348},
      {"VF1_HBM3_READ", 360},
      {"VF1_HBM3_WRITE", 364},
      {"VF0_HBM_READ_L", 384},
      {"VF0_HBM_READ_H", 388},
      {"VF0_HBM_WRITE_L", 392},
      {"VF0_HBM_WRITE_H", 396},
      {"VF1_HBM_READ_L", 400},
      {"VF1_HBM_READ_H", 404},
      {"VF1_HBM_WRITE_L", 408},
      {"VF1_HBM_WRITE_H", 412}}},
    {"0xb15a0edd", // For PVC device
     {{"HBM0MaxDeviceTemperature", 28},
      {"HBM1MaxDeviceTemperature", 36},
      {"TileMinTemperature", 40},
      {"TileMaxTemperature", 44},
      {"GTMinTemperature", 48},
      {"GTMaxTemperature", 52},
      {"VF0_VFID", 88},
      {"VF0_HBM0_READ", 92},
      {"VF0_HBM0_WRITE", 96},
      {"VF0_HBM1_READ", 104},
      {"VF0_HBM1_WRITE", 108},
      {"VF0_TIMESTAMP_L", 168},
      {"VF0_TIMESTAMP_H", 172},
      {"VF1_VFID", 176},
      {"VF1_HBM0_READ", 180},
      {"VF1_HBM0_WRITE", 184},
      {"VF1_HBM1_READ", 192},
      {"VF1_HBM1_WRITE", 196},
      {"VF1_TIMESTAMP_L", 256},
      {"VF1_TIMESTAMP_H", 260},
      {"HBM2MaxDeviceTemperature", 300},
      {"HBM3MaxDeviceTemperature", 308},
      {"VF0_HBM2_READ", 312},
      {"VF0_HBM2_WRITE", 316},
      {"VF0_HBM3_READ", 328},
      {"VF0_HBM3_WRITE", 332},
      {"VF1_HBM2_READ", 344},
      {"VF1_HBM2_WRITE", 348},
      {"VF1_HBM3_READ", 360},
      {"VF1_HBM3_WRITE", 364},
      {"VF0_HBM_READ_L", 384},
      {"VF0_HBM_READ_H", 388},
      {"VF0_HBM_WRITE_L", 392},
      {"VF0_HBM_WRITE_H", 396},
      {"VF1_HBM_READ_L", 400},
      {"VF1_HBM_READ_H", 404},
      {"VF1_HBM_WRITE_L", 408},
      {"VF1_HBM_WRITE_H", 412}}},
    {"0xb15a0ede", // For PVC device
     {{"HBM0MaxDeviceTemperature", 28},
      {"HBM1MaxDeviceTemperature", 36},
      {"TileMinTemperature", 40},
      {"TileMaxTemperature", 44},
      {"GTMinTemperature", 48},
      {"GTMaxTemperature", 52},
      {"VF0_VFID", 88},
      {"VF0_HBM0_READ", 92},
      {"VF0_HBM0_WRITE", 96},
      {"VF0_HBM1_READ", 104},
      {"VF0_HBM1_WRITE", 108},
      {"VF0_TIMESTAMP_L", 168},
      {"VF0_TIMESTAMP_H", 172},
      {"VF1_VFID", 176},
      {"VF1_HBM0_READ", 180},
      {"VF1_HBM0_WRITE", 184},
      {"VF1_HBM1_READ", 192},
      {"VF1_HBM1_WRITE", 196},
      {"VF1_TIMESTAMP_L", 256},
      {"VF1_TIMESTAMP_H", 260},
      {"HBM2MaxDeviceTemperature", 300},
      {"HBM3MaxDeviceTemperature", 308},
      {"VF0_HBM2_READ", 312},
      {"VF0_HBM2_WRITE", 316},
      {"VF0_HBM3_READ", 328},
      {"VF0_HBM3_WRITE", 332},
      {"VF1_HBM2_READ", 344},
      {"VF1_HBM2_WRITE", 348},
      {"VF1_HBM3_READ", 360},
      {"VF1_HBM3_WRITE", 364},
      {"VF0_HBM_READ_L", 384},
      {"VF0_HBM_READ_H", 388},
      {"VF0_HBM_WRITE_L", 392},
      {"VF0_HBM_WRITE_H", 396},
      {"VF1_HBM_READ_L", 400},
      {"VF1_HBM_READ_H", 404},
      {"VF1_HBM_WRITE_L", 408},
      {"VF1_HBM_WRITE_H", 412}}},
    {"0x41fe79a5", // For PVC root device
     {{"PPIN", 152},
      {"BoardNumber", 72}}}};
} // namespace L0
