/*		
 *		GRAMophone II, a grammar based algorithmic musical composition tool
 *		--------------------------------------------------------------------
 *		
 *		expcode.c
 *
 *		Copyright (c) 2007, Giovanni Ferranti <giovanni@giovanniferranti.it>
 *
 * 		GRAMophone II is free software; you can redistribute it and/or modify
 * 		it under the terms of the GNU General Public License as published by
 * 		the Free Software Foundation; either version 2 of the License, or
 * 		(at your option) any later version.
 *
 * 		This program is distributed in the hope that it will be useful,
 * 		but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * 		GNU Library General Public License for more details.
 *
 *		You should have received a copy of the GNU General Public License along
 *		with this program; if not, write to the Free Software Foundation, Inc.,
 *		51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *		-------------------------------------------------------------------
 */

#include "global.h"

extern char idTemp[];
unsigned int id;

void gen_exp1_code(unsigned int op, unsigned int type1, unsigned int op1,
		  unsigned int type2, unsigned int op2) {

  id=hash(idTemp, 0);
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][0]=op; 
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][1]=type1; 
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][2]=op1;
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][3]=type2;
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec++][4]=op2;
}

void gen_exp2_code(unsigned int op, unsigned int op1, unsigned int type,
		   unsigned int op2) {

  id=hash(idTemp, 0);	
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][0]=op;	 
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][1]=op1;
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][2]=type;  
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec++][3]=op2;
}

void gen_exp3_code(unsigned int op, unsigned int type, unsigned int op1) {
  id=hash(idTemp, 0);
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][0]=op;
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec][1]=type;
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec++][2]=op1;
}

void gen_exp4_code(unsigned int op) {
  id=hash(idTemp, 0);
 
  players[playerCount]->productions[id]->exp->expcode[players[playerCount]->
    productions[id]->ec++][0]=op;
}
