// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/networkservices/v1/grpc_route.proto

package networkservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the match.
type GrpcRoute_MethodMatch_Type int32

const (
	// Unspecified.
	GrpcRoute_MethodMatch_TYPE_UNSPECIFIED GrpcRoute_MethodMatch_Type = 0
	// Will only match the exact name provided.
	GrpcRoute_MethodMatch_EXACT GrpcRoute_MethodMatch_Type = 1
	// Will interpret grpc_method and grpc_service as regexes. RE2 syntax is
	// supported.
	GrpcRoute_MethodMatch_REGULAR_EXPRESSION GrpcRoute_MethodMatch_Type = 2
)

// Enum value maps for GrpcRoute_MethodMatch_Type.
var (
	GrpcRoute_MethodMatch_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "REGULAR_EXPRESSION",
	}
	GrpcRoute_MethodMatch_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"EXACT":              1,
		"REGULAR_EXPRESSION": 2,
	}
)

func (x GrpcRoute_MethodMatch_Type) Enum() *GrpcRoute_MethodMatch_Type {
	p := new(GrpcRoute_MethodMatch_Type)
	*p = x
	return p
}

func (x GrpcRoute_MethodMatch_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GrpcRoute_MethodMatch_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes[0].Descriptor()
}

func (GrpcRoute_MethodMatch_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes[0]
}

func (x GrpcRoute_MethodMatch_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GrpcRoute_MethodMatch_Type.Descriptor instead.
func (GrpcRoute_MethodMatch_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The type of match.
type GrpcRoute_HeaderMatch_Type int32

const (
	// Unspecified.
	GrpcRoute_HeaderMatch_TYPE_UNSPECIFIED GrpcRoute_HeaderMatch_Type = 0
	// Will only match the exact value provided.
	GrpcRoute_HeaderMatch_EXACT GrpcRoute_HeaderMatch_Type = 1
	// Will match paths conforming to the prefix specified by value. RE2
	// syntax is supported.
	GrpcRoute_HeaderMatch_REGULAR_EXPRESSION GrpcRoute_HeaderMatch_Type = 2
)

// Enum value maps for GrpcRoute_HeaderMatch_Type.
var (
	GrpcRoute_HeaderMatch_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "REGULAR_EXPRESSION",
	}
	GrpcRoute_HeaderMatch_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"EXACT":              1,
		"REGULAR_EXPRESSION": 2,
	}
)

func (x GrpcRoute_HeaderMatch_Type) Enum() *GrpcRoute_HeaderMatch_Type {
	p := new(GrpcRoute_HeaderMatch_Type)
	*p = x
	return p
}

func (x GrpcRoute_HeaderMatch_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GrpcRoute_HeaderMatch_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes[1].Descriptor()
}

func (GrpcRoute_HeaderMatch_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes[1]
}

func (x GrpcRoute_HeaderMatch_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GrpcRoute_HeaderMatch_Type.Descriptor instead.
func (GrpcRoute_HeaderMatch_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 1, 0}
}

// GrpcRoute is the resource defining how gRPC traffic routed by a Mesh
// or Gateway resource is routed.
type GrpcRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the GrpcRoute resource. It matches pattern
	// `projects/*/locations/global/grpcRoutes/<grpc_route_name>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server-defined URL of this resource
	SelfLink string `protobuf:"bytes,12,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Set of label tags associated with the GrpcRoute resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Service hostnames with an optional port for which this route
	// describes traffic.
	//
	// Format: <hostname>[:<port>]
	//
	// Hostname is the fully qualified domain name of a network host. This matches
	// the RFC 1123 definition of a hostname with 2 notable exceptions:
	//   - IPs are not allowed.
	//   - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
	//     label must appear by itself as the first label.
	//
	// Hostname can be "precise" which is a domain name without the terminating
	// dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
	// domain name prefixed with a single wildcard label (e.g. `*.example.com`).
	//
	// Note that as per RFC1035 and RFC1123, a label must consist of lower case
	// alphanumeric characters or '-', and must start and end with an alphanumeric
	// character. No other punctuation is allowed.
	//
	// The routes associated with a Mesh or Gateway must have unique hostnames. If
	// you attempt to attach multiple routes with conflicting hostnames, the
	// configuration will be rejected.
	//
	// For example, while it is acceptable for routes for the hostnames
	// `*.foo.bar.com` and `*.bar.com` to be associated with the same route, it is
	// not possible to associate two routes both with `*.bar.com` or both with
	// `bar.com`.
	//
	// If a port is specified, then gRPC clients must use the channel URI with the
	// port to match this rule (i.e. "xds:///service:123"), otherwise they must
	// supply the URI without a port (i.e. "xds:///service").
	Hostnames []string `protobuf:"bytes,6,rep,name=hostnames,proto3" json:"hostnames,omitempty"`
	// Optional. Meshes defines a list of meshes this GrpcRoute is attached to, as
	// one of the routing rules to route the requests served by the mesh.
	//
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/<mesh_name>`
	Meshes []string `protobuf:"bytes,9,rep,name=meshes,proto3" json:"meshes,omitempty"`
	// Optional. Gateways defines a list of gateways this GrpcRoute is attached
	// to, as one of the routing rules to route the requests served by the
	// gateway.
	//
	// Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/<gateway_name>`
	Gateways []string `protobuf:"bytes,10,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Required. A list of detailed rules defining how to route traffic.
	//
	// Within a single GrpcRoute, the GrpcRoute.RouteAction associated with the
	// first matching GrpcRoute.RouteRule will be executed. At least one rule
	// must be supplied.
	Rules []*GrpcRoute_RouteRule `protobuf:"bytes,7,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *GrpcRoute) Reset() {
	*x = GrpcRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute) ProtoMessage() {}

func (x *GrpcRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute.ProtoReflect.Descriptor instead.
func (*GrpcRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0}
}

func (x *GrpcRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GrpcRoute) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *GrpcRoute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GrpcRoute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GrpcRoute) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GrpcRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *GrpcRoute) GetHostnames() []string {
	if x != nil {
		return x.Hostnames
	}
	return nil
}

func (x *GrpcRoute) GetMeshes() []string {
	if x != nil {
		return x.Meshes
	}
	return nil
}

func (x *GrpcRoute) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *GrpcRoute) GetRules() []*GrpcRoute_RouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Request used with the ListGrpcRoutes method.
type ListGrpcRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the GrpcRoutes should be
	// listed, specified in the format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of GrpcRoutes to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListGrpcRoutesResponse`
	// Indicates that this is a continuation of a prior `ListGrpcRoutes` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGrpcRoutesRequest) Reset() {
	*x = ListGrpcRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGrpcRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGrpcRoutesRequest) ProtoMessage() {}

func (x *ListGrpcRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGrpcRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListGrpcRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{1}
}

func (x *ListGrpcRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGrpcRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGrpcRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListGrpcRoutes method.
type ListGrpcRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of GrpcRoute resources.
	GrpcRoutes []*GrpcRoute `protobuf:"bytes,1,rep,name=grpc_routes,json=grpcRoutes,proto3" json:"grpc_routes,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGrpcRoutesResponse) Reset() {
	*x = ListGrpcRoutesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGrpcRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGrpcRoutesResponse) ProtoMessage() {}

func (x *ListGrpcRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGrpcRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListGrpcRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{2}
}

func (x *ListGrpcRoutesResponse) GetGrpcRoutes() []*GrpcRoute {
	if x != nil {
		return x.GrpcRoutes
	}
	return nil
}

func (x *ListGrpcRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetGrpcRoute method.
type GetGrpcRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the GrpcRoute to get. Must be in the format
	// `projects/*/locations/global/grpcRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGrpcRouteRequest) Reset() {
	*x = GetGrpcRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGrpcRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGrpcRouteRequest) ProtoMessage() {}

func (x *GetGrpcRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGrpcRouteRequest.ProtoReflect.Descriptor instead.
func (*GetGrpcRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{3}
}

func (x *GetGrpcRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the CreateGrpcRoute method.
type CreateGrpcRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the GrpcRoute. Must be in the
	// format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the GrpcRoute resource to be created.
	GrpcRouteId string `protobuf:"bytes,2,opt,name=grpc_route_id,json=grpcRouteId,proto3" json:"grpc_route_id,omitempty"`
	// Required. GrpcRoute resource to be created.
	GrpcRoute *GrpcRoute `protobuf:"bytes,3,opt,name=grpc_route,json=grpcRoute,proto3" json:"grpc_route,omitempty"`
}

func (x *CreateGrpcRouteRequest) Reset() {
	*x = CreateGrpcRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGrpcRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGrpcRouteRequest) ProtoMessage() {}

func (x *CreateGrpcRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGrpcRouteRequest.ProtoReflect.Descriptor instead.
func (*CreateGrpcRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{4}
}

func (x *CreateGrpcRouteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGrpcRouteRequest) GetGrpcRouteId() string {
	if x != nil {
		return x.GrpcRouteId
	}
	return ""
}

func (x *CreateGrpcRouteRequest) GetGrpcRoute() *GrpcRoute {
	if x != nil {
		return x.GrpcRoute
	}
	return nil
}

// Request used by the UpdateGrpcRoute method.
type UpdateGrpcRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// GrpcRoute resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated GrpcRoute resource.
	GrpcRoute *GrpcRoute `protobuf:"bytes,2,opt,name=grpc_route,json=grpcRoute,proto3" json:"grpc_route,omitempty"`
}

func (x *UpdateGrpcRouteRequest) Reset() {
	*x = UpdateGrpcRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGrpcRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGrpcRouteRequest) ProtoMessage() {}

func (x *UpdateGrpcRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGrpcRouteRequest.ProtoReflect.Descriptor instead.
func (*UpdateGrpcRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateGrpcRouteRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGrpcRouteRequest) GetGrpcRoute() *GrpcRoute {
	if x != nil {
		return x.GrpcRoute
	}
	return nil
}

// Request used by the DeleteGrpcRoute method.
type DeleteGrpcRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the GrpcRoute to delete. Must be in the format
	// `projects/*/locations/global/grpcRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGrpcRouteRequest) Reset() {
	*x = DeleteGrpcRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGrpcRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGrpcRouteRequest) ProtoMessage() {}

func (x *DeleteGrpcRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGrpcRouteRequest.ProtoReflect.Descriptor instead.
func (*DeleteGrpcRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteGrpcRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specifies a match against a method.
type GrpcRoute_MethodMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies how to match against the name. If not specified, a
	// default value of "EXACT" is used.
	Type GrpcRoute_MethodMatch_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.networkservices.v1.GrpcRoute_MethodMatch_Type" json:"type,omitempty"`
	// Required. Name of the service to match against. If unspecified, will
	// match all services.
	GrpcService string `protobuf:"bytes,2,opt,name=grpc_service,json=grpcService,proto3" json:"grpc_service,omitempty"`
	// Required. Name of the method to match against. If unspecified, will match
	// all methods.
	GrpcMethod string `protobuf:"bytes,3,opt,name=grpc_method,json=grpcMethod,proto3" json:"grpc_method,omitempty"`
	// Optional. Specifies that matches are case sensitive.  The default value
	// is true. case_sensitive must not be used with a type of
	// REGULAR_EXPRESSION.
	CaseSensitive *bool `protobuf:"varint,4,opt,name=case_sensitive,json=caseSensitive,proto3,oneof" json:"case_sensitive,omitempty"`
}

func (x *GrpcRoute_MethodMatch) Reset() {
	*x = GrpcRoute_MethodMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_MethodMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_MethodMatch) ProtoMessage() {}

func (x *GrpcRoute_MethodMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_MethodMatch.ProtoReflect.Descriptor instead.
func (*GrpcRoute_MethodMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 0}
}

func (x *GrpcRoute_MethodMatch) GetType() GrpcRoute_MethodMatch_Type {
	if x != nil {
		return x.Type
	}
	return GrpcRoute_MethodMatch_TYPE_UNSPECIFIED
}

func (x *GrpcRoute_MethodMatch) GetGrpcService() string {
	if x != nil {
		return x.GrpcService
	}
	return ""
}

func (x *GrpcRoute_MethodMatch) GetGrpcMethod() string {
	if x != nil {
		return x.GrpcMethod
	}
	return ""
}

func (x *GrpcRoute_MethodMatch) GetCaseSensitive() bool {
	if x != nil && x.CaseSensitive != nil {
		return *x.CaseSensitive
	}
	return false
}

// A match against a collection of headers.
type GrpcRoute_HeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies how to match against the value of the header. If not
	// specified, a default value of EXACT is used.
	Type GrpcRoute_HeaderMatch_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.networkservices.v1.GrpcRoute_HeaderMatch_Type" json:"type,omitempty"`
	// Required. The key of the header.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The value of the header.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *GrpcRoute_HeaderMatch) Reset() {
	*x = GrpcRoute_HeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_HeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_HeaderMatch) ProtoMessage() {}

func (x *GrpcRoute_HeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_HeaderMatch.ProtoReflect.Descriptor instead.
func (*GrpcRoute_HeaderMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 1}
}

func (x *GrpcRoute_HeaderMatch) GetType() GrpcRoute_HeaderMatch_Type {
	if x != nil {
		return x.Type
	}
	return GrpcRoute_HeaderMatch_TYPE_UNSPECIFIED
}

func (x *GrpcRoute_HeaderMatch) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *GrpcRoute_HeaderMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Criteria for matching traffic. A RouteMatch will be considered to match
// when all supplied fields match.
type GrpcRoute_RouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A gRPC method to match against. If this field is empty or
	// omitted, will match all methods.
	Method *GrpcRoute_MethodMatch `protobuf:"bytes,1,opt,name=method,proto3,oneof" json:"method,omitempty"`
	// Optional. Specifies a collection of headers to match.
	Headers []*GrpcRoute_HeaderMatch `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
}

func (x *GrpcRoute_RouteMatch) Reset() {
	*x = GrpcRoute_RouteMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_RouteMatch) ProtoMessage() {}

func (x *GrpcRoute_RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_RouteMatch.ProtoReflect.Descriptor instead.
func (*GrpcRoute_RouteMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 2}
}

func (x *GrpcRoute_RouteMatch) GetMethod() *GrpcRoute_MethodMatch {
	if x != nil {
		return x.Method
	}
	return nil
}

func (x *GrpcRoute_RouteMatch) GetHeaders() []*GrpcRoute_HeaderMatch {
	if x != nil {
		return x.Headers
	}
	return nil
}

// The destination to which traffic will be routed.
type GrpcRoute_Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the kind of destination to which traffic will be routed.
	//
	// Types that are assignable to DestinationType:
	//
	//	*GrpcRoute_Destination_ServiceName
	DestinationType isGrpcRoute_Destination_DestinationType `protobuf_oneof:"destination_type"`
	// Optional. Specifies the proportion of requests forwarded to the backend
	// referenced by the serviceName field. This is computed as:
	// - weight/Sum(weights in this destination list).
	// For non-zero values, there may be some epsilon from the exact proportion
	// defined here depending on the precision an implementation supports.
	//
	// If only one serviceName is specified and it has a weight greater than 0,
	// 100% of the traffic is forwarded to that backend.
	//
	// If weights are specified for any one service name, they need to be
	// specified for all of them.
	//
	// If weights are unspecified for all services, then, traffic is distributed
	// in equal proportions to all of them.
	Weight *int32 `protobuf:"varint,2,opt,name=weight,proto3,oneof" json:"weight,omitempty"`
}

func (x *GrpcRoute_Destination) Reset() {
	*x = GrpcRoute_Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_Destination) ProtoMessage() {}

func (x *GrpcRoute_Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_Destination.ProtoReflect.Descriptor instead.
func (*GrpcRoute_Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 3}
}

func (m *GrpcRoute_Destination) GetDestinationType() isGrpcRoute_Destination_DestinationType {
	if m != nil {
		return m.DestinationType
	}
	return nil
}

func (x *GrpcRoute_Destination) GetServiceName() string {
	if x, ok := x.GetDestinationType().(*GrpcRoute_Destination_ServiceName); ok {
		return x.ServiceName
	}
	return ""
}

func (x *GrpcRoute_Destination) GetWeight() int32 {
	if x != nil && x.Weight != nil {
		return *x.Weight
	}
	return 0
}

type isGrpcRoute_Destination_DestinationType interface {
	isGrpcRoute_Destination_DestinationType()
}

type GrpcRoute_Destination_ServiceName struct {
	// Required. The URL of a destination service to which to route traffic.
	// Must refer to either a BackendService or ServiceDirectoryService.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3,oneof"`
}

func (*GrpcRoute_Destination_ServiceName) isGrpcRoute_Destination_DestinationType() {}

// The specification for fault injection introduced into traffic to test the
// resiliency of clients to destination service failure. As part of fault
// injection, when clients send requests to a destination, delays can be
// introduced on a percentage of requests before sending those requests to the
// destination service. Similarly requests from clients can be aborted by for
// a percentage of requests.
type GrpcRoute_FaultInjectionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specification for injecting delay to client requests.
	Delay *GrpcRoute_FaultInjectionPolicy_Delay `protobuf:"bytes,1,opt,name=delay,proto3,oneof" json:"delay,omitempty"`
	// The specification for aborting to client requests.
	Abort *GrpcRoute_FaultInjectionPolicy_Abort `protobuf:"bytes,2,opt,name=abort,proto3,oneof" json:"abort,omitempty"`
}

func (x *GrpcRoute_FaultInjectionPolicy) Reset() {
	*x = GrpcRoute_FaultInjectionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_FaultInjectionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_FaultInjectionPolicy) ProtoMessage() {}

func (x *GrpcRoute_FaultInjectionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_FaultInjectionPolicy.ProtoReflect.Descriptor instead.
func (*GrpcRoute_FaultInjectionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 4}
}

func (x *GrpcRoute_FaultInjectionPolicy) GetDelay() *GrpcRoute_FaultInjectionPolicy_Delay {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *GrpcRoute_FaultInjectionPolicy) GetAbort() *GrpcRoute_FaultInjectionPolicy_Abort {
	if x != nil {
		return x.Abort
	}
	return nil
}

// The specifications for retries.
type GrpcRoute_RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//   - connect-failure: Router will retry on failures connecting to Backend
	//     Services, for example due to connection timeouts.
	//   - refused-stream: Router will retry if the backend service resets the
	//
	// stream
	//
	//	with a REFUSED_STREAM error code. This reset type indicates that it is
	//	safe to retry.
	//
	// - cancelled: Router will retry if the gRPC status code in the response
	// header
	//
	//	is set to cancelled
	//
	// - deadline-exceeded: Router will retry if the gRPC status code in the
	// response
	//
	//	header is set to deadline-exceeded
	//   - resource-exhausted: Router will retry if the gRPC status code in the
	//     response header is set to resource-exhausted
	//   - unavailable: Router will retry if the gRPC status code in the response
	//     header is set to unavailable
	RetryConditions []string `protobuf:"bytes,1,rep,name=retry_conditions,json=retryConditions,proto3" json:"retry_conditions,omitempty"`
	// Specifies the allowed number of retries. This number must be > 0. If not
	// specified, default to 1.
	NumRetries uint32 `protobuf:"varint,2,opt,name=num_retries,json=numRetries,proto3" json:"num_retries,omitempty"`
}

func (x *GrpcRoute_RetryPolicy) Reset() {
	*x = GrpcRoute_RetryPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_RetryPolicy) ProtoMessage() {}

func (x *GrpcRoute_RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_RetryPolicy.ProtoReflect.Descriptor instead.
func (*GrpcRoute_RetryPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 5}
}

func (x *GrpcRoute_RetryPolicy) GetRetryConditions() []string {
	if x != nil {
		return x.RetryConditions
	}
	return nil
}

func (x *GrpcRoute_RetryPolicy) GetNumRetries() uint32 {
	if x != nil {
		return x.NumRetries
	}
	return 0
}

// Specifies how to route matched traffic.
type GrpcRoute_RouteAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The destination services to which traffic should be forwarded.
	// If multiple destinations are specified, traffic will be split between
	// Backend Service(s) according to the weight field of these destinations.
	Destinations []*GrpcRoute_Destination `protobuf:"bytes,1,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// Optional. The specification for fault injection introduced into traffic to test the
	// resiliency of clients to destination service failure. As part of fault
	// injection, when clients send requests to a destination, delays can be
	// introduced on a percentage of requests before sending those requests to
	// the destination service. Similarly requests from clients can be aborted
	// by for a percentage of requests.
	//
	// timeout and retry_policy will be ignored by clients that are configured
	// with a fault_injection_policy
	FaultInjectionPolicy *GrpcRoute_FaultInjectionPolicy `protobuf:"bytes,3,opt,name=fault_injection_policy,json=faultInjectionPolicy,proto3" json:"fault_injection_policy,omitempty"`
	// Optional. Specifies the timeout for selected route. Timeout is computed
	// from the time the request has been fully processed (i.e. end of stream)
	// up until the response has been completely processed. Timeout includes all
	// retries.
	Timeout *durationpb.Duration `protobuf:"bytes,7,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Optional. Specifies the retry policy associated with this route.
	RetryPolicy *GrpcRoute_RetryPolicy `protobuf:"bytes,8,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
}

func (x *GrpcRoute_RouteAction) Reset() {
	*x = GrpcRoute_RouteAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_RouteAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_RouteAction) ProtoMessage() {}

func (x *GrpcRoute_RouteAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_RouteAction.ProtoReflect.Descriptor instead.
func (*GrpcRoute_RouteAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 6}
}

func (x *GrpcRoute_RouteAction) GetDestinations() []*GrpcRoute_Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *GrpcRoute_RouteAction) GetFaultInjectionPolicy() *GrpcRoute_FaultInjectionPolicy {
	if x != nil {
		return x.FaultInjectionPolicy
	}
	return nil
}

func (x *GrpcRoute_RouteAction) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *GrpcRoute_RouteAction) GetRetryPolicy() *GrpcRoute_RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

// Describes how to route traffic.
type GrpcRoute_RouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Matches define conditions used for matching the rule against
	// incoming gRPC requests. Each match is independent, i.e. this rule will be
	// matched if ANY one of the matches is satisfied.  If no matches field is
	// specified, this rule will unconditionally match traffic.
	Matches []*GrpcRoute_RouteMatch `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	// Required. A detailed rule defining how to route traffic. This field is
	// required.
	Action *GrpcRoute_RouteAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *GrpcRoute_RouteRule) Reset() {
	*x = GrpcRoute_RouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_RouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_RouteRule) ProtoMessage() {}

func (x *GrpcRoute_RouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_RouteRule.ProtoReflect.Descriptor instead.
func (*GrpcRoute_RouteRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 7}
}

func (x *GrpcRoute_RouteRule) GetMatches() []*GrpcRoute_RouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *GrpcRoute_RouteRule) GetAction() *GrpcRoute_RouteAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// Specification of how client requests are delayed as part of fault
// injection before being sent to a destination.
type GrpcRoute_FaultInjectionPolicy_Delay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify a fixed delay before forwarding the request.
	FixedDelay *durationpb.Duration `protobuf:"bytes,1,opt,name=fixed_delay,json=fixedDelay,proto3,oneof" json:"fixed_delay,omitempty"`
	// The percentage of traffic on which delay will be injected.
	//
	// The value must be between [0, 100]
	Percentage *int32 `protobuf:"varint,2,opt,name=percentage,proto3,oneof" json:"percentage,omitempty"`
}

func (x *GrpcRoute_FaultInjectionPolicy_Delay) Reset() {
	*x = GrpcRoute_FaultInjectionPolicy_Delay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_FaultInjectionPolicy_Delay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_FaultInjectionPolicy_Delay) ProtoMessage() {}

func (x *GrpcRoute_FaultInjectionPolicy_Delay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_FaultInjectionPolicy_Delay.ProtoReflect.Descriptor instead.
func (*GrpcRoute_FaultInjectionPolicy_Delay) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *GrpcRoute_FaultInjectionPolicy_Delay) GetFixedDelay() *durationpb.Duration {
	if x != nil {
		return x.FixedDelay
	}
	return nil
}

func (x *GrpcRoute_FaultInjectionPolicy_Delay) GetPercentage() int32 {
	if x != nil && x.Percentage != nil {
		return *x.Percentage
	}
	return 0
}

// Specification of how client requests are aborted as part of fault
// injection before being sent to a destination.
type GrpcRoute_FaultInjectionPolicy_Abort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP status code used to abort the request.
	//
	// The value must be between 200 and 599 inclusive.
	HttpStatus *int32 `protobuf:"varint,1,opt,name=http_status,json=httpStatus,proto3,oneof" json:"http_status,omitempty"`
	// The percentage of traffic which will be aborted.
	//
	// The value must be between [0, 100]
	Percentage *int32 `protobuf:"varint,2,opt,name=percentage,proto3,oneof" json:"percentage,omitempty"`
}

func (x *GrpcRoute_FaultInjectionPolicy_Abort) Reset() {
	*x = GrpcRoute_FaultInjectionPolicy_Abort{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcRoute_FaultInjectionPolicy_Abort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcRoute_FaultInjectionPolicy_Abort) ProtoMessage() {}

func (x *GrpcRoute_FaultInjectionPolicy_Abort) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcRoute_FaultInjectionPolicy_Abort.ProtoReflect.Descriptor instead.
func (*GrpcRoute_FaultInjectionPolicy_Abort) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP(), []int{0, 4, 1}
}

func (x *GrpcRoute_FaultInjectionPolicy_Abort) GetHttpStatus() int32 {
	if x != nil && x.HttpStatus != nil {
		return *x.HttpStatus
	}
	return 0
}

func (x *GrpcRoute_FaultInjectionPolicy_Abort) GetPercentage() int32 {
	if x != nil && x.Percentage != nil {
		return *x.Percentage
	}
	return 0
}

var File_google_cloud_networkservices_v1_grpc_route_proto protoreflect.FileDescriptor

var file_google_cloud_networkservices_v1_grpc_route_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x86, 0x16, 0x0a, 0x09, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c,
	0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x68,
	0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x43,
	0x0a, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x68, 0x52, 0x06, 0x6d, 0x65, 0x73,
	0x68, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12,
	0x4f, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x1a, 0xb6, 0x02, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x54, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x24,
	0x0a, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x67, 0x72, 0x70, 0x63, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x2f, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x76, 0x65, 0x88, 0x01, 0x01, 0x22, 0x3f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x52, 0x45, 0x47, 0x55, 0x4c, 0x41, 0x52, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x5f,
	0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x1a, 0xd6, 0x01, 0x0a, 0x0b, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x54, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x3f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45,
	0x47, 0x55, 0x4c, 0x41, 0x52, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x1a, 0xc8, 0x01, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x58, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x1a, 0xa2, 0x01,
	0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x1a, 0xf0, 0x03, 0x0a, 0x14, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x60, 0x0a, 0x05, 0x64,
	0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70,
	0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x44, 0x65, 0x6c, 0x61,
	0x79, 0x48, 0x00, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x88, 0x01, 0x01, 0x12, 0x60, 0x0a,
	0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x62,
	0x6f, 0x72, 0x74, 0x48, 0x01, 0x52, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x88, 0x01, 0x01, 0x1a,
	0x8c, 0x01, 0x0a, 0x05, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x3f, 0x0a, 0x0b, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01,
	0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x42,
	0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x1a, 0x71,
	0x0a, 0x05, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0a,
	0x68, 0x74, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x12, 0x23, 0x0a,
	0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x01, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x61, 0x62, 0x6f, 0x72, 0x74, 0x1a, 0x59, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x1a, 0x84, 0x03, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5f, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x7a, 0x0a, 0x16, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x6e, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x61,
	0x75, 0x6c, 0x74, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38, 0x0a,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x5e, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0xb6, 0x01, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x54, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72,
	0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6e, 0xea, 0x41, 0x6b,
	0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x7b,
	0x67, 0x72, 0x70, 0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22, 0x9d, 0x01, 0x0a, 0x15,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72,
	0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72,
	0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x67, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5b, 0x0a, 0x13, 0x47,
	0x65, 0x74, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x70, 0x63,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a,
	0x0d, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x67, 0x72, 0x70, 0x63, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x0a, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70,
	0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x67, 0x72, 0x70,
	0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x4e, 0x0a, 0x0a, 0x67, 0x72, 0x70, 0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x67, 0x72, 0x70, 0x63, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x22, 0x5e, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x70,
	0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x70, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x42, 0xef, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x47, 0x72, 0x70,
	0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkservices_v1_grpc_route_proto_rawDescOnce sync.Once
	file_google_cloud_networkservices_v1_grpc_route_proto_rawDescData = file_google_cloud_networkservices_v1_grpc_route_proto_rawDesc
)

func file_google_cloud_networkservices_v1_grpc_route_proto_rawDescGZIP() []byte {
	file_google_cloud_networkservices_v1_grpc_route_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkservices_v1_grpc_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkservices_v1_grpc_route_proto_rawDescData)
	})
	return file_google_cloud_networkservices_v1_grpc_route_proto_rawDescData
}

var file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_networkservices_v1_grpc_route_proto_goTypes = []interface{}{
	(GrpcRoute_MethodMatch_Type)(0),              // 0: google.cloud.networkservices.v1.GrpcRoute.MethodMatch.Type
	(GrpcRoute_HeaderMatch_Type)(0),              // 1: google.cloud.networkservices.v1.GrpcRoute.HeaderMatch.Type
	(*GrpcRoute)(nil),                            // 2: google.cloud.networkservices.v1.GrpcRoute
	(*ListGrpcRoutesRequest)(nil),                // 3: google.cloud.networkservices.v1.ListGrpcRoutesRequest
	(*ListGrpcRoutesResponse)(nil),               // 4: google.cloud.networkservices.v1.ListGrpcRoutesResponse
	(*GetGrpcRouteRequest)(nil),                  // 5: google.cloud.networkservices.v1.GetGrpcRouteRequest
	(*CreateGrpcRouteRequest)(nil),               // 6: google.cloud.networkservices.v1.CreateGrpcRouteRequest
	(*UpdateGrpcRouteRequest)(nil),               // 7: google.cloud.networkservices.v1.UpdateGrpcRouteRequest
	(*DeleteGrpcRouteRequest)(nil),               // 8: google.cloud.networkservices.v1.DeleteGrpcRouteRequest
	(*GrpcRoute_MethodMatch)(nil),                // 9: google.cloud.networkservices.v1.GrpcRoute.MethodMatch
	(*GrpcRoute_HeaderMatch)(nil),                // 10: google.cloud.networkservices.v1.GrpcRoute.HeaderMatch
	(*GrpcRoute_RouteMatch)(nil),                 // 11: google.cloud.networkservices.v1.GrpcRoute.RouteMatch
	(*GrpcRoute_Destination)(nil),                // 12: google.cloud.networkservices.v1.GrpcRoute.Destination
	(*GrpcRoute_FaultInjectionPolicy)(nil),       // 13: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy
	(*GrpcRoute_RetryPolicy)(nil),                // 14: google.cloud.networkservices.v1.GrpcRoute.RetryPolicy
	(*GrpcRoute_RouteAction)(nil),                // 15: google.cloud.networkservices.v1.GrpcRoute.RouteAction
	(*GrpcRoute_RouteRule)(nil),                  // 16: google.cloud.networkservices.v1.GrpcRoute.RouteRule
	nil,                                          // 17: google.cloud.networkservices.v1.GrpcRoute.LabelsEntry
	(*GrpcRoute_FaultInjectionPolicy_Delay)(nil), // 18: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.Delay
	(*GrpcRoute_FaultInjectionPolicy_Abort)(nil), // 19: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.Abort
	(*timestamppb.Timestamp)(nil),                // 20: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                // 21: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                  // 22: google.protobuf.Duration
}
var file_google_cloud_networkservices_v1_grpc_route_proto_depIdxs = []int32{
	20, // 0: google.cloud.networkservices.v1.GrpcRoute.create_time:type_name -> google.protobuf.Timestamp
	20, // 1: google.cloud.networkservices.v1.GrpcRoute.update_time:type_name -> google.protobuf.Timestamp
	17, // 2: google.cloud.networkservices.v1.GrpcRoute.labels:type_name -> google.cloud.networkservices.v1.GrpcRoute.LabelsEntry
	16, // 3: google.cloud.networkservices.v1.GrpcRoute.rules:type_name -> google.cloud.networkservices.v1.GrpcRoute.RouteRule
	2,  // 4: google.cloud.networkservices.v1.ListGrpcRoutesResponse.grpc_routes:type_name -> google.cloud.networkservices.v1.GrpcRoute
	2,  // 5: google.cloud.networkservices.v1.CreateGrpcRouteRequest.grpc_route:type_name -> google.cloud.networkservices.v1.GrpcRoute
	21, // 6: google.cloud.networkservices.v1.UpdateGrpcRouteRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 7: google.cloud.networkservices.v1.UpdateGrpcRouteRequest.grpc_route:type_name -> google.cloud.networkservices.v1.GrpcRoute
	0,  // 8: google.cloud.networkservices.v1.GrpcRoute.MethodMatch.type:type_name -> google.cloud.networkservices.v1.GrpcRoute.MethodMatch.Type
	1,  // 9: google.cloud.networkservices.v1.GrpcRoute.HeaderMatch.type:type_name -> google.cloud.networkservices.v1.GrpcRoute.HeaderMatch.Type
	9,  // 10: google.cloud.networkservices.v1.GrpcRoute.RouteMatch.method:type_name -> google.cloud.networkservices.v1.GrpcRoute.MethodMatch
	10, // 11: google.cloud.networkservices.v1.GrpcRoute.RouteMatch.headers:type_name -> google.cloud.networkservices.v1.GrpcRoute.HeaderMatch
	18, // 12: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.delay:type_name -> google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.Delay
	19, // 13: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.abort:type_name -> google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.Abort
	12, // 14: google.cloud.networkservices.v1.GrpcRoute.RouteAction.destinations:type_name -> google.cloud.networkservices.v1.GrpcRoute.Destination
	13, // 15: google.cloud.networkservices.v1.GrpcRoute.RouteAction.fault_injection_policy:type_name -> google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy
	22, // 16: google.cloud.networkservices.v1.GrpcRoute.RouteAction.timeout:type_name -> google.protobuf.Duration
	14, // 17: google.cloud.networkservices.v1.GrpcRoute.RouteAction.retry_policy:type_name -> google.cloud.networkservices.v1.GrpcRoute.RetryPolicy
	11, // 18: google.cloud.networkservices.v1.GrpcRoute.RouteRule.matches:type_name -> google.cloud.networkservices.v1.GrpcRoute.RouteMatch
	15, // 19: google.cloud.networkservices.v1.GrpcRoute.RouteRule.action:type_name -> google.cloud.networkservices.v1.GrpcRoute.RouteAction
	22, // 20: google.cloud.networkservices.v1.GrpcRoute.FaultInjectionPolicy.Delay.fixed_delay:type_name -> google.protobuf.Duration
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_networkservices_v1_grpc_route_proto_init() }
func file_google_cloud_networkservices_v1_grpc_route_proto_init() {
	if File_google_cloud_networkservices_v1_grpc_route_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGrpcRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGrpcRoutesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGrpcRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGrpcRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGrpcRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGrpcRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_MethodMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_HeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_RouteMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_FaultInjectionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_RetryPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_RouteAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_RouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_FaultInjectionPolicy_Delay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GrpcRoute_FaultInjectionPolicy_Abort); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*GrpcRoute_Destination_ServiceName)(nil),
	}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[16].OneofWrappers = []interface{}{}
	file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes[17].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkservices_v1_grpc_route_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkservices_v1_grpc_route_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkservices_v1_grpc_route_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkservices_v1_grpc_route_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkservices_v1_grpc_route_proto_msgTypes,
	}.Build()
	File_google_cloud_networkservices_v1_grpc_route_proto = out.File
	file_google_cloud_networkservices_v1_grpc_route_proto_rawDesc = nil
	file_google_cloud_networkservices_v1_grpc_route_proto_goTypes = nil
	file_google_cloud_networkservices_v1_grpc_route_proto_depIdxs = nil
}
