//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscvmm

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySet.
func (a AvailabilitySet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySet.
func (a *AvailabilitySet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetListItem.
func (a AvailabilitySetListItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetListItem.
func (a *AvailabilitySetListItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetListResult.
func (a AvailabilitySetListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetListResult.
func (a *AvailabilitySetListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilitySetProperties.
func (a AvailabilitySetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilitySetName", a.AvailabilitySetName)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "vmmServerId", a.VmmServerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilitySetProperties.
func (a *AvailabilitySetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilitySetName":
			err = unpopulate(val, "AvailabilitySetName", &a.AvailabilitySetName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "vmmServerId":
			err = unpopulate(val, "VmmServerID", &a.VmmServerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Checkpoint.
func (c Checkpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "checkpointID", c.CheckpointID)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "parentCheckpointID", c.ParentCheckpointID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Checkpoint.
func (c *Checkpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "checkpointID":
			err = unpopulate(val, "CheckpointID", &c.CheckpointID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "parentCheckpointID":
			err = unpopulate(val, "ParentCheckpointID", &c.ParentCheckpointID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cloud.
func (c Cloud) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cloud.
func (c *Cloud) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudCapacity.
func (c CloudCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCount", c.CPUCount)
	populate(objectMap, "memoryMB", c.MemoryMB)
	populate(objectMap, "vmCount", c.VMCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudCapacity.
func (c *CloudCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCount":
			err = unpopulate(val, "CPUCount", &c.CPUCount)
			delete(rawMsg, key)
		case "memoryMB":
			err = unpopulate(val, "MemoryMB", &c.MemoryMB)
			delete(rawMsg, key)
		case "vmCount":
			err = unpopulate(val, "VMCount", &c.VMCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudInventoryItem.
func (c CloudInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inventoryItemName", c.InventoryItemName)
	objectMap["inventoryType"] = InventoryTypeCloud
	populate(objectMap, "managedResourceId", c.ManagedResourceID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "uuid", c.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudInventoryItem.
func (c *CloudInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &c.InventoryItemName)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &c.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &c.ManagedResourceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &c.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudListResult.
func (c CloudListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudListResult.
func (c *CloudListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProperties.
func (c CloudProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloudCapacity", c.CloudCapacity)
	populate(objectMap, "cloudName", c.CloudName)
	populate(objectMap, "inventoryItemId", c.InventoryItemID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "storageQoSPolicies", c.StorageQoSPolicies)
	populate(objectMap, "uuid", c.UUID)
	populate(objectMap, "vmmServerId", c.VmmServerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProperties.
func (c *CloudProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloudCapacity":
			err = unpopulate(val, "CloudCapacity", &c.CloudCapacity)
			delete(rawMsg, key)
		case "cloudName":
			err = unpopulate(val, "CloudName", &c.CloudName)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &c.InventoryItemID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "storageQoSPolicies":
			err = unpopulate(val, "StorageQoSPolicies", &c.StorageQoSPolicies)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &c.UUID)
			delete(rawMsg, key)
		case "vmmServerId":
			err = unpopulate(val, "VmmServerID", &c.VmmServerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfile.
func (h HardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCount", h.CPUCount)
	populate(objectMap, "dynamicMemoryEnabled", h.DynamicMemoryEnabled)
	populate(objectMap, "dynamicMemoryMaxMB", h.DynamicMemoryMaxMB)
	populate(objectMap, "dynamicMemoryMinMB", h.DynamicMemoryMinMB)
	populate(objectMap, "isHighlyAvailable", h.IsHighlyAvailable)
	populate(objectMap, "limitCpuForMigration", h.LimitCPUForMigration)
	populate(objectMap, "memoryMB", h.MemoryMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfile.
func (h *HardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCount":
			err = unpopulate(val, "CPUCount", &h.CPUCount)
			delete(rawMsg, key)
		case "dynamicMemoryEnabled":
			err = unpopulate(val, "DynamicMemoryEnabled", &h.DynamicMemoryEnabled)
			delete(rawMsg, key)
		case "dynamicMemoryMaxMB":
			err = unpopulate(val, "DynamicMemoryMaxMB", &h.DynamicMemoryMaxMB)
			delete(rawMsg, key)
		case "dynamicMemoryMinMB":
			err = unpopulate(val, "DynamicMemoryMinMB", &h.DynamicMemoryMinMB)
			delete(rawMsg, key)
		case "isHighlyAvailable":
			err = unpopulate(val, "IsHighlyAvailable", &h.IsHighlyAvailable)
			delete(rawMsg, key)
		case "limitCpuForMigration":
			err = unpopulate(val, "LimitCPUForMigration", &h.LimitCPUForMigration)
			delete(rawMsg, key)
		case "memoryMB":
			err = unpopulate(val, "MemoryMB", &h.MemoryMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfileUpdate.
func (h HardwareProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCount", h.CPUCount)
	populate(objectMap, "dynamicMemoryEnabled", h.DynamicMemoryEnabled)
	populate(objectMap, "dynamicMemoryMaxMB", h.DynamicMemoryMaxMB)
	populate(objectMap, "dynamicMemoryMinMB", h.DynamicMemoryMinMB)
	populate(objectMap, "limitCpuForMigration", h.LimitCPUForMigration)
	populate(objectMap, "memoryMB", h.MemoryMB)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfileUpdate.
func (h *HardwareProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCount":
			err = unpopulate(val, "CPUCount", &h.CPUCount)
			delete(rawMsg, key)
		case "dynamicMemoryEnabled":
			err = unpopulate(val, "DynamicMemoryEnabled", &h.DynamicMemoryEnabled)
			delete(rawMsg, key)
		case "dynamicMemoryMaxMB":
			err = unpopulate(val, "DynamicMemoryMaxMB", &h.DynamicMemoryMaxMB)
			delete(rawMsg, key)
		case "dynamicMemoryMinMB":
			err = unpopulate(val, "DynamicMemoryMinMB", &h.DynamicMemoryMinMB)
			delete(rawMsg, key)
		case "limitCpuForMigration":
			err = unpopulate(val, "LimitCPUForMigration", &h.LimitCPUForMigration)
			delete(rawMsg, key)
		case "memoryMB":
			err = unpopulate(val, "MemoryMB", &h.MemoryMB)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItem.
func (i InventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "kind", i.Kind)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItem.
func (i *InventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalInventoryItemPropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemDetails.
func (i InventoryItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inventoryItemId", i.InventoryItemID)
	populate(objectMap, "inventoryItemName", i.InventoryItemName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemDetails.
func (i *InventoryItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &i.InventoryItemID)
			delete(rawMsg, key)
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &i.InventoryItemName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemProperties.
func (i InventoryItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inventoryItemName", i.InventoryItemName)
	objectMap["inventoryType"] = i.InventoryType
	populate(objectMap, "managedResourceId", i.ManagedResourceID)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	populate(objectMap, "uuid", i.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemProperties.
func (i *InventoryItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &i.InventoryItemName)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &i.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &i.ManagedResourceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &i.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemsList.
func (i InventoryItemsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemsList.
func (i *InventoryItemsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaces.
func (n NetworkInterfaces) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "ipv4AddressType", n.IPv4AddressType)
	populate(objectMap, "ipv4Addresses", n.IPv4Addresses)
	populate(objectMap, "ipv6AddressType", n.IPv6AddressType)
	populate(objectMap, "ipv6Addresses", n.IPv6Addresses)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "macAddressType", n.MacAddressType)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "networkName", n.NetworkName)
	populate(objectMap, "nicId", n.NicID)
	populate(objectMap, "virtualNetworkId", n.VirtualNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaces.
func (n *NetworkInterfaces) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "ipv4AddressType":
			err = unpopulate(val, "IPv4AddressType", &n.IPv4AddressType)
			delete(rawMsg, key)
		case "ipv4Addresses":
			err = unpopulate(val, "IPv4Addresses", &n.IPv4Addresses)
			delete(rawMsg, key)
		case "ipv6AddressType":
			err = unpopulate(val, "IPv6AddressType", &n.IPv6AddressType)
			delete(rawMsg, key)
		case "ipv6Addresses":
			err = unpopulate(val, "IPv6Addresses", &n.IPv6Addresses)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "macAddressType":
			err = unpopulate(val, "MacAddressType", &n.MacAddressType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &n.NetworkName)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &n.NicID)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &n.VirtualNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfacesUpdate.
func (n NetworkInterfacesUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipv4AddressType", n.IPv4AddressType)
	populate(objectMap, "ipv6AddressType", n.IPv6AddressType)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "macAddressType", n.MacAddressType)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "nicId", n.NicID)
	populate(objectMap, "virtualNetworkId", n.VirtualNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfacesUpdate.
func (n *NetworkInterfacesUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipv4AddressType":
			err = unpopulate(val, "IPv4AddressType", &n.IPv4AddressType)
			delete(rawMsg, key)
		case "ipv6AddressType":
			err = unpopulate(val, "IPv6AddressType", &n.IPv6AddressType)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "macAddressType":
			err = unpopulate(val, "MacAddressType", &n.MacAddressType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &n.NicID)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &n.VirtualNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfileUpdate.
func (n NetworkProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfileUpdate.
func (n *NetworkProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfile.
func (o OsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "computerName", o.ComputerName)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "osType", o.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfile.
func (o *OsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &o.ComputerName)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePatch.
func (r ResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePatch.
func (r *ResourcePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperation.
func (r ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", r.Display)
	populate(objectMap, "isDataAction", r.IsDataAction)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperation.
func (r *ResourceProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &r.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &r.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationDisplay.
func (r ResourceProviderOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "operation", r.Operation)
	populate(objectMap, "provider", r.Provider)
	populate(objectMap, "resource", r.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationDisplay.
func (r *ResourceProviderOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &r.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &r.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &r.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationList.
func (r ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationList.
func (r *ResourceProviderOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopVirtualMachineOptions.
func (s StopVirtualMachineOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "skipShutdown", s.SkipShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopVirtualMachineOptions.
func (s *StopVirtualMachineOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipShutdown":
			err = unpopulate(val, "SkipShutdown", &s.SkipShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disks", s.Disks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &s.Disks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfileUpdate.
func (s StorageProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "disks", s.Disks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfileUpdate.
func (s *StorageProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &s.Disks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageQoSPolicy.
func (s StorageQoSPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bandwidthLimit", s.BandwidthLimit)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "iopsMaximum", s.IopsMaximum)
	populate(objectMap, "iopsMinimum", s.IopsMinimum)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "policyId", s.PolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageQoSPolicy.
func (s *StorageQoSPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bandwidthLimit":
			err = unpopulate(val, "BandwidthLimit", &s.BandwidthLimit)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "iopsMaximum":
			err = unpopulate(val, "IopsMaximum", &s.IopsMaximum)
			delete(rawMsg, key)
		case "iopsMinimum":
			err = unpopulate(val, "IopsMinimum", &s.IopsMinimum)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &s.PolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageQoSPolicyDetails.
func (s StorageQoSPolicyDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageQoSPolicyDetails.
func (s *StorageQoSPolicyDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMMServer.
func (v VMMServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMMServer.
func (v *VMMServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMMServerListResult.
func (v VMMServerListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMMServerListResult.
func (v *VMMServerListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMMServerProperties.
func (v VMMServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionStatus", v.ConnectionStatus)
	populate(objectMap, "credentials", v.Credentials)
	populate(objectMap, "errorMessage", v.ErrorMessage)
	populate(objectMap, "fqdn", v.Fqdn)
	populate(objectMap, "port", v.Port)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMMServerProperties.
func (v *VMMServerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &v.ConnectionStatus)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &v.Credentials)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &v.ErrorMessage)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &v.Fqdn)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &v.Port)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMMServerPropertiesCredentials.
func (v VMMServerPropertiesCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", v.Password)
	populate(objectMap, "username", v.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMMServerPropertiesCredentials.
func (v *VMMServerPropertiesCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &v.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &v.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDisk.
func (v VirtualDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bus", v.Bus)
	populate(objectMap, "busType", v.BusType)
	populate(objectMap, "createDiffDisk", v.CreateDiffDisk)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "displayName", v.DisplayName)
	populate(objectMap, "lun", v.Lun)
	populate(objectMap, "maxDiskSizeGB", v.MaxDiskSizeGB)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "storageQoSPolicy", v.StorageQoSPolicy)
	populate(objectMap, "templateDiskId", v.TemplateDiskID)
	populate(objectMap, "vhdFormatType", v.VhdFormatType)
	populate(objectMap, "vhdType", v.VhdType)
	populate(objectMap, "volumeType", v.VolumeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDisk.
func (v *VirtualDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bus":
			err = unpopulate(val, "Bus", &v.Bus)
			delete(rawMsg, key)
		case "busType":
			err = unpopulate(val, "BusType", &v.BusType)
			delete(rawMsg, key)
		case "createDiffDisk":
			err = unpopulate(val, "CreateDiffDisk", &v.CreateDiffDisk)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &v.DisplayName)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &v.Lun)
			delete(rawMsg, key)
		case "maxDiskSizeGB":
			err = unpopulate(val, "MaxDiskSizeGB", &v.MaxDiskSizeGB)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "storageQoSPolicy":
			err = unpopulate(val, "StorageQoSPolicy", &v.StorageQoSPolicy)
			delete(rawMsg, key)
		case "templateDiskId":
			err = unpopulate(val, "TemplateDiskID", &v.TemplateDiskID)
			delete(rawMsg, key)
		case "vhdFormatType":
			err = unpopulate(val, "VhdFormatType", &v.VhdFormatType)
			delete(rawMsg, key)
		case "vhdType":
			err = unpopulate(val, "VhdType", &v.VhdType)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &v.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDiskUpdate.
func (v VirtualDiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bus", v.Bus)
	populate(objectMap, "busType", v.BusType)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "lun", v.Lun)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "storageQoSPolicy", v.StorageQoSPolicy)
	populate(objectMap, "vhdType", v.VhdType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDiskUpdate.
func (v *VirtualDiskUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bus":
			err = unpopulate(val, "Bus", &v.Bus)
			delete(rawMsg, key)
		case "busType":
			err = unpopulate(val, "BusType", &v.BusType)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &v.Lun)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "storageQoSPolicy":
			err = unpopulate(val, "StorageQoSPolicy", &v.StorageQoSPolicy)
			delete(rawMsg, key)
		case "vhdType":
			err = unpopulate(val, "VhdType", &v.VhdType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineCreateCheckpoint.
func (v VirtualMachineCreateCheckpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "name", v.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineCreateCheckpoint.
func (v *VirtualMachineCreateCheckpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineDeleteCheckpoint.
func (v VirtualMachineDeleteCheckpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineDeleteCheckpoint.
func (v *VirtualMachineDeleteCheckpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInventoryItem.
func (v VirtualMachineInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloud", v.Cloud)
	populate(objectMap, "ipAddresses", v.IPAddresses)
	populate(objectMap, "inventoryItemName", v.InventoryItemName)
	objectMap["inventoryType"] = InventoryTypeVirtualMachine
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "powerState", v.PowerState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInventoryItem.
func (v *VirtualMachineInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloud":
			err = unpopulate(val, "Cloud", &v.Cloud)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &v.IPAddresses)
			delete(rawMsg, key)
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &v.InventoryItemName)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &v.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineListResult.
func (v VirtualMachineListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineListResult.
func (v *VirtualMachineListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilitySets", v.AvailabilitySets)
	populate(objectMap, "checkpointType", v.CheckpointType)
	populate(objectMap, "checkpoints", v.Checkpoints)
	populate(objectMap, "cloudId", v.CloudID)
	populate(objectMap, "generation", v.Generation)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "powerState", v.PowerState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "templateId", v.TemplateID)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vmName", v.VMName)
	populate(objectMap, "vmmServerId", v.VmmServerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilitySets":
			err = unpopulate(val, "AvailabilitySets", &v.AvailabilitySets)
			delete(rawMsg, key)
		case "checkpointType":
			err = unpopulate(val, "CheckpointType", &v.CheckpointType)
			delete(rawMsg, key)
		case "checkpoints":
			err = unpopulate(val, "Checkpoints", &v.Checkpoints)
			delete(rawMsg, key)
		case "cloudId":
			err = unpopulate(val, "CloudID", &v.CloudID)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &v.Generation)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &v.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "templateId":
			err = unpopulate(val, "TemplateID", &v.TemplateID)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &v.VMName)
			delete(rawMsg, key)
		case "vmmServerId":
			err = unpopulate(val, "VmmServerID", &v.VmmServerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineRestoreCheckpoint.
func (v VirtualMachineRestoreCheckpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineRestoreCheckpoint.
func (v *VirtualMachineRestoreCheckpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplate.
func (v VirtualMachineTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplate.
func (v *VirtualMachineTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplateInventoryItem.
func (v VirtualMachineTemplateInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCount", v.CPUCount)
	populate(objectMap, "inventoryItemName", v.InventoryItemName)
	objectMap["inventoryType"] = InventoryTypeVirtualMachineTemplate
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "memoryMB", v.MemoryMB)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplateInventoryItem.
func (v *VirtualMachineTemplateInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCount":
			err = unpopulate(val, "CPUCount", &v.CPUCount)
			delete(rawMsg, key)
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &v.InventoryItemName)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "memoryMB":
			err = unpopulate(val, "MemoryMB", &v.MemoryMB)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplateListResult.
func (v VirtualMachineTemplateListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplateListResult.
func (v *VirtualMachineTemplateListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplateProperties.
func (v VirtualMachineTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpuCount", v.CPUCount)
	populate(objectMap, "computerName", v.ComputerName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "dynamicMemoryEnabled", v.DynamicMemoryEnabled)
	populate(objectMap, "dynamicMemoryMaxMB", v.DynamicMemoryMaxMB)
	populate(objectMap, "dynamicMemoryMinMB", v.DynamicMemoryMinMB)
	populate(objectMap, "generation", v.Generation)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "isCustomizable", v.IsCustomizable)
	populate(objectMap, "isHighlyAvailable", v.IsHighlyAvailable)
	populate(objectMap, "limitCpuForMigration", v.LimitCPUForMigration)
	populate(objectMap, "memoryMB", v.MemoryMB)
	populate(objectMap, "networkInterfaces", v.NetworkInterfaces)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vmmServerId", v.VmmServerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplateProperties.
func (v *VirtualMachineTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuCount":
			err = unpopulate(val, "CPUCount", &v.CPUCount)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &v.ComputerName)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "dynamicMemoryEnabled":
			err = unpopulate(val, "DynamicMemoryEnabled", &v.DynamicMemoryEnabled)
			delete(rawMsg, key)
		case "dynamicMemoryMaxMB":
			err = unpopulate(val, "DynamicMemoryMaxMB", &v.DynamicMemoryMaxMB)
			delete(rawMsg, key)
		case "dynamicMemoryMinMB":
			err = unpopulate(val, "DynamicMemoryMinMB", &v.DynamicMemoryMinMB)
			delete(rawMsg, key)
		case "generation":
			err = unpopulate(val, "Generation", &v.Generation)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "isCustomizable":
			err = unpopulate(val, "IsCustomizable", &v.IsCustomizable)
			delete(rawMsg, key)
		case "isHighlyAvailable":
			err = unpopulate(val, "IsHighlyAvailable", &v.IsHighlyAvailable)
			delete(rawMsg, key)
		case "limitCpuForMigration":
			err = unpopulate(val, "LimitCPUForMigration", &v.LimitCPUForMigration)
			delete(rawMsg, key)
		case "memoryMB":
			err = unpopulate(val, "MemoryMB", &v.MemoryMB)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &v.NetworkInterfaces)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vmmServerId":
			err = unpopulate(val, "VmmServerID", &v.VmmServerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdate.
func (v VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdate.
func (v *VirtualMachineUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdateProperties.
func (v VirtualMachineUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilitySets", v.AvailabilitySets)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdateProperties.
func (v *VirtualMachineUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilitySets":
			err = unpopulate(val, "AvailabilitySets", &v.AvailabilitySets)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetwork.
func (v *VirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkInventoryItem.
func (v VirtualNetworkInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inventoryItemName", v.InventoryItemName)
	objectMap["inventoryType"] = InventoryTypeVirtualNetwork
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkInventoryItem.
func (v *VirtualNetworkInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemName":
			err = unpopulate(val, "InventoryItemName", &v.InventoryItemName)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkListResult.
func (v VirtualNetworkListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkListResult.
func (v *VirtualNetworkListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProperties.
func (v VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "networkName", v.NetworkName)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vmmServerId", v.VmmServerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProperties.
func (v *VirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &v.NetworkName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vmmServerId":
			err = unpopulate(val, "VmmServerID", &v.VmmServerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
