//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmarketplace_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/marketplace/armmarketplace"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStores.json
func ExamplePrivateStoreClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPrivateStoreClient().NewListPager(&armmarketplace.PrivateStoreClientListOptions{UseCache: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateStoreList = armmarketplace.PrivateStoreList{
		// 	Value: []*armmarketplace.PrivateStore{
		// 		{
		// 			Name: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
		// 			Type: to.Ptr("Microsoft.Marketplace/privateStores"),
		// 			ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
		// 			Properties: &armmarketplace.PrivateStoreProperties{
		// 				Availability: to.Ptr(armmarketplace.AvailabilityEnabled),
		// 				Branding: map[string]*string{
		// 					"color": to.Ptr("blue"),
		// 					"iconUrl": to.Ptr("https://some-images.someDomail.com/image/stroeIcon.12345678-4321"),
		// 				},
		// 				CollectionIDs: []*string{
		// 					to.Ptr("ab80ed4-c5de-4593-b3c1-c46d4a3a56c7"),
		// 					to.Ptr("a09107d4-c585-4594-b3c6-c46d4a3a56c8")},
		// 					ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350332\""),
		// 					IsGov: to.Ptr(false),
		// 					NotificationsSettings: &armmarketplace.NotificationsSettingsProperties{
		// 						Recipients: []*armmarketplace.Recipient{
		// 							{
		// 								DisplayName: to.Ptr("John Doe"),
		// 								EmailAddress: to.Ptr("john_doe@microsoft.com"),
		// 								PrincipalID: to.Ptr("6d583005-403b-407a-8ac0-c4af72b47ce9"),
		// 							},
		// 							{
		// 								DisplayName: to.Ptr("Jane Doe"),
		// 								EmailAddress: to.Ptr("jane_doe@microsoft.com"),
		// 								PrincipalID: to.Ptr("c5b680d4-aac2-4940-9e1c-399454056ff2"),
		// 						}},
		// 						SendToAllMarketplaceAdmins: to.Ptr(true),
		// 					},
		// 					PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
		// 					TenantID: to.Ptr("f686d426-123a-42db-81b7-ab578e110ccd"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetPrivateStore.json
func ExamplePrivateStoreClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().Get(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateStore = armmarketplace.PrivateStore{
	// 	Name: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 	Properties: &armmarketplace.PrivateStoreProperties{
	// 		Availability: to.Ptr(armmarketplace.AvailabilityEnabled),
	// 		Branding: map[string]*string{
	// 			"color": to.Ptr("blue"),
	// 			"iconUrl": to.Ptr("https://some-images.someDomail.com/image/stroeIcon.12345678-4321"),
	// 		},
	// 		CollectionIDs: []*string{
	// 			to.Ptr("ab80ed4-c5de-4593-b3c1-c46d4a3a56c7"),
	// 			to.Ptr("a09107d4-c585-4594-b3c6-c46d4a3a56c8")},
	// 			ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350345\""),
	// 			IsGov: to.Ptr(false),
	// 			NotificationsSettings: &armmarketplace.NotificationsSettingsProperties{
	// 				Recipients: []*armmarketplace.Recipient{
	// 					{
	// 						DisplayName: to.Ptr("John Doe"),
	// 						EmailAddress: to.Ptr("john_doe@microsoft.com"),
	// 						PrincipalID: to.Ptr("6d583005-403b-407a-8ac0-c4af72b47ce9"),
	// 					},
	// 					{
	// 						DisplayName: to.Ptr("Jane Doe"),
	// 						EmailAddress: to.Ptr("jane_doe@microsoft.com"),
	// 						PrincipalID: to.Ptr("c5b680d4-aac2-4940-9e1c-399454056ff2"),
	// 				}},
	// 				SendToAllMarketplaceAdmins: to.Ptr(true),
	// 			},
	// 			PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 			TenantID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/PrivateStores_update.json
func ExamplePrivateStoreClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreClient().CreateOrUpdate(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientCreateOrUpdateOptions{Payload: &armmarketplace.PrivateStore{
		Properties: &armmarketplace.PrivateStoreProperties{
			Availability: to.Ptr(armmarketplace.AvailabilityDisabled),
			ETag:         to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350345\""),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/DeletePrivateStore.json
func ExamplePrivateStoreClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreClient().Delete(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/QueryOffers.json
func ExamplePrivateStoreClient_QueryOffers() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().QueryOffers(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryOffers = armmarketplace.QueryOffers{
	// 	Value: []*armmarketplace.OfferProperties{
	// 		{
	// 			CreatedAt: to.Ptr("05/28/2015 5:50"),
	// 			ETag: to.Ptr("\"9301f4fd-0000-0100-0000-5e248b350000\""),
	// 			ModifiedAt: to.Ptr("05/29/2015 5:50"),
	// 			OfferDisplayName: to.Ptr("md-test-third-party-2"),
	// 			PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 			PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
	// 			SpecificPlanIDsLimitation: []*string{
	// 				to.Ptr("0001"),
	// 				to.Ptr("0002"),
	// 				to.Ptr("0003")},
	// 				UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 			},
	// 			{
	// 				CreatedAt: to.Ptr("05/28/2015 5:50"),
	// 				ETag: to.Ptr("\"9301f4fd-0000-0100-0304-5e248b350043\""),
	// 				ModifiedAt: to.Ptr("05/29/2015 5:50"),
	// 				OfferDisplayName: to.Ptr("md-test-third-party-3"),
	// 				PrivateStoreID: to.Ptr("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
	// 				PublisherDisplayName: to.Ptr("Marketplace Test Third Party"),
	// 				SpecificPlanIDsLimitation: []*string{
	// 					to.Ptr("0001"),
	// 					to.Ptr("0002")},
	// 					UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-3"),
	// 			}},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/BillingAccounts.json
func ExamplePrivateStoreClient_BillingAccounts() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().BillingAccounts(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BillingAccountsResponse = armmarketplace.BillingAccountsResponse{
	// 	BillingAccounts: []*string{
	// 		to.Ptr("Billing Account 1"),
	// 		to.Ptr("Billing Account 2")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/CollectionsToSubscriptionsMapping.json
func ExamplePrivateStoreClient_CollectionsToSubscriptionsMapping() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().CollectionsToSubscriptionsMapping(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientCollectionsToSubscriptionsMappingOptions{Payload: &armmarketplace.CollectionsToSubscriptionsMappingPayload{
		Properties: &armmarketplace.CollectionsToSubscriptionsMappingProperties{
			SubscriptionIDs: []*string{
				to.Ptr("b340914e-353d-453a-85fb-8f9b65b51f91"),
				to.Ptr("f2baa04d-5bfc-461b-b6d8-61b403c9ec48")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CollectionsToSubscriptionsMappingResponse = armmarketplace.CollectionsToSubscriptionsMappingResponse{
	// 	Details: map[string]*armmarketplace.CollectionsSubscriptionsMappingDetails{
	// 		"4eb49758-f591-486f-bd58-dff00fb7a8d8": &armmarketplace.CollectionsSubscriptionsMappingDetails{
	// 			CollectionName: to.Ptr("Test Collection"),
	// 			Subscriptions: []*string{
	// 				to.Ptr("b340914e-353d-453a-85fb-8f9b65b51f91"),
	// 				to.Ptr("f2baa04d-5bfc-461b-b6d8-61b403c9ec48")},
	// 			},
	// 			"74c02e27-2524-436c-831d-d64565f31153": &armmarketplace.CollectionsSubscriptionsMappingDetails{
	// 				CollectionName: to.Ptr("Test Collection 2"),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/QueryApprovedPlans.json
func ExamplePrivateStoreClient_QueryApprovedPlans() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().QueryApprovedPlans(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientQueryApprovedPlansOptions{Payload: &armmarketplace.QueryApprovedPlansPayload{
		Properties: &armmarketplace.QueryApprovedPlans{
			OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
			PlanIDs: []*string{
				to.Ptr("testPlanA"),
				to.Ptr("testPlanB"),
				to.Ptr("testPlanC")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryApprovedPlansResponse = armmarketplace.QueryApprovedPlansResponse{
	// 	Details: []*armmarketplace.QueryApprovedPlansDetails{
	// 		{
	// 			AllSubscriptions: to.Ptr(false),
	// 			PlanID: to.Ptr("testPlanA"),
	// 			SubscriptionIDs: []*string{
	// 				to.Ptr("85e3e079-c718-4e4c-abbe-f72fceba8305"),
	// 				to.Ptr("7752d461-4bf1-4185-8b56-8a3f11486ac6")},
	// 			},
	// 			{
	// 				AllSubscriptions: to.Ptr(true),
	// 				PlanID: to.Ptr("testPlanB"),
	// 				SubscriptionIDs: []*string{
	// 				},
	// 			},
	// 			{
	// 				AllSubscriptions: to.Ptr(false),
	// 				PlanID: to.Ptr("testPlanC"),
	// 				SubscriptionIDs: []*string{
	// 				},
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/BulkCollectionsAction.json
func ExamplePrivateStoreClient_BulkCollectionsAction() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().BulkCollectionsAction(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientBulkCollectionsActionOptions{Payload: &armmarketplace.BulkCollectionsPayload{
		Properties: &armmarketplace.BulkCollectionsDetails{
			Action: to.Ptr("EnableCollections"),
			CollectionIDs: []*string{
				to.Ptr("c752f021-1c37-4af5-b82f-74c51c27b44a"),
				to.Ptr("f47ef1c7-e908-4f39-ae29-db181634ad8d")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BulkCollectionsResponse = armmarketplace.BulkCollectionsResponse{
	// 	Failed: []*armmarketplace.CollectionsDetails{
	// 		{
	// 			CollectionID: to.Ptr("f47ef1c7-e908-4f39-ae29-db181634ad8d"),
	// 			CollectionName: to.Ptr("Test collection 2"),
	// 	}},
	// 	Succeeded: []*armmarketplace.CollectionsDetails{
	// 		{
	// 			CollectionID: to.Ptr("c752f021-1c37-4af5-b82f-74c51c27b44a"),
	// 			CollectionName: to.Ptr("Test collection"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetApprovalRequestsList.json
func ExamplePrivateStoreClient_GetApprovalRequestsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().GetApprovalRequestsList(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RequestApprovalsList = armmarketplace.RequestApprovalsList{
	// 	Value: []*armmarketplace.RequestApprovalResource{
	// 		{
	// 			Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 			Type: to.Ptr("Microsoft.Marketplace/privateStores/requestApprovals"),
	// 			ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/9afd3c45-5230-4d58-9469-2cacc00bba68/requestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 			SystemData: &armmarketplace.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				CreatedBy: to.Ptr("user@somedoamin.com"),
	// 				CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 				LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 			},
	// 			Properties: &armmarketplace.RequestApprovalProperties{
	// 				IsClosed: to.Ptr(false),
	// 				MessageCode: to.Ptr[int64](0),
	// 				OfferDisplayName: to.Ptr("Offer Display name"),
	// 				OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 				PlansDetails: []*armmarketplace.PlanDetails{
	// 					{
	// 						Justification: to.Ptr("Because I want to...."),
	// 						PlanID: to.Ptr("testPlanA"),
	// 						RequestDate: "2021-02-01T10:23:17.6571572+02:00",
	// 						Status: to.Ptr(armmarketplace.StatusPending),
	// 						SubscriptionID: to.Ptr(""),
	// 						SubscriptionName: to.Ptr(""),
	// 					},
	// 					{
	// 						Justification: to.Ptr("try me :)"),
	// 						PlanID: to.Ptr("*"),
	// 						RequestDate: "2021-02-01T10:23:17.6571572+02:00",
	// 						Status: to.Ptr(armmarketplace.StatusPending),
	// 						SubscriptionID: to.Ptr(""),
	// 						SubscriptionName: to.Ptr(""),
	// 				}},
	// 				PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetRequestApproval.json
func ExamplePrivateStoreClient_GetRequestApproval() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().GetRequestApproval(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RequestApprovalResource = armmarketplace.RequestApprovalResource{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/requestApprovals"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/requestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("test@somedomain.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser@somedomail.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.RequestApprovalProperties{
	// 		IsClosed: to.Ptr(false),
	// 		MessageCode: to.Ptr[int64](0),
	// 		OfferDisplayName: to.Ptr("Offer display Name"),
	// 		OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 		PlansDetails: []*armmarketplace.PlanDetails{
	// 			{
	// 				Justification: to.Ptr("Because I want to...."),
	// 				PlanID: to.Ptr("testPlanA"),
	// 				RequestDate: "2020-10-05T17:18:19.1234567Z",
	// 				Status: to.Ptr(armmarketplace.StatusPending),
	// 				SubscriptionID: to.Ptr(""),
	// 				SubscriptionName: to.Ptr(""),
	// 			},
	// 			{
	// 				Justification: to.Ptr("Because I want to...."),
	// 				PlanID: to.Ptr("testPlanB"),
	// 				RequestDate: "2020-10-05T17:18:19.1234567Z",
	// 				Status: to.Ptr(armmarketplace.StatusPending),
	// 				SubscriptionID: to.Ptr(""),
	// 				SubscriptionName: to.Ptr(""),
	// 		}},
	// 		PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/CreateApprovalRequest.json
func ExamplePrivateStoreClient_CreateApprovalRequest() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().CreateApprovalRequest(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", &armmarketplace.PrivateStoreClientCreateApprovalRequestOptions{Payload: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RequestApprovalResource = armmarketplace.RequestApprovalResource{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("Microsoft.Marketplace/privateStores/requestApprovals"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/9afd3c45-5230-4d58-9469-2cacc00bba68/requestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@somedoamin.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.RequestApprovalProperties{
	// 		IsClosed: to.Ptr(false),
	// 		MessageCode: to.Ptr[int64](0),
	// 		OfferDisplayName: to.Ptr("Offer Display name"),
	// 		OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 		PlansDetails: []*armmarketplace.PlanDetails{
	// 			{
	// 				Justification: to.Ptr("Because I want to...."),
	// 				PlanID: to.Ptr("testPlanA"),
	// 				RequestDate: "2021-02-01T10:23:17.6571572+02:00",
	// 				Status: to.Ptr(armmarketplace.StatusPending),
	// 				SubscriptionID: to.Ptr("4ca4753c-5a1e-4913-b849-2c68880e03c2"),
	// 				SubscriptionName: to.Ptr("Test subscription 2"),
	// 			},
	// 			{
	// 				Justification: to.Ptr("try me :)"),
	// 				PlanID: to.Ptr("*"),
	// 				RequestDate: "2021-02-01T10:23:17.6571572+02:00",
	// 				Status: to.Ptr(armmarketplace.StatusPending),
	// 				SubscriptionID: to.Ptr("4ca4753c-5a1e-4913-b849-2c68880e03c2"),
	// 				SubscriptionName: to.Ptr("Test subscription 2"),
	// 		}},
	// 		PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/QueryRequestApproval.json
func ExamplePrivateStoreClient_QueryRequestApproval() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().QueryRequestApproval(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", &armmarketplace.PrivateStoreClientQueryRequestApprovalOptions{Payload: &armmarketplace.QueryRequestApprovalProperties{
		Properties: &armmarketplace.RequestDetails{
			PlanIDs: []*string{
				to.Ptr("testPlanA"),
				to.Ptr("testPlanB"),
				to.Ptr("*")},
			PublisherID: to.Ptr("marketplacetestthirdparty"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.QueryRequestApproval = armmarketplace.QueryRequestApproval{
	// 	MessageCode: to.Ptr[int64](0),
	// 	PlansDetails: map[string]*armmarketplace.PlanDetails{
	// 		"*": &armmarketplace.PlanDetails{
	// 			PlanID: to.Ptr("*"),
	// 			Status: to.Ptr(armmarketplace.StatusNone),
	// 			SubscriptionID: to.Ptr(""),
	// 			SubscriptionName: to.Ptr(""),
	// 		},
	// 		"byol": &armmarketplace.PlanDetails{
	// 			Justification: to.Ptr(""),
	// 			PlanID: to.Ptr("testPlanA"),
	// 			Status: to.Ptr(armmarketplace.StatusNone),
	// 			SubscriptionID: to.Ptr(""),
	// 			SubscriptionName: to.Ptr(""),
	// 		},
	// 		"hourly": &armmarketplace.PlanDetails{
	// 			Justification: to.Ptr(""),
	// 			PlanID: to.Ptr("testPlanB"),
	// 			Status: to.Ptr(armmarketplace.Status("ApprovedByAdmin")),
	// 			SubscriptionID: to.Ptr("4ca4753c-5a1e-4913-b849-2c68880e03c2"),
	// 			SubscriptionName: to.Ptr("Test subscription 2"),
	// 		},
	// 	},
	// 	UniqueOfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/AdminRequestApprovalsList.json
func ExamplePrivateStoreClient_AdminRequestApprovalsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().AdminRequestApprovalsList(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdminRequestApprovalsList = armmarketplace.AdminRequestApprovalsList{
	// 	Value: []*armmarketplace.AdminRequestApprovalsResource{
	// 		{
	// 			Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 			Type: to.Ptr("/providers/Microsoft.Marketplace/privateStores/adminRequestApprovals"),
	// 			ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/adminRequestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 			SystemData: &armmarketplace.SystemData{
	// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				CreatedBy: to.Ptr("user@somedoamin.com"),
	// 				CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 				LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 				LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 			},
	// 			Properties: &armmarketplace.AdminRequestApprovalProperties{
	// 				AdminAction: to.Ptr(armmarketplace.AdminAction("Pending")),
	// 				CollectionIDs: []*string{
	// 				},
	// 				DisplayName: to.Ptr("Offer display name"),
	// 				OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 				Plans: []*armmarketplace.PlanRequesterDetails{
	// 					{
	// 						PlanDisplayName: to.Ptr("Plan display name A"),
	// 						PlanID: to.Ptr("testA"),
	// 						Requesters: []*armmarketplace.UserRequestDetails{
	// 							{
	// 								Date: to.Ptr("2021-02-01T11:42:12.9526511+02:00"),
	// 								Justification: to.Ptr("Because I want to...."),
	// 								SubscriptionID: to.Ptr("404a1952-706a-453a-989b-647cc4ca5f9c"),
	// 								SubscriptionName: to.Ptr("Test subscription"),
	// 								User: to.Ptr("testUser3"),
	// 						}},
	// 					},
	// 					{
	// 						PlanDisplayName: to.Ptr("*  (this means the user requested any plan, here you will get only *)"),
	// 						PlanID: to.Ptr("*"),
	// 						Requesters: []*armmarketplace.UserRequestDetails{
	// 							{
	// 								Date: to.Ptr("2021-02-01T11:42:12.9526511+02:00"),
	// 								Justification: to.Ptr("try me :)"),
	// 								SubscriptionID: to.Ptr("4ca4753c-5a1e-4913-b849-2c68880e03c2"),
	// 								SubscriptionName: to.Ptr("Test subscription 2"),
	// 								User: to.Ptr("testUser3"),
	// 						}},
	// 				}},
	// 				PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/GetAdminRequestApproval.json
func ExamplePrivateStoreClient_GetAdminRequestApproval() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().GetAdminRequestApproval(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", "marketplacetestthirdparty", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdminRequestApprovalsResource = armmarketplace.AdminRequestApprovalsResource{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("/providers/Microsoft.Marketplace/privateStores/adminRequestApprovals"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/adminRequestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@somedoamin.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-01T08:23:17.657Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@somedoamin.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.AdminRequestApprovalProperties{
	// 		AdminAction: to.Ptr(armmarketplace.AdminAction("Pending")),
	// 		CollectionIDs: []*string{
	// 		},
	// 		DisplayName: to.Ptr("Offer display name"),
	// 		OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 		Plans: []*armmarketplace.PlanRequesterDetails{
	// 			{
	// 				PlanDisplayName: to.Ptr("Plan display name A"),
	// 				PlanID: to.Ptr("testA"),
	// 				Requesters: []*armmarketplace.UserRequestDetails{
	// 					{
	// 						Date: to.Ptr("2021-02-01T11:42:12.9526511+02:00"),
	// 						Justification: to.Ptr("Because I want to...."),
	// 						SubscriptionID: to.Ptr("1fs4r5t6-5a1e-4913-b849-2c68880e03c2"),
	// 						SubscriptionName: to.Ptr("Test subscription 1"),
	// 						User: to.Ptr("testUser3"),
	// 				}},
	// 			},
	// 			{
	// 				PlanDisplayName: to.Ptr("*  (this means the user requested any plan, here you will get only *)"),
	// 				PlanID: to.Ptr("*"),
	// 				Requesters: []*armmarketplace.UserRequestDetails{
	// 					{
	// 						Date: to.Ptr("2021-02-01T11:42:12.9526511+02:00"),
	// 						Justification: to.Ptr("try me :)"),
	// 						SubscriptionID: to.Ptr("4ca4753c-5a1e-4913-b849-2c68880e03c2"),
	// 						SubscriptionName: to.Ptr("Test subscription 2"),
	// 						User: to.Ptr("testUser3"),
	// 				}},
	// 		}},
	// 		PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/UpdateAdminRequestApproval.json
func ExamplePrivateStoreClient_UpdateAdminRequestApproval() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().UpdateAdminRequestApproval(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", &armmarketplace.PrivateStoreClientUpdateAdminRequestApprovalOptions{Payload: &armmarketplace.AdminRequestApprovalsResource{
		Properties: &armmarketplace.AdminRequestApprovalProperties{
			AdminAction: to.Ptr(armmarketplace.AdminActionApproved),
			ApprovedPlans: []*string{
				to.Ptr("testPlan")},
			CollectionIDs: []*string{
				to.Ptr("f8ee227e-85d7-477d-abbf-854d6decaf70"),
				to.Ptr("39246ad6-c521-4fed-8de7-77dede2e873f")},
			Comment:     to.Ptr("I'm ok with that"),
			PublisherID: to.Ptr("marketplacetestthirdparty"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AdminRequestApprovalsResource = armmarketplace.AdminRequestApprovalsResource{
	// 	Name: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 	Type: to.Ptr("/providers/Microsoft.Marketplace/privateStores/adminRequestApprovals"),
	// 	ID: to.Ptr("/providers/Microsoft.Marketplace/privateStores/a0e28e55-90c4-41d8-8e34-bb7ef7775406/adminRequestApprovals/marketplacetestthirdparty.md-test-third-party-2"),
	// 	SystemData: &armmarketplace.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T17:18:19.123Z"); return t}()),
	// 		CreatedBy: to.Ptr("test@somedomain.com"),
	// 		CreatedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-10-05T17:18:19.123Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser@somedomail.com"),
	// 		LastModifiedByType: to.Ptr(armmarketplace.IdentityTypeUser),
	// 	},
	// 	Properties: &armmarketplace.AdminRequestApprovalProperties{
	// 		AdminAction: to.Ptr(armmarketplace.AdminActionApproved),
	// 		Administrator: to.Ptr("admin@someDomain.com"),
	// 		ApprovedPlans: []*string{
	// 			to.Ptr("testPlan")},
	// 			CollectionIDs: []*string{
	// 				to.Ptr("f8ee227e-85d7-477d-abbf-854d6decaf70"),
	// 				to.Ptr("39246ad6-c521-4fed-8de7-77dede2e873f")},
	// 				Comment: to.Ptr("I'm ok with that"),
	// 				DisplayName: to.Ptr("Offer display name"),
	// 				OfferID: to.Ptr("marketplacetestthirdparty.md-test-third-party-2"),
	// 				PublisherID: to.Ptr("marketplacetestthirdparty"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/NotificationsState.json
func ExamplePrivateStoreClient_QueryNotificationsState() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().QueryNotificationsState(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateStoreNotificationsState = armmarketplace.PrivateStoreNotificationsState{
	// 	ApprovalRequests: []*armmarketplace.RequestApprovalsDetails{
	// 		{
	// 			DisplayName: to.Ptr("Offer display name"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-09876567894321"),
	// 			MessageCode: to.Ptr[int64](0),
	// 			OfferID: to.Ptr("publisherId.legacyId"),
	// 			Plans: []*armmarketplace.PlanNotificationDetails{
	// 				{
	// 					PlanDisplayName: to.Ptr("Plan Test display name"),
	// 					PlanID: to.Ptr("test-plan"),
	// 				},
	// 				{
	// 					PlanDisplayName: to.Ptr("Plan Test display name B"),
	// 					PlanID: to.Ptr("test-planB"),
	// 			}},
	// 			PublisherID: to.Ptr("publisherId"),
	// 	}},
	// 	NewNotifications: []*armmarketplace.NewNotifications{
	// 		{
	// 			DisplayName: to.Ptr("Offer display name C"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-76545678"),
	// 			IsFuturePlansEnabled: to.Ptr(false),
	// 			MessageCode: to.Ptr[int64](10000),
	// 			OfferID: to.Ptr("publisherIdC.legacyIdC"),
	// 			Plans: []*armmarketplace.PlanNotificationDetails{
	// 				{
	// 					PlanDisplayName: to.Ptr("Display Name Test"),
	// 					PlanID: to.Ptr("plan-test"),
	// 			}},
	// 	}},
	// 	StopSellNotifications: []*armmarketplace.StopSellNotifications{
	// 		{
	// 			DisplayName: to.Ptr("Offer display name"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-4321"),
	// 			IsEntire: to.Ptr(false),
	// 			MessageCode: to.Ptr[int64](10002),
	// 			OfferID: to.Ptr("publisherId.legacyId"),
	// 			Plans: []*armmarketplace.PlanNotificationDetails{
	// 				{
	// 					PlanDisplayName: to.Ptr("test123"),
	// 					PlanID: to.Ptr("aaa"),
	// 			}},
	// 		},
	// 		{
	// 			DisplayName: to.Ptr("Offer display name B"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-7654"),
	// 			IsEntire: to.Ptr(true),
	// 			MessageCode: to.Ptr[int64](10003),
	// 			OfferID: to.Ptr("publisherIdB.legacyIdB"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/AcknowledgeNotification.json
func ExamplePrivateStoreClient_AcknowledgeOfferNotification() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreClient().AcknowledgeOfferNotification(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", &armmarketplace.PrivateStoreClientAcknowledgeOfferNotificationOptions{Payload: &armmarketplace.AcknowledgeOfferNotificationProperties{
		Properties: &armmarketplace.AcknowledgeOfferNotificationDetails{
			Acknowledge: to.Ptr(false),
			Dismiss:     to.Ptr(false),
			RemoveOffer: to.Ptr(false),
			RemovePlans: []*string{
				to.Ptr("testPlanA")},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/WithdrawPlan.json
func ExamplePrivateStoreClient_WithdrawPlan() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPrivateStoreClient().WithdrawPlan(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", "marketplacetestthirdparty.md-test-third-party-2", &armmarketplace.PrivateStoreClientWithdrawPlanOptions{Payload: &armmarketplace.WithdrawProperties{
		Properties: &armmarketplace.WithdrawDetails{
			PlanID:      to.Ptr("*"),
			PublisherID: to.Ptr("marketplacetestthirdparty"),
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/FetchAllSubscriptionsInTenant.json
func ExamplePrivateStoreClient_FetchAllSubscriptionsInTenant() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().FetchAllSubscriptionsInTenant(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientFetchAllSubscriptionsInTenantOptions{NextPageToken: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionsResponse = armmarketplace.SubscriptionsResponse{
	// 	Count: to.Ptr[int64](1),
	// 	Value: []*armmarketplace.Subscription{
	// 		{
	// 			DisplayName: to.Ptr("Test subscription"),
	// 			ID: to.Ptr("/subscriptions/090dcec8-3415-4e13-9377-07f489cdfeed"),
	// 			State: to.Ptr(armmarketplace.SubscriptionStateEnabled),
	// 			SubscriptionID: to.Ptr("090dcec8-3415-4e13-9377-07f489cdfeed"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/ListNewPlansNotifications.json
func ExamplePrivateStoreClient_ListNewPlansNotifications() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().ListNewPlansNotifications(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NewPlansNotificationsList = armmarketplace.NewPlansNotificationsList{
	// 	NewPlansNotifications: []*armmarketplace.NewNotifications{
	// 		{
	// 			DisplayName: to.Ptr("Offer display name C"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-76545678"),
	// 			IsFuturePlansEnabled: to.Ptr(false),
	// 			MessageCode: to.Ptr[int64](10000),
	// 			OfferID: to.Ptr("publisherIdC.legacyIdC"),
	// 			Plans: []*armmarketplace.PlanNotificationDetails{
	// 				{
	// 					PlanDisplayName: to.Ptr("Display Name Test"),
	// 					PlanID: to.Ptr("plan-test"),
	// 			}},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/ListStopSellOffersPlansNotifications.json
func ExamplePrivateStoreClient_ListStopSellOffersPlansNotifications() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().ListStopSellOffersPlansNotifications(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", &armmarketplace.PrivateStoreClientListStopSellOffersPlansNotificationsOptions{StopSellSubscriptions: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.StopSellOffersPlansNotificationsList = armmarketplace.StopSellOffersPlansNotificationsList{
	// 	StopSellNotifications: []*armmarketplace.StopSellOffersPlansNotificationsListProperties{
	// 		{
	// 			DisplayName: to.Ptr("Offer display name"),
	// 			Icon: to.Ptr("https://some-images.someDomail.com/image/apps.12345678-4321"),
	// 			IsEntire: to.Ptr(false),
	// 			MessageCode: to.Ptr[int64](10002),
	// 			OfferID: to.Ptr("publisherId.legacyId"),
	// 			Plans: []*armmarketplace.PlanNotificationDetails{
	// 				{
	// 					PlanDisplayName: to.Ptr("test123"),
	// 					PlanID: to.Ptr("aaa"),
	// 			}},
	// 			PublicContext: to.Ptr(false),
	// 			SubscriptionsIDs: []*string{
	// 				to.Ptr("090dcec8-3415-4e13-9377-07f489cdfeed")},
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/marketplace/resource-manager/Microsoft.Marketplace/stable/2021-12-01/examples/ListSubscriptionsContext.json
func ExamplePrivateStoreClient_ListSubscriptionsContext() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmarketplace.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPrivateStoreClient().ListSubscriptionsContext(ctx, "a0e28e55-90c4-41d8-8e34-bb7ef7775406", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SubscriptionsContextList = armmarketplace.SubscriptionsContextList{
	// 	SubscriptionsIDs: []*string{
	// 		to.Ptr("090dcec8-3415-4e13-9377-07f489cdfeed"),
	// 		to.Ptr("030dcec2-4323-5e13-9376-96f489cdfeed")},
	// 	}
}
