//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// EmailRegistrationsClient contains the methods for the EmailRegistrations group.
// Don't use this type directly, use NewEmailRegistrationsClient() instead.
type EmailRegistrationsClient struct {
	internal *arm.Client
}

// NewEmailRegistrationsClient creates a new instance of EmailRegistrationsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewEmailRegistrationsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*EmailRegistrationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &EmailRegistrationsClient{
		internal: cl,
	}
	return client, nil
}

// ActivateEmail - Activate the email registration for the current tenant
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - location - Location of the activation.
//   - emailRegistration - The payload for tenant domain activation.
//   - options - EmailRegistrationsClientActivateEmailOptions contains the optional parameters for the EmailRegistrationsClient.ActivateEmail
//     method.
func (client *EmailRegistrationsClient) ActivateEmail(ctx context.Context, location string, emailRegistration EmailRegistration, options *EmailRegistrationsClientActivateEmailOptions) (EmailRegistrationsClientActivateEmailResponse, error) {
	var err error
	const operationName = "EmailRegistrationsClient.ActivateEmail"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.activateEmailCreateRequest(ctx, location, emailRegistration, options)
	if err != nil {
		return EmailRegistrationsClientActivateEmailResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EmailRegistrationsClientActivateEmailResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EmailRegistrationsClientActivateEmailResponse{}, err
	}
	resp, err := client.activateEmailHandleResponse(httpResp)
	return resp, err
}

// activateEmailCreateRequest creates the ActivateEmail request.
func (client *EmailRegistrationsClient) activateEmailCreateRequest(ctx context.Context, location string, emailRegistration EmailRegistration, options *EmailRegistrationsClientActivateEmailOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.DataShare/locations/{location}/activateEmail"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, emailRegistration); err != nil {
		return nil, err
	}
	return req, nil
}

// activateEmailHandleResponse handles the ActivateEmail response.
func (client *EmailRegistrationsClient) activateEmailHandleResponse(resp *http.Response) (EmailRegistrationsClientActivateEmailResponse, error) {
	result := EmailRegistrationsClientActivateEmailResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EmailRegistration); err != nil {
		return EmailRegistrationsClientActivateEmailResponse{}, err
	}
	return result, nil
}

// RegisterEmail - Register an email for the current tenant
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-09-01
//   - location - Location of the registration
//   - options - EmailRegistrationsClientRegisterEmailOptions contains the optional parameters for the EmailRegistrationsClient.RegisterEmail
//     method.
func (client *EmailRegistrationsClient) RegisterEmail(ctx context.Context, location string, options *EmailRegistrationsClientRegisterEmailOptions) (EmailRegistrationsClientRegisterEmailResponse, error) {
	var err error
	const operationName = "EmailRegistrationsClient.RegisterEmail"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.registerEmailCreateRequest(ctx, location, options)
	if err != nil {
		return EmailRegistrationsClientRegisterEmailResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EmailRegistrationsClientRegisterEmailResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EmailRegistrationsClientRegisterEmailResponse{}, err
	}
	resp, err := client.registerEmailHandleResponse(httpResp)
	return resp, err
}

// registerEmailCreateRequest creates the RegisterEmail request.
func (client *EmailRegistrationsClient) registerEmailCreateRequest(ctx context.Context, location string, options *EmailRegistrationsClientRegisterEmailOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.DataShare/locations/{location}/registerEmail"
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// registerEmailHandleResponse handles the RegisterEmail response.
func (client *EmailRegistrationsClient) registerEmailHandleResponse(resp *http.Response) (EmailRegistrationsClientRegisterEmailResponse, error) {
	result := EmailRegistrationsClientRegisterEmailResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EmailRegistration); err != nil {
		return EmailRegistrationsClientRegisterEmailResponse{}, err
	}
	return result, nil
}
