//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataboxedge

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/databoxedge/armdataboxedge"
	moduleVersion = "v1.2.0"
)

// AccessLevel - Access level allowed for this remote application type
type AccessLevel string

const (
	AccessLevelFullAccess AccessLevel = "FullAccess"
	AccessLevelNone       AccessLevel = "None"
	AccessLevelReadOnly   AccessLevel = "ReadOnly"
	AccessLevelReadWrite  AccessLevel = "ReadWrite"
)

// PossibleAccessLevelValues returns the possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{
		AccessLevelFullAccess,
		AccessLevelNone,
		AccessLevelReadOnly,
		AccessLevelReadWrite,
	}
}

// AccountType - Type of storage accessed on the storage account.
type AccountType string

const (
	AccountTypeBlobStorage           AccountType = "BlobStorage"
	AccountTypeGeneralPurposeStorage AccountType = "GeneralPurposeStorage"
)

// PossibleAccountTypeValues returns the possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{
		AccountTypeBlobStorage,
		AccountTypeGeneralPurposeStorage,
	}
}

// AddonState - Addon Provisioning State
type AddonState string

const (
	AddonStateCreated       AddonState = "Created"
	AddonStateCreating      AddonState = "Creating"
	AddonStateDeleting      AddonState = "Deleting"
	AddonStateFailed        AddonState = "Failed"
	AddonStateInvalid       AddonState = "Invalid"
	AddonStateReconfiguring AddonState = "Reconfiguring"
	AddonStateUpdating      AddonState = "Updating"
)

// PossibleAddonStateValues returns the possible values for the AddonState const type.
func PossibleAddonStateValues() []AddonState {
	return []AddonState{
		AddonStateCreated,
		AddonStateCreating,
		AddonStateDeleting,
		AddonStateFailed,
		AddonStateInvalid,
		AddonStateReconfiguring,
		AddonStateUpdating,
	}
}

// AddonType - Addon type.
type AddonType string

const (
	AddonTypeArcForKubernetes AddonType = "ArcForKubernetes"
	AddonTypeIotEdge          AddonType = "IotEdge"
)

// PossibleAddonTypeValues returns the possible values for the AddonType const type.
func PossibleAddonTypeValues() []AddonType {
	return []AddonType{
		AddonTypeArcForKubernetes,
		AddonTypeIotEdge,
	}
}

// AlertSeverity - Severity of the alert.
type AlertSeverity string

const (
	AlertSeverityCritical      AlertSeverity = "Critical"
	AlertSeverityInformational AlertSeverity = "Informational"
	AlertSeverityWarning       AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityCritical,
		AlertSeverityInformational,
		AlertSeverityWarning,
	}
}

// AuthenticationType - The authentication type.
type AuthenticationType string

const (
	AuthenticationTypeAzureActiveDirectory AuthenticationType = "AzureActiveDirectory"
	AuthenticationTypeInvalid              AuthenticationType = "Invalid"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeAzureActiveDirectory,
		AuthenticationTypeInvalid,
	}
}

// AzureContainerDataFormat - Storage format used for the file represented by the share.
type AzureContainerDataFormat string

const (
	AzureContainerDataFormatAzureFile AzureContainerDataFormat = "AzureFile"
	AzureContainerDataFormatBlockBlob AzureContainerDataFormat = "BlockBlob"
	AzureContainerDataFormatPageBlob  AzureContainerDataFormat = "PageBlob"
)

// PossibleAzureContainerDataFormatValues returns the possible values for the AzureContainerDataFormat const type.
func PossibleAzureContainerDataFormatValues() []AzureContainerDataFormat {
	return []AzureContainerDataFormat{
		AzureContainerDataFormatAzureFile,
		AzureContainerDataFormatBlockBlob,
		AzureContainerDataFormatPageBlob,
	}
}

// ClientPermissionType - Type of access to be allowed for the client.
type ClientPermissionType string

const (
	ClientPermissionTypeNoAccess  ClientPermissionType = "NoAccess"
	ClientPermissionTypeReadOnly  ClientPermissionType = "ReadOnly"
	ClientPermissionTypeReadWrite ClientPermissionType = "ReadWrite"
)

// PossibleClientPermissionTypeValues returns the possible values for the ClientPermissionType const type.
func PossibleClientPermissionTypeValues() []ClientPermissionType {
	return []ClientPermissionType{
		ClientPermissionTypeNoAccess,
		ClientPermissionTypeReadOnly,
		ClientPermissionTypeReadWrite,
	}
}

// ClusterWitnessType - Cluster Witness Type
type ClusterWitnessType string

const (
	ClusterWitnessTypeCloud     ClusterWitnessType = "Cloud"
	ClusterWitnessTypeFileShare ClusterWitnessType = "FileShare"
	ClusterWitnessTypeNone      ClusterWitnessType = "None"
)

// PossibleClusterWitnessTypeValues returns the possible values for the ClusterWitnessType const type.
func PossibleClusterWitnessTypeValues() []ClusterWitnessType {
	return []ClusterWitnessType{
		ClusterWitnessTypeCloud,
		ClusterWitnessTypeFileShare,
		ClusterWitnessTypeNone,
	}
}

// ContainerStatus - Current status of the container.
type ContainerStatus string

const (
	ContainerStatusNeedsAttention ContainerStatus = "NeedsAttention"
	ContainerStatusOK             ContainerStatus = "OK"
	ContainerStatusOffline        ContainerStatus = "Offline"
	ContainerStatusUnknown        ContainerStatus = "Unknown"
	ContainerStatusUpdating       ContainerStatus = "Updating"
)

// PossibleContainerStatusValues returns the possible values for the ContainerStatus const type.
func PossibleContainerStatusValues() []ContainerStatus {
	return []ContainerStatus{
		ContainerStatusNeedsAttention,
		ContainerStatusOK,
		ContainerStatusOffline,
		ContainerStatusUnknown,
		ContainerStatusUpdating,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataBoxEdgeDeviceKind - The kind of the device.
type DataBoxEdgeDeviceKind string

const (
	DataBoxEdgeDeviceKindAzureDataBoxGateway    DataBoxEdgeDeviceKind = "AzureDataBoxGateway"
	DataBoxEdgeDeviceKindAzureModularDataCentre DataBoxEdgeDeviceKind = "AzureModularDataCentre"
	DataBoxEdgeDeviceKindAzureStackEdge         DataBoxEdgeDeviceKind = "AzureStackEdge"
	DataBoxEdgeDeviceKindAzureStackHub          DataBoxEdgeDeviceKind = "AzureStackHub"
)

// PossibleDataBoxEdgeDeviceKindValues returns the possible values for the DataBoxEdgeDeviceKind const type.
func PossibleDataBoxEdgeDeviceKindValues() []DataBoxEdgeDeviceKind {
	return []DataBoxEdgeDeviceKind{
		DataBoxEdgeDeviceKindAzureDataBoxGateway,
		DataBoxEdgeDeviceKindAzureModularDataCentre,
		DataBoxEdgeDeviceKindAzureStackEdge,
		DataBoxEdgeDeviceKindAzureStackHub,
	}
}

// DataBoxEdgeDeviceStatus - The status of the Data Box Edge/Gateway device.
type DataBoxEdgeDeviceStatus string

const (
	DataBoxEdgeDeviceStatusDisconnected          DataBoxEdgeDeviceStatus = "Disconnected"
	DataBoxEdgeDeviceStatusMaintenance           DataBoxEdgeDeviceStatus = "Maintenance"
	DataBoxEdgeDeviceStatusNeedsAttention        DataBoxEdgeDeviceStatus = "NeedsAttention"
	DataBoxEdgeDeviceStatusOffline               DataBoxEdgeDeviceStatus = "Offline"
	DataBoxEdgeDeviceStatusOnline                DataBoxEdgeDeviceStatus = "Online"
	DataBoxEdgeDeviceStatusPartiallyDisconnected DataBoxEdgeDeviceStatus = "PartiallyDisconnected"
	DataBoxEdgeDeviceStatusReadyToSetup          DataBoxEdgeDeviceStatus = "ReadyToSetup"
)

// PossibleDataBoxEdgeDeviceStatusValues returns the possible values for the DataBoxEdgeDeviceStatus const type.
func PossibleDataBoxEdgeDeviceStatusValues() []DataBoxEdgeDeviceStatus {
	return []DataBoxEdgeDeviceStatus{
		DataBoxEdgeDeviceStatusDisconnected,
		DataBoxEdgeDeviceStatusMaintenance,
		DataBoxEdgeDeviceStatusNeedsAttention,
		DataBoxEdgeDeviceStatusOffline,
		DataBoxEdgeDeviceStatusOnline,
		DataBoxEdgeDeviceStatusPartiallyDisconnected,
		DataBoxEdgeDeviceStatusReadyToSetup,
	}
}

// DataPolicy - Data policy of the share.
type DataPolicy string

const (
	DataPolicyCloud DataPolicy = "Cloud"
	DataPolicyLocal DataPolicy = "Local"
)

// PossibleDataPolicyValues returns the possible values for the DataPolicy const type.
func PossibleDataPolicyValues() []DataPolicy {
	return []DataPolicy{
		DataPolicyCloud,
		DataPolicyLocal,
	}
}

// DataResidencyType - DataResidencyType enum
type DataResidencyType string

const (
	DataResidencyTypeGeoZoneReplication DataResidencyType = "GeoZoneReplication"
	DataResidencyTypeZoneReplication    DataResidencyType = "ZoneReplication"
)

// PossibleDataResidencyTypeValues returns the possible values for the DataResidencyType const type.
func PossibleDataResidencyTypeValues() []DataResidencyType {
	return []DataResidencyType{
		DataResidencyTypeGeoZoneReplication,
		DataResidencyTypeZoneReplication,
	}
}

type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

// DeviceType - The type of the Data Box Edge/Gateway device.
type DeviceType string

const (
	DeviceTypeDataBoxEdgeDevice DeviceType = "DataBoxEdgeDevice"
)

// PossibleDeviceTypeValues returns the possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{
		DeviceTypeDataBoxEdgeDevice,
	}
}

// DownloadPhase - The download phase.
type DownloadPhase string

const (
	DownloadPhaseDownloading  DownloadPhase = "Downloading"
	DownloadPhaseInitializing DownloadPhase = "Initializing"
	DownloadPhaseUnknown      DownloadPhase = "Unknown"
	DownloadPhaseVerifying    DownloadPhase = "Verifying"
)

// PossibleDownloadPhaseValues returns the possible values for the DownloadPhase const type.
func PossibleDownloadPhaseValues() []DownloadPhase {
	return []DownloadPhase{
		DownloadPhaseDownloading,
		DownloadPhaseInitializing,
		DownloadPhaseUnknown,
		DownloadPhaseVerifying,
	}
}

// EncryptionAlgorithm - The algorithm used to encrypt "Value".
type EncryptionAlgorithm string

const (
	EncryptionAlgorithmAES256        EncryptionAlgorithm = "AES256"
	EncryptionAlgorithmNone          EncryptionAlgorithm = "None"
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns the possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{
		EncryptionAlgorithmAES256,
		EncryptionAlgorithmNone,
		EncryptionAlgorithmRSAESPKCS1V15,
	}
}

// HostPlatformType - Platform where the runtime is hosted.
type HostPlatformType string

const (
	HostPlatformTypeKubernetesCluster HostPlatformType = "KubernetesCluster"
	HostPlatformTypeLinuxVM           HostPlatformType = "LinuxVM"
)

// PossibleHostPlatformTypeValues returns the possible values for the HostPlatformType const type.
func PossibleHostPlatformTypeValues() []HostPlatformType {
	return []HostPlatformType{
		HostPlatformTypeKubernetesCluster,
		HostPlatformTypeLinuxVM,
	}
}

// InstallRebootBehavior - Indicates if updates are available and at least one of the updates needs a reboot.
type InstallRebootBehavior string

const (
	InstallRebootBehaviorNeverReboots   InstallRebootBehavior = "NeverReboots"
	InstallRebootBehaviorRequestReboot  InstallRebootBehavior = "RequestReboot"
	InstallRebootBehaviorRequiresReboot InstallRebootBehavior = "RequiresReboot"
)

// PossibleInstallRebootBehaviorValues returns the possible values for the InstallRebootBehavior const type.
func PossibleInstallRebootBehaviorValues() []InstallRebootBehavior {
	return []InstallRebootBehavior{
		InstallRebootBehaviorNeverReboots,
		InstallRebootBehaviorRequestReboot,
		InstallRebootBehaviorRequiresReboot,
	}
}

// InstallationImpact - Impact of Installing an updateType
type InstallationImpact string

const (
	InstallationImpactDeviceRebooted          InstallationImpact = "DeviceRebooted"
	InstallationImpactKubernetesWorkloadsDown InstallationImpact = "KubernetesWorkloadsDown"
	InstallationImpactNone                    InstallationImpact = "None"
)

// PossibleInstallationImpactValues returns the possible values for the InstallationImpact const type.
func PossibleInstallationImpactValues() []InstallationImpact {
	return []InstallationImpact{
		InstallationImpactDeviceRebooted,
		InstallationImpactKubernetesWorkloadsDown,
		InstallationImpactNone,
	}
}

// JobStatus - The current status of the job.
type JobStatus string

const (
	JobStatusCanceled  JobStatus = "Canceled"
	JobStatusFailed    JobStatus = "Failed"
	JobStatusInvalid   JobStatus = "Invalid"
	JobStatusPaused    JobStatus = "Paused"
	JobStatusRunning   JobStatus = "Running"
	JobStatusScheduled JobStatus = "Scheduled"
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCanceled,
		JobStatusFailed,
		JobStatusInvalid,
		JobStatusPaused,
		JobStatusRunning,
		JobStatusScheduled,
		JobStatusSucceeded,
	}
}

// JobType - The type of the job.
type JobType string

const (
	JobTypeBackup                JobType = "Backup"
	JobTypeDownloadUpdates       JobType = "DownloadUpdates"
	JobTypeInstallUpdates        JobType = "InstallUpdates"
	JobTypeInvalid               JobType = "Invalid"
	JobTypeRefreshContainer      JobType = "RefreshContainer"
	JobTypeRefreshShare          JobType = "RefreshShare"
	JobTypeRestore               JobType = "Restore"
	JobTypeScanForUpdates        JobType = "ScanForUpdates"
	JobTypeTriggerSupportPackage JobType = "TriggerSupportPackage"
)

// PossibleJobTypeValues returns the possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{
		JobTypeBackup,
		JobTypeDownloadUpdates,
		JobTypeInstallUpdates,
		JobTypeInvalid,
		JobTypeRefreshContainer,
		JobTypeRefreshShare,
		JobTypeRestore,
		JobTypeScanForUpdates,
		JobTypeTriggerSupportPackage,
	}
}

// KeyVaultSyncStatus - For changing or to initiate the resync to key-vault set the status to KeyVaultSyncPending, rest of
// the status will not be applicable.
type KeyVaultSyncStatus string

const (
	KeyVaultSyncStatusKeyVaultNotConfigured KeyVaultSyncStatus = "KeyVaultNotConfigured"
	KeyVaultSyncStatusKeyVaultNotSynced     KeyVaultSyncStatus = "KeyVaultNotSynced"
	KeyVaultSyncStatusKeyVaultSyncFailed    KeyVaultSyncStatus = "KeyVaultSyncFailed"
	KeyVaultSyncStatusKeyVaultSyncPending   KeyVaultSyncStatus = "KeyVaultSyncPending"
	KeyVaultSyncStatusKeyVaultSynced        KeyVaultSyncStatus = "KeyVaultSynced"
	KeyVaultSyncStatusKeyVaultSyncing       KeyVaultSyncStatus = "KeyVaultSyncing"
)

// PossibleKeyVaultSyncStatusValues returns the possible values for the KeyVaultSyncStatus const type.
func PossibleKeyVaultSyncStatusValues() []KeyVaultSyncStatus {
	return []KeyVaultSyncStatus{
		KeyVaultSyncStatusKeyVaultNotConfigured,
		KeyVaultSyncStatusKeyVaultNotSynced,
		KeyVaultSyncStatusKeyVaultSyncFailed,
		KeyVaultSyncStatusKeyVaultSyncPending,
		KeyVaultSyncStatusKeyVaultSynced,
		KeyVaultSyncStatusKeyVaultSyncing,
	}
}

// KubernetesNodeType - Node type - Master/Worker
type KubernetesNodeType string

const (
	KubernetesNodeTypeInvalid KubernetesNodeType = "Invalid"
	KubernetesNodeTypeMaster  KubernetesNodeType = "Master"
	KubernetesNodeTypeWorker  KubernetesNodeType = "Worker"
)

// PossibleKubernetesNodeTypeValues returns the possible values for the KubernetesNodeType const type.
func PossibleKubernetesNodeTypeValues() []KubernetesNodeType {
	return []KubernetesNodeType{
		KubernetesNodeTypeInvalid,
		KubernetesNodeTypeMaster,
		KubernetesNodeTypeWorker,
	}
}

// KubernetesState - State of Kubernetes deployment
type KubernetesState string

const (
	KubernetesStateCreated       KubernetesState = "Created"
	KubernetesStateCreating      KubernetesState = "Creating"
	KubernetesStateDeleting      KubernetesState = "Deleting"
	KubernetesStateFailed        KubernetesState = "Failed"
	KubernetesStateInvalid       KubernetesState = "Invalid"
	KubernetesStateReconfiguring KubernetesState = "Reconfiguring"
	KubernetesStateUpdating      KubernetesState = "Updating"
)

// PossibleKubernetesStateValues returns the possible values for the KubernetesState const type.
func PossibleKubernetesStateValues() []KubernetesState {
	return []KubernetesState{
		KubernetesStateCreated,
		KubernetesStateCreating,
		KubernetesStateDeleting,
		KubernetesStateFailed,
		KubernetesStateInvalid,
		KubernetesStateReconfiguring,
		KubernetesStateUpdating,
	}
}

// MetricAggregationType - Metric aggregation type.
type MetricAggregationType string

const (
	MetricAggregationTypeAverage      MetricAggregationType = "Average"
	MetricAggregationTypeCount        MetricAggregationType = "Count"
	MetricAggregationTypeMaximum      MetricAggregationType = "Maximum"
	MetricAggregationTypeMinimum      MetricAggregationType = "Minimum"
	MetricAggregationTypeNone         MetricAggregationType = "None"
	MetricAggregationTypeNotSpecified MetricAggregationType = "NotSpecified"
	MetricAggregationTypeTotal        MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns the possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{
		MetricAggregationTypeAverage,
		MetricAggregationTypeCount,
		MetricAggregationTypeMaximum,
		MetricAggregationTypeMinimum,
		MetricAggregationTypeNone,
		MetricAggregationTypeNotSpecified,
		MetricAggregationTypeTotal,
	}
}

// MetricCategory - Metric category.
type MetricCategory string

const (
	MetricCategoryCapacity    MetricCategory = "Capacity"
	MetricCategoryTransaction MetricCategory = "Transaction"
)

// PossibleMetricCategoryValues returns the possible values for the MetricCategory const type.
func PossibleMetricCategoryValues() []MetricCategory {
	return []MetricCategory{
		MetricCategoryCapacity,
		MetricCategoryTransaction,
	}
}

// MetricUnit - Metric units.
type MetricUnit string

const (
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitMilliseconds   MetricUnit = "Milliseconds"
	MetricUnitNotSpecified   MetricUnit = "NotSpecified"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitMilliseconds,
		MetricUnitNotSpecified,
		MetricUnitPercent,
		MetricUnitSeconds,
	}
}

// MonitoringStatus - Current monitoring status of the share.
type MonitoringStatus string

const (
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	MonitoringStatusEnabled  MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns the possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{
		MonitoringStatusDisabled,
		MonitoringStatusEnabled,
	}
}

// MountType - Mounting type.
type MountType string

const (
	MountTypeHostPath MountType = "HostPath"
	MountTypeVolume   MountType = "Volume"
)

// PossibleMountTypeValues returns the possible values for the MountType const type.
func PossibleMountTypeValues() []MountType {
	return []MountType{
		MountTypeHostPath,
		MountTypeVolume,
	}
}

// MsiIdentityType - Identity type
type MsiIdentityType string

const (
	MsiIdentityTypeNone           MsiIdentityType = "None"
	MsiIdentityTypeSystemAssigned MsiIdentityType = "SystemAssigned"
	MsiIdentityTypeUserAssigned   MsiIdentityType = "UserAssigned"
)

// PossibleMsiIdentityTypeValues returns the possible values for the MsiIdentityType const type.
func PossibleMsiIdentityTypeValues() []MsiIdentityType {
	return []MsiIdentityType{
		MsiIdentityTypeNone,
		MsiIdentityTypeSystemAssigned,
		MsiIdentityTypeUserAssigned,
	}
}

// NetworkAdapterDHCPStatus - Value indicating whether this adapter has DHCP enabled.
type NetworkAdapterDHCPStatus string

const (
	NetworkAdapterDHCPStatusDisabled NetworkAdapterDHCPStatus = "Disabled"
	NetworkAdapterDHCPStatusEnabled  NetworkAdapterDHCPStatus = "Enabled"
)

// PossibleNetworkAdapterDHCPStatusValues returns the possible values for the NetworkAdapterDHCPStatus const type.
func PossibleNetworkAdapterDHCPStatusValues() []NetworkAdapterDHCPStatus {
	return []NetworkAdapterDHCPStatus{
		NetworkAdapterDHCPStatusDisabled,
		NetworkAdapterDHCPStatusEnabled,
	}
}

// NetworkAdapterRDMAStatus - Value indicating whether this adapter is RDMA capable.
type NetworkAdapterRDMAStatus string

const (
	NetworkAdapterRDMAStatusCapable   NetworkAdapterRDMAStatus = "Capable"
	NetworkAdapterRDMAStatusIncapable NetworkAdapterRDMAStatus = "Incapable"
)

// PossibleNetworkAdapterRDMAStatusValues returns the possible values for the NetworkAdapterRDMAStatus const type.
func PossibleNetworkAdapterRDMAStatusValues() []NetworkAdapterRDMAStatus {
	return []NetworkAdapterRDMAStatus{
		NetworkAdapterRDMAStatusCapable,
		NetworkAdapterRDMAStatusIncapable,
	}
}

// NetworkAdapterStatus - Value indicating whether this adapter is valid.
type NetworkAdapterStatus string

const (
	NetworkAdapterStatusActive   NetworkAdapterStatus = "Active"
	NetworkAdapterStatusInactive NetworkAdapterStatus = "Inactive"
)

// PossibleNetworkAdapterStatusValues returns the possible values for the NetworkAdapterStatus const type.
func PossibleNetworkAdapterStatusValues() []NetworkAdapterStatus {
	return []NetworkAdapterStatus{
		NetworkAdapterStatusActive,
		NetworkAdapterStatusInactive,
	}
}

// NetworkGroup - The network group.
type NetworkGroup string

const (
	NetworkGroupNonRDMA NetworkGroup = "NonRDMA"
	NetworkGroupNone    NetworkGroup = "None"
	NetworkGroupRDMA    NetworkGroup = "RDMA"
)

// PossibleNetworkGroupValues returns the possible values for the NetworkGroup const type.
func PossibleNetworkGroupValues() []NetworkGroup {
	return []NetworkGroup{
		NetworkGroupNonRDMA,
		NetworkGroupNone,
		NetworkGroupRDMA,
	}
}

// NodeStatus - The current status of the individual node
type NodeStatus string

const (
	NodeStatusDown         NodeStatus = "Down"
	NodeStatusRebooting    NodeStatus = "Rebooting"
	NodeStatusShuttingDown NodeStatus = "ShuttingDown"
	NodeStatusUnknown      NodeStatus = "Unknown"
	NodeStatusUp           NodeStatus = "Up"
)

// PossibleNodeStatusValues returns the possible values for the NodeStatus const type.
func PossibleNodeStatusValues() []NodeStatus {
	return []NodeStatus{
		NodeStatusDown,
		NodeStatusRebooting,
		NodeStatusShuttingDown,
		NodeStatusUnknown,
		NodeStatusUp,
	}
}

// OrderState - Status of the order as per the allowed status types.
type OrderState string

const (
	OrderStateArriving               OrderState = "Arriving"
	OrderStateAwaitingDrop           OrderState = "AwaitingDrop"
	OrderStateAwaitingFulfillment    OrderState = "AwaitingFulfillment"
	OrderStateAwaitingPickup         OrderState = "AwaitingPickup"
	OrderStateAwaitingPreparation    OrderState = "AwaitingPreparation"
	OrderStateAwaitingReturnShipment OrderState = "AwaitingReturnShipment"
	OrderStateAwaitingShipment       OrderState = "AwaitingShipment"
	OrderStateCollectedAtMicrosoft   OrderState = "CollectedAtMicrosoft"
	OrderStateDeclined               OrderState = "Declined"
	OrderStateDelivered              OrderState = "Delivered"
	OrderStateLostDevice             OrderState = "LostDevice"
	OrderStatePickupCompleted        OrderState = "PickupCompleted"
	OrderStateReplacementRequested   OrderState = "ReplacementRequested"
	OrderStateReturnInitiated        OrderState = "ReturnInitiated"
	OrderStateShipped                OrderState = "Shipped"
	OrderStateShippedBack            OrderState = "ShippedBack"
	OrderStateUntracked              OrderState = "Untracked"
)

// PossibleOrderStateValues returns the possible values for the OrderState const type.
func PossibleOrderStateValues() []OrderState {
	return []OrderState{
		OrderStateArriving,
		OrderStateAwaitingDrop,
		OrderStateAwaitingFulfillment,
		OrderStateAwaitingPickup,
		OrderStateAwaitingPreparation,
		OrderStateAwaitingReturnShipment,
		OrderStateAwaitingShipment,
		OrderStateCollectedAtMicrosoft,
		OrderStateDeclined,
		OrderStateDelivered,
		OrderStateLostDevice,
		OrderStatePickupCompleted,
		OrderStateReplacementRequested,
		OrderStateReturnInitiated,
		OrderStateShipped,
		OrderStateShippedBack,
		OrderStateUntracked,
	}
}

// PlatformType - Host OS supported by the Arc addon.
type PlatformType string

const (
	PlatformTypeLinux   PlatformType = "Linux"
	PlatformTypeWindows PlatformType = "Windows"
)

// PossiblePlatformTypeValues returns the possible values for the PlatformType const type.
func PossiblePlatformTypeValues() []PlatformType {
	return []PlatformType{
		PlatformTypeLinux,
		PlatformTypeWindows,
	}
}

// PosixComplianceStatus - If provisioned storage is posix compliant.
type PosixComplianceStatus string

const (
	PosixComplianceStatusDisabled PosixComplianceStatus = "Disabled"
	PosixComplianceStatusEnabled  PosixComplianceStatus = "Enabled"
	PosixComplianceStatusInvalid  PosixComplianceStatus = "Invalid"
)

// PossiblePosixComplianceStatusValues returns the possible values for the PosixComplianceStatus const type.
func PossiblePosixComplianceStatusValues() []PosixComplianceStatus {
	return []PosixComplianceStatus{
		PosixComplianceStatusDisabled,
		PosixComplianceStatusEnabled,
		PosixComplianceStatusInvalid,
	}
}

// ProactiveDiagnosticsConsent - Proactive diagnostic collection consent flag
type ProactiveDiagnosticsConsent string

const (
	ProactiveDiagnosticsConsentDisabled ProactiveDiagnosticsConsent = "Disabled"
	ProactiveDiagnosticsConsentEnabled  ProactiveDiagnosticsConsent = "Enabled"
)

// PossibleProactiveDiagnosticsConsentValues returns the possible values for the ProactiveDiagnosticsConsent const type.
func PossibleProactiveDiagnosticsConsentValues() []ProactiveDiagnosticsConsent {
	return []ProactiveDiagnosticsConsent{
		ProactiveDiagnosticsConsentDisabled,
		ProactiveDiagnosticsConsentEnabled,
	}
}

// RemoteApplicationType - Remote application type
type RemoteApplicationType string

const (
	RemoteApplicationTypeAllApplications RemoteApplicationType = "AllApplications"
	RemoteApplicationTypeLocalUI         RemoteApplicationType = "LocalUI"
	RemoteApplicationTypePowershell      RemoteApplicationType = "Powershell"
	RemoteApplicationTypeWAC             RemoteApplicationType = "WAC"
)

// PossibleRemoteApplicationTypeValues returns the possible values for the RemoteApplicationType const type.
func PossibleRemoteApplicationTypeValues() []RemoteApplicationType {
	return []RemoteApplicationType{
		RemoteApplicationTypeAllApplications,
		RemoteApplicationTypeLocalUI,
		RemoteApplicationTypePowershell,
		RemoteApplicationTypeWAC,
	}
}

// ResourceMoveStatus - Denotes whether move operation is in progress
type ResourceMoveStatus string

const (
	ResourceMoveStatusNone                   ResourceMoveStatus = "None"
	ResourceMoveStatusResourceMoveFailed     ResourceMoveStatus = "ResourceMoveFailed"
	ResourceMoveStatusResourceMoveInProgress ResourceMoveStatus = "ResourceMoveInProgress"
)

// PossibleResourceMoveStatusValues returns the possible values for the ResourceMoveStatus const type.
func PossibleResourceMoveStatusValues() []ResourceMoveStatus {
	return []ResourceMoveStatus{
		ResourceMoveStatusNone,
		ResourceMoveStatusResourceMoveFailed,
		ResourceMoveStatusResourceMoveInProgress,
	}
}

// RoleStatus - Local Edge Management Status
type RoleStatus string

const (
	RoleStatusDisabled RoleStatus = "Disabled"
	RoleStatusEnabled  RoleStatus = "Enabled"
)

// PossibleRoleStatusValues returns the possible values for the RoleStatus const type.
func PossibleRoleStatusValues() []RoleStatus {
	return []RoleStatus{
		RoleStatusDisabled,
		RoleStatusEnabled,
	}
}

type RoleTypes string

const (
	RoleTypesASA                 RoleTypes = "ASA"
	RoleTypesCloudEdgeManagement RoleTypes = "CloudEdgeManagement"
	RoleTypesCognitive           RoleTypes = "Cognitive"
	RoleTypesFunctions           RoleTypes = "Functions"
	RoleTypesIOT                 RoleTypes = "IOT"
	RoleTypesKubernetes          RoleTypes = "Kubernetes"
	RoleTypesMEC                 RoleTypes = "MEC"
)

// PossibleRoleTypesValues returns the possible values for the RoleTypes const type.
func PossibleRoleTypesValues() []RoleTypes {
	return []RoleTypes{
		RoleTypesASA,
		RoleTypesCloudEdgeManagement,
		RoleTypesCognitive,
		RoleTypesFunctions,
		RoleTypesIOT,
		RoleTypesKubernetes,
		RoleTypesMEC,
	}
}

// SKUAvailability - Links to the next set of results
type SKUAvailability string

const (
	SKUAvailabilityAvailable   SKUAvailability = "Available"
	SKUAvailabilityUnavailable SKUAvailability = "Unavailable"
)

// PossibleSKUAvailabilityValues returns the possible values for the SKUAvailability const type.
func PossibleSKUAvailabilityValues() []SKUAvailability {
	return []SKUAvailability{
		SKUAvailabilityAvailable,
		SKUAvailabilityUnavailable,
	}
}

// SKUName - The Sku name.
type SKUName string

const (
	SKUNameEP21281T4Mx1W     SKUName = "EP2_128_1T4_Mx1_W"
	SKUNameEP2128GPU1Mx1W    SKUName = "EP2_128_GPU1_Mx1_W"
	SKUNameEP22562T4W        SKUName = "EP2_256_2T4_W"
	SKUNameEP2256GPU2Mx1     SKUName = "EP2_256_GPU2_Mx1"
	SKUNameEP2641VPUW        SKUName = "EP2_64_1VPU_W"
	SKUNameEP264Mx1W         SKUName = "EP2_64_Mx1_W"
	SKUNameEdge              SKUName = "Edge"
	SKUNameEdgeMRMini        SKUName = "EdgeMR_Mini"
	SKUNameEdgeMRTCP         SKUName = "EdgeMR_TCP"
	SKUNameEdgePBase         SKUName = "EdgeP_Base"
	SKUNameEdgePHigh         SKUName = "EdgeP_High"
	SKUNameEdgePRBase        SKUName = "EdgePR_Base"
	SKUNameEdgePRBaseUPS     SKUName = "EdgePR_Base_UPS"
	SKUNameGPU               SKUName = "GPU"
	SKUNameGateway           SKUName = "Gateway"
	SKUNameManagement        SKUName = "Management"
	SKUNameRCALarge          SKUName = "RCA_Large"
	SKUNameRCASmall          SKUName = "RCA_Small"
	SKUNameRDC               SKUName = "RDC"
	SKUNameTCALarge          SKUName = "TCA_Large"
	SKUNameTCASmall          SKUName = "TCA_Small"
	SKUNameTDC               SKUName = "TDC"
	SKUNameTEA1Node          SKUName = "TEA_1Node"
	SKUNameTEA1NodeHeater    SKUName = "TEA_1Node_Heater"
	SKUNameTEA1NodeUPS       SKUName = "TEA_1Node_UPS"
	SKUNameTEA1NodeUPSHeater SKUName = "TEA_1Node_UPS_Heater"
	SKUNameTEA4NodeHeater    SKUName = "TEA_4Node_Heater"
	SKUNameTEA4NodeUPSHeater SKUName = "TEA_4Node_UPS_Heater"
	SKUNameTMA               SKUName = "TMA"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameEP21281T4Mx1W,
		SKUNameEP2128GPU1Mx1W,
		SKUNameEP22562T4W,
		SKUNameEP2256GPU2Mx1,
		SKUNameEP2641VPUW,
		SKUNameEP264Mx1W,
		SKUNameEdge,
		SKUNameEdgeMRMini,
		SKUNameEdgeMRTCP,
		SKUNameEdgePBase,
		SKUNameEdgePHigh,
		SKUNameEdgePRBase,
		SKUNameEdgePRBaseUPS,
		SKUNameGPU,
		SKUNameGateway,
		SKUNameManagement,
		SKUNameRCALarge,
		SKUNameRCASmall,
		SKUNameRDC,
		SKUNameTCALarge,
		SKUNameTCASmall,
		SKUNameTDC,
		SKUNameTEA1Node,
		SKUNameTEA1NodeHeater,
		SKUNameTEA1NodeUPS,
		SKUNameTEA1NodeUPSHeater,
		SKUNameTEA4NodeHeater,
		SKUNameTEA4NodeUPSHeater,
		SKUNameTMA,
	}
}

// SKUSignupOption - Sku can be signed up by customer or not.
type SKUSignupOption string

const (
	SKUSignupOptionAvailable SKUSignupOption = "Available"
	SKUSignupOptionNone      SKUSignupOption = "None"
)

// PossibleSKUSignupOptionValues returns the possible values for the SKUSignupOption const type.
func PossibleSKUSignupOptionValues() []SKUSignupOption {
	return []SKUSignupOption{
		SKUSignupOptionAvailable,
		SKUSignupOptionNone,
	}
}

// SKUTier - The Sku tier.
type SKUTier string

const (
	SKUTierStandard SKUTier = "Standard"
)

// PossibleSKUTierValues returns the possible values for the SKUTier const type.
func PossibleSKUTierValues() []SKUTier {
	return []SKUTier{
		SKUTierStandard,
	}
}

// SKUVersion - Availability of the Sku as preview/stable.
type SKUVersion string

const (
	SKUVersionPreview SKUVersion = "Preview"
	SKUVersionStable  SKUVersion = "Stable"
)

// PossibleSKUVersionValues returns the possible values for the SKUVersion const type.
func PossibleSKUVersionValues() []SKUVersion {
	return []SKUVersion{
		SKUVersionPreview,
		SKUVersionStable,
	}
}

// SSLStatus - Signifies whether SSL needs to be enabled or not.
type SSLStatus string

const (
	SSLStatusDisabled SSLStatus = "Disabled"
	SSLStatusEnabled  SSLStatus = "Enabled"
)

// PossibleSSLStatusValues returns the possible values for the SSLStatus const type.
func PossibleSSLStatusValues() []SSLStatus {
	return []SSLStatus{
		SSLStatusDisabled,
		SSLStatusEnabled,
	}
}

// ShareAccessProtocol - Access protocol to be used by the share.
type ShareAccessProtocol string

const (
	ShareAccessProtocolNFS ShareAccessProtocol = "NFS"
	ShareAccessProtocolSMB ShareAccessProtocol = "SMB"
)

// PossibleShareAccessProtocolValues returns the possible values for the ShareAccessProtocol const type.
func PossibleShareAccessProtocolValues() []ShareAccessProtocol {
	return []ShareAccessProtocol{
		ShareAccessProtocolNFS,
		ShareAccessProtocolSMB,
	}
}

// ShareAccessType - Type of access to be allowed on the share for this user.
type ShareAccessType string

const (
	ShareAccessTypeChange ShareAccessType = "Change"
	ShareAccessTypeCustom ShareAccessType = "Custom"
	ShareAccessTypeRead   ShareAccessType = "Read"
)

// PossibleShareAccessTypeValues returns the possible values for the ShareAccessType const type.
func PossibleShareAccessTypeValues() []ShareAccessType {
	return []ShareAccessType{
		ShareAccessTypeChange,
		ShareAccessTypeCustom,
		ShareAccessTypeRead,
	}
}

// ShareStatus - Current status of the share.
type ShareStatus string

const (
	ShareStatusNeedsAttention ShareStatus = "NeedsAttention"
	ShareStatusOK             ShareStatus = "OK"
	ShareStatusOffline        ShareStatus = "Offline"
	ShareStatusUnknown        ShareStatus = "Unknown"
	ShareStatusUpdating       ShareStatus = "Updating"
)

// PossibleShareStatusValues returns the possible values for the ShareStatus const type.
func PossibleShareStatusValues() []ShareStatus {
	return []ShareStatus{
		ShareStatusNeedsAttention,
		ShareStatusOK,
		ShareStatusOffline,
		ShareStatusUnknown,
		ShareStatusUpdating,
	}
}

type ShipmentType string

const (
	ShipmentTypeNotApplicable     ShipmentType = "NotApplicable"
	ShipmentTypeSelfPickup        ShipmentType = "SelfPickup"
	ShipmentTypeShippedToCustomer ShipmentType = "ShippedToCustomer"
)

// PossibleShipmentTypeValues returns the possible values for the ShipmentType const type.
func PossibleShipmentTypeValues() []ShipmentType {
	return []ShipmentType{
		ShipmentTypeNotApplicable,
		ShipmentTypeSelfPickup,
		ShipmentTypeShippedToCustomer,
	}
}

// StorageAccountStatus - Current status of the storage account
type StorageAccountStatus string

const (
	StorageAccountStatusNeedsAttention StorageAccountStatus = "NeedsAttention"
	StorageAccountStatusOK             StorageAccountStatus = "OK"
	StorageAccountStatusOffline        StorageAccountStatus = "Offline"
	StorageAccountStatusUnknown        StorageAccountStatus = "Unknown"
	StorageAccountStatusUpdating       StorageAccountStatus = "Updating"
)

// PossibleStorageAccountStatusValues returns the possible values for the StorageAccountStatus const type.
func PossibleStorageAccountStatusValues() []StorageAccountStatus {
	return []StorageAccountStatus{
		StorageAccountStatusNeedsAttention,
		StorageAccountStatusOK,
		StorageAccountStatusOffline,
		StorageAccountStatusUnknown,
		StorageAccountStatusUpdating,
	}
}

type SubscriptionState string

const (
	SubscriptionStateDeleted      SubscriptionState = "Deleted"
	SubscriptionStateRegistered   SubscriptionState = "Registered"
	SubscriptionStateSuspended    SubscriptionState = "Suspended"
	SubscriptionStateUnregistered SubscriptionState = "Unregistered"
	SubscriptionStateWarned       SubscriptionState = "Warned"
)

// PossibleSubscriptionStateValues returns the possible values for the SubscriptionState const type.
func PossibleSubscriptionStateValues() []SubscriptionState {
	return []SubscriptionState{
		SubscriptionStateDeleted,
		SubscriptionStateRegistered,
		SubscriptionStateSuspended,
		SubscriptionStateUnregistered,
		SubscriptionStateWarned,
	}
}

type TimeGrain string

const (
	TimeGrainPT12H TimeGrain = "PT12H"
	TimeGrainPT15M TimeGrain = "PT15M"
	TimeGrainPT1D  TimeGrain = "PT1D"
	TimeGrainPT1H  TimeGrain = "PT1H"
	TimeGrainPT1M  TimeGrain = "PT1M"
	TimeGrainPT30M TimeGrain = "PT30M"
	TimeGrainPT5M  TimeGrain = "PT5M"
	TimeGrainPT6H  TimeGrain = "PT6H"
)

// PossibleTimeGrainValues returns the possible values for the TimeGrain const type.
func PossibleTimeGrainValues() []TimeGrain {
	return []TimeGrain{
		TimeGrainPT12H,
		TimeGrainPT15M,
		TimeGrainPT1D,
		TimeGrainPT1H,
		TimeGrainPT1M,
		TimeGrainPT30M,
		TimeGrainPT5M,
		TimeGrainPT6H,
	}
}

// TriggerEventType - Trigger Kind.
type TriggerEventType string

const (
	TriggerEventTypeFileEvent          TriggerEventType = "FileEvent"
	TriggerEventTypePeriodicTimerEvent TriggerEventType = "PeriodicTimerEvent"
)

// PossibleTriggerEventTypeValues returns the possible values for the TriggerEventType const type.
func PossibleTriggerEventTypeValues() []TriggerEventType {
	return []TriggerEventType{
		TriggerEventTypeFileEvent,
		TriggerEventTypePeriodicTimerEvent,
	}
}

// UpdateOperation - The current update operation.
type UpdateOperation string

const (
	UpdateOperationDownload UpdateOperation = "Download"
	UpdateOperationInstall  UpdateOperation = "Install"
	UpdateOperationNone     UpdateOperation = "None"
	UpdateOperationScan     UpdateOperation = "Scan"
)

// PossibleUpdateOperationValues returns the possible values for the UpdateOperation const type.
func PossibleUpdateOperationValues() []UpdateOperation {
	return []UpdateOperation{
		UpdateOperationDownload,
		UpdateOperationInstall,
		UpdateOperationNone,
		UpdateOperationScan,
	}
}

// UpdateOperationStage - Current stage of the update operation.
type UpdateOperationStage string

const (
	UpdateOperationStageDownloadComplete UpdateOperationStage = "DownloadComplete"
	UpdateOperationStageDownloadFailed   UpdateOperationStage = "DownloadFailed"
	UpdateOperationStageDownloadStarted  UpdateOperationStage = "DownloadStarted"
	UpdateOperationStageFailure          UpdateOperationStage = "Failure"
	UpdateOperationStageInitial          UpdateOperationStage = "Initial"
	UpdateOperationStageInstallComplete  UpdateOperationStage = "InstallComplete"
	UpdateOperationStageInstallFailed    UpdateOperationStage = "InstallFailed"
	UpdateOperationStageInstallStarted   UpdateOperationStage = "InstallStarted"
	UpdateOperationStageRebootInitiated  UpdateOperationStage = "RebootInitiated"
	UpdateOperationStageRescanComplete   UpdateOperationStage = "RescanComplete"
	UpdateOperationStageRescanFailed     UpdateOperationStage = "RescanFailed"
	UpdateOperationStageRescanStarted    UpdateOperationStage = "RescanStarted"
	UpdateOperationStageScanComplete     UpdateOperationStage = "ScanComplete"
	UpdateOperationStageScanFailed       UpdateOperationStage = "ScanFailed"
	UpdateOperationStageScanStarted      UpdateOperationStage = "ScanStarted"
	UpdateOperationStageSuccess          UpdateOperationStage = "Success"
	UpdateOperationStageUnknown          UpdateOperationStage = "Unknown"
)

// PossibleUpdateOperationStageValues returns the possible values for the UpdateOperationStage const type.
func PossibleUpdateOperationStageValues() []UpdateOperationStage {
	return []UpdateOperationStage{
		UpdateOperationStageDownloadComplete,
		UpdateOperationStageDownloadFailed,
		UpdateOperationStageDownloadStarted,
		UpdateOperationStageFailure,
		UpdateOperationStageInitial,
		UpdateOperationStageInstallComplete,
		UpdateOperationStageInstallFailed,
		UpdateOperationStageInstallStarted,
		UpdateOperationStageRebootInitiated,
		UpdateOperationStageRescanComplete,
		UpdateOperationStageRescanFailed,
		UpdateOperationStageRescanStarted,
		UpdateOperationStageScanComplete,
		UpdateOperationStageScanFailed,
		UpdateOperationStageScanStarted,
		UpdateOperationStageSuccess,
		UpdateOperationStageUnknown,
	}
}

// UpdateStatus - Status of the update.
type UpdateStatus string

const (
	UpdateStatusDownloadCompleted UpdateStatus = "DownloadCompleted"
	UpdateStatusDownloadPending   UpdateStatus = "DownloadPending"
	UpdateStatusDownloadStarted   UpdateStatus = "DownloadStarted"
	UpdateStatusInstallCompleted  UpdateStatus = "InstallCompleted"
	UpdateStatusInstallStarted    UpdateStatus = "InstallStarted"
)

// PossibleUpdateStatusValues returns the possible values for the UpdateStatus const type.
func PossibleUpdateStatusValues() []UpdateStatus {
	return []UpdateStatus{
		UpdateStatusDownloadCompleted,
		UpdateStatusDownloadPending,
		UpdateStatusDownloadStarted,
		UpdateStatusInstallCompleted,
		UpdateStatusInstallStarted,
	}
}

// UpdateType - Type of the Update
type UpdateType string

const (
	UpdateTypeFirmware   UpdateType = "Firmware"
	UpdateTypeKubernetes UpdateType = "Kubernetes"
	UpdateTypeSoftware   UpdateType = "Software"
)

// PossibleUpdateTypeValues returns the possible values for the UpdateType const type.
func PossibleUpdateTypeValues() []UpdateType {
	return []UpdateType{
		UpdateTypeFirmware,
		UpdateTypeKubernetes,
		UpdateTypeSoftware,
	}
}

// UserType - Type of the user.
type UserType string

const (
	UserTypeARM             UserType = "ARM"
	UserTypeLocalManagement UserType = "LocalManagement"
	UserTypeShare           UserType = "Share"
)

// PossibleUserTypeValues returns the possible values for the UserType const type.
func PossibleUserTypeValues() []UserType {
	return []UserType{
		UserTypeARM,
		UserTypeLocalManagement,
		UserTypeShare,
	}
}
