#ifndef GHMM_PSEQUENCE_H
#define GHMM_PSEQUENCE_H

#ifdef __cplusplus
extern "C" {
#endif

  /** Sequence struct for integer/double pairs
   */
typedef struct ghmm_dpseq {
  /** for each alphabet in model->number_of_alphabets there is one int seq **/
  int **seq;
  /** number of alphabets (same as in model) **/
  int number_of_alphabets;
  /** for each sequence position there are also double values (e.g) Ka **/
  double **d_value;
  /** number of continous sequences **/
  int number_of_d_seqs;
  /** length of the sequence **/
  int length;
} ghmm_dpseq;

ghmm_dpseq* ghmm_dpseq_init(int length, int number_of_alphabets, int number_of_d_seqs);

int ghmm_dpseq_free(ghmm_dpseq *seq);

void ghmm_dpseq_set_discrete(ghmm_dpseq *seq_pointer, int index, int * int_seq);

int* ghmm_dpseq_get_discrete(ghmm_dpseq *seq_pointer, int index);

void ghmm_dpseq_set_continuous(ghmm_dpseq *seq_pointer, int index, double * d_seq);

double* ghmm_dpseq_get_continuous(ghmm_dpseq *seq_pointer, int index);

ghmm_dpseq* ghmm_dpseq_slice(ghmm_dpseq *seq_pointer, int start, int stop);

int ghmm_dpseq_get_char(ghmm_dpseq *seq_pointer, int alphabet, int index);

double ghmm_dpseq_get_double(ghmm_dpseq *seq_pointer, int seq_index, int index);


#ifdef __cplusplus
}
#endif

#endif /* GHMM_PSEQUENCE_H */
