// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file rpc_typesPubSubTypes.hpp
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */


#ifndef FAST_DDS_GENERATED__RPC_TYPES_PUBSUBTYPES_HPP
#define FAST_DDS_GENERATED__RPC_TYPES_PUBSUBTYPES_HPP

#include <fastdds/dds/core/policy/QosPolicies.hpp>
#include <fastdds/dds/topic/TopicDataType.hpp>
#include <fastdds/rtps/common/InstanceHandle.hpp>
#include <fastdds/rtps/common/SerializedPayload.hpp>
#include <fastdds/utils/md5.hpp>

#include "rpc_types.hpp"


#if !defined(FASTDDS_GEN_API_VER) || (FASTDDS_GEN_API_VER != 3)
#error \
    Generated rpc_types is not compatible with current installed Fast DDS. Please, regenerate it with fastddsgen.
#endif  // FASTDDS_GEN_API_VER

namespace eprosima {

namespace fastdds {

namespace dds {


typedef std::array<uint8_t, 12> GuidPrefix_t;

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct EntityId_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct EntityId_t_f
{
    typedef uint8_t EntityId_t::* type;
    friend constexpr type get(
            EntityId_t_f);
};

template struct EntityId_t_rob<EntityId_t_f, &EntityId_t::m_entityKind>;

template <typename T, typename Tag>
inline size_t constexpr EntityId_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG




#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct GUID_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct GUID_t_f
{
    typedef eprosima::fastdds::dds::EntityId_t GUID_t::* type;
    friend constexpr type get(
            GUID_t_f);
};

template struct GUID_t_rob<GUID_t_f, &GUID_t::m_entityId>;

template <typename T, typename Tag>
inline size_t constexpr GUID_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG




#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct SequenceNumber_t_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct SequenceNumber_t_f
{
    typedef uint32_t SequenceNumber_t::* type;
    friend constexpr type get(
            SequenceNumber_t_f);
};

template struct SequenceNumber_t_rob<SequenceNumber_t_f, &SequenceNumber_t::m_low>;

template <typename T, typename Tag>
inline size_t constexpr SequenceNumber_t_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG




#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct SampleIdentity_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct SampleIdentity_f
{
    typedef eprosima::fastdds::dds::SequenceNumber_t SampleIdentity::* type;
    friend constexpr type get(
            SampleIdentity_f);
};

template struct SampleIdentity_rob<SampleIdentity_f, &SampleIdentity::m_sequence_number>;

template <typename T, typename Tag>
inline size_t constexpr SampleIdentity_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG



namespace rpc
{
    typedef uint8_t UnknownOperation;
    typedef uint8_t UnknownException;
    typedef uint8_t UnusedMember;
    typedef eprosima::fastcdr::fixed_string<255> InstanceName;

    #ifndef SWIG
    namespace detail {

    template<typename Tag, typename Tag::type M>
    struct ReplyHeader_rob
    {
        friend constexpr typename Tag::type get(
                Tag)
        {
            return M;
        }

    };

    struct ReplyHeader_f
    {
        typedef eprosima::fastdds::dds::rpc::RemoteExceptionCode_t ReplyHeader::* type;
        friend constexpr type get(
                ReplyHeader_f);
    };

    template struct ReplyHeader_rob<ReplyHeader_f, &ReplyHeader::m_remoteEx>;

    template <typename T, typename Tag>
    inline size_t constexpr ReplyHeader_offset_of()
    {
        return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
    }

    } // namespace detail
    #endif // ifndef SWIG



} // namespace rpc

} // namespace dds

} // namespace fastdds

} // namespace eprosima


#endif // FAST_DDS_GENERATED__RPC_TYPES_PUBSUBTYPES_HPP

