// |reftest| shell-option(--enable-array-grouping) skip-if(!Array.prototype.group||!xulRuntime.shell) -- array-grouping is not enabled unconditionally, requires shell-options
// Copyright (c) 2021 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.groupToMap
description: Array.prototype.groupToMap errors when array-like's length can't be coerced.
info: |
  22.1.3.15 Array.prototype.groupToMap ( callbackfn [ , thisArg ] )

  ...

  2. Let len be ? LengthOfArrayLike(O).

  ...
features: [array-grouping]
---*/

assert.throws(Test262Error, function() {
  const arrayLike = Object.defineProperty({}, 'length', {
    get: function() {
      throw new Test262Error('no length for you');
    }
  });
  Array.prototype.groupToMap.call(arrayLike, function() {
    return 'key';
  });
});

assert.throws(TypeError, function() {
  const arrayLike = {
    length: 1n,
  };
  Array.prototype.groupToMap.call(arrayLike, function() {
    return 'key';
  });
});

reportCompare(0, 0);
