/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response.filter;

import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCleaningResponseFilter
implements IResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCleaningResponseFilter.class);

    @Override
    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        AppendingStringBuffer result = responseBuffer;
        if (this.shouldFilter(responseBuffer)) {
            result = this.stripNonValidXMLCharacters(responseBuffer);
        }
        return result;
    }

    protected boolean shouldFilter(AppendingStringBuffer responseBuffer) {
        int min = Math.min(150, responseBuffer.length());
        String firstNChars = responseBuffer.substring(0, min);
        return firstNChars.contains("<ajax-response>");
    }

    public AppendingStringBuffer stripNonValidXMLCharacters(AppendingStringBuffer input) {
        int codePoint;
        if (input == null) {
            return new AppendingStringBuffer();
        }
        char[] chars = input.getValue();
        AppendingStringBuffer out = null;
        boolean isDebugEnabled = LOG.isDebugEnabled();
        for (int i = 0; i < input.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(chars, i, chars.length);
            if (!this.isValidXmlChar(codePoint)) {
                if (out == null) {
                    out = new AppendingStringBuffer(chars.length);
                    out.append((Object)input.subSequence(0, i));
                    if (!isDebugEnabled) continue;
                    LOG.debug("An invalid character '{}' found at position '{}' in '{}'", new Object[]{String.format("0x%X", codePoint), i, new String(chars)});
                    continue;
                }
                if (!isDebugEnabled) continue;
                LOG.debug(String.format("Dropping character for codePoint '0x%X' at position '%d'", codePoint, i));
                continue;
            }
            if (out == null) continue;
            out.append(Character.toChars(codePoint));
        }
        return out != null ? out : input;
    }

    protected boolean isValidXmlChar(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }
}

