/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.QueryableFrame;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.vns.service.Service;
import org.apache.vinci.transport.vns.service.ServiceAlias;
import org.apache.vinci.transport.vns.service.ServiceInfo;
import org.apache.vinci.transport.vns.service.ServiceInterface;

public class NameClient {
    String vnsHost;
    int vnsPort = 9000;
    static Random R = new Random();
    private static String[] options = new String[]{"parseqname", "lookup", "resolve", "getlist", "getnames", "gethits", "getallhits", "serveon", "addservice"};

    public NameClient() {
        this.configure(VinciContext.getGlobalContext().getVNSHost(), VinciContext.getGlobalContext().getVNSPort());
    }

    public NameClient(String host, int port) {
        this.configure(host, port);
    }

    public void configure(String host, int port) {
        if (host != null) {
            this.vnsHost = host;
        }
        if (port > -1) {
            this.vnsPort = port;
        }
    }

    public static ServiceInfo parseQName(String qname) {
        String[] result = new String[5];
        int i = qname.indexOf("/");
        if (i > -1) {
            result[0] = qname.substring(0, i);
        }
        ++i;
        if ((i = (qname = qname.substring(i)).indexOf("[")) > -1) {
            String lhi = qname.substring(i + 1, qname.length() - 1);
            StringTokenizer str = new StringTokenizer(lhi, ",");
            int j = 2;
            while (str.hasMoreTokens()) {
                result[j++] = str.nextToken().trim();
            }
        } else {
            i = qname.length();
        }
        result[1] = qname.substring(0, i);
        return new ServiceInfo(result);
    }

    public ServiceInfo[] lookup(String name, int level, String host, String instance, String ws) {
        VinciFrame req = new VinciFrame();
        req.fadd("vinci:COMMAND", "resolve").fadd("SERVICE", name).fadd("LEVEL", level).fadd("HOST", host).fadd("INSTANCE", instance).fadd("WORKSPACE", ws);
        System.out.println(req.toXML());
        VinciFrame resp = (VinciFrame)this.transmit(req);
        this.checkError(resp);
        return this.constructServiceInfo(resp.fget("SERVER"), resp.fgetString("LEVEL"), name);
    }

    public ServiceInfo[] lookup(String name) {
        return this.lookup(name, -1, null, null, null);
    }

    public ServiceInfo[] lookup(String name, int level) {
        return this.lookup(name, level, null, null, null);
    }

    public ServiceInfo[] lookup(String name, int level, String host) {
        return this.lookup(name, level, host, null, null);
    }

    public ServiceInfo[] lookup(String name, int level, String host, String instance) {
        return this.lookup(name, level, host, instance, null);
    }

    public ServiceInfo[] lookup(String name, String host) {
        return this.lookup(name, -1, host, null, null);
    }

    public ServiceInfo[] lookup(String name, String host, String instance) {
        return this.lookup(name, -1, host, instance, null);
    }

    public ServiceInfo[] lookup(String name, String host, String instance, String ws) {
        return this.lookup(name, -1, host, instance, ws);
    }

    public ServiceInfo resolve(String name, String host, String ip, String ws, int level, int inst) {
        VinciFrame req = new VinciFrame();
        req.fadd("vinci:COMMAND", "resolve").fadd("SERVICE", name);
        NameClient.smFrameAdd(req, "HOST", host);
        NameClient.smFrameAdd(req, "IP", ip);
        NameClient.smFrameAdd(req, "WORKSPACE", ws);
        req.fadd("LEVEL", level);
        if (inst > 0) {
            req.fadd("INSTANCE", inst);
        }
        VinciFrame resp = (VinciFrame)this.transmit(req);
        this.checkError(resp);
        ServiceInfo[] S = this.constructServiceInfo(resp.fget("SERVER"), resp.fgetString("LEVEL"), name);
        return S.length > 0 ? S[R.nextInt(S.length)] : null;
    }

    public static void smFrameAdd(VinciFrame v, String tag, String val) {
        if (val != null && tag != null) {
            v.fadd(tag, val);
        }
    }

    public ServiceInfo resolve(String name, int level) {
        VinciFrame req = (VinciFrame)new VinciFrame().fadd("vinci:COMMAND", "resolve").fadd("SERVICE", name).fadd("LEVEL", level);
        VinciFrame resp = (VinciFrame)this.transmit(req);
        this.checkError(resp);
        ServiceInfo[] S = this.constructServiceInfo(resp.fget("SERVER"), resp.fgetString("LEVEL"), name);
        return S.length > 0 ? S[R.nextInt(S.length)] : null;
    }

    public ServiceInfo resolve(String name) {
        return this.resolve(name, -1);
    }

    public ServiceInterface[] getList(String prefix, String level) {
        VinciFrame req = new VinciFrame();
        req.fadd("vinci:COMMAND", "getlist");
        req.fadd("LEVEL", level);
        this.smartAdd(req, "PREFIX", prefix);
        VinciFrame resp = (VinciFrame)this.transmit(req);
        this.checkError(resp);
        ArrayList A = resp.fget("SERVICE");
        ServiceInterface[] S = new ServiceInterface[A.size()];
        for (int i = 0; i < A.size(); ++i) {
            QueryableFrame Q = (QueryableFrame)A.get(i);
            if (Q.fgetString("TARGET") == null) {
                Hashtable<String, Object> H = new Hashtable<String, Object>();
                int total = Q.getKeyValuePairCount();
                KeyValuePair P = null;
                for (int j = 0; j < total; ++j) {
                    P = Q.getKeyValuePair(j);
                    if (P.isValueALeaf()) {
                        H.put(P.getKey(), P.getValueAsString());
                        continue;
                    }
                    H.put(P.getKey(), P.getValue());
                }
                S[i] = new Service(H);
                continue;
            }
            S[i] = new ServiceAlias(Q.fgetString("NAME"), Q.fgetString("TARGET"));
        }
        return S;
    }

    public ServiceInterface[] getList(String prefix, int level) {
        return this.getList(prefix, "" + level);
    }

    public ServiceInterface[] getList() {
        return this.getList(null, -1);
    }

    public ServiceInterface[] getList(String prefix) {
        return this.getList(prefix, -1);
    }

    public ServiceInterface[] getList(int level) {
        return this.getList(null, level);
    }

    public String[] getNames(String prefix, String level) {
        VinciFrame req = new VinciFrame();
        req.fadd("vinci:COMMAND", "getnames");
        req.fadd("LEVEL", level);
        this.smartAdd(req, "PREFIX", prefix);
        VinciFrame resp = (VinciFrame)this.transmit(req);
        this.checkError(resp);
        ArrayList A = resp.fget("SERVICE");
        String[] S = new String[A.size()];
        for (int i = 0; i < A.size(); ++i) {
            S[i] = ((FrameLeaf)A.get(i)).toString().trim();
        }
        return S;
    }

    public String[] getNames(String prefix, int level) {
        return this.getNames(prefix, "" + level);
    }

    public String[] getNames() {
        return this.getNames(null, -1);
    }

    public String[] getNames(String prefix) {
        return this.getNames(prefix, -1);
    }

    public String[] getNames(int level) {
        return this.getNames(null, level);
    }

    public int getHits(String type) {
        VinciFrame out = new VinciFrame();
        out.fadd("vinci:COMMAND", "gethits");
        this.smartAdd(out, "TYPE", type);
        VinciFrame resp = (VinciFrame)this.transmit(out);
        this.checkError(resp);
        return resp.fgetInt("HITS");
    }

    public int getHits() {
        return this.getHits(null);
    }

    public HitsList getAllHits() {
        VinciFrame out = new VinciFrame();
        out.fadd("vinci:COMMAND", "gethits");
        out.fadd("TYPE", "all");
        VinciFrame resp = (VinciFrame)this.transmit(out);
        this.checkError(resp);
        HitsList H = new HitsList();
        H.totalhits = resp.fgetInt("TOTAL");
        H.starttime = resp.fgetString("STARTED");
        ArrayList A = resp.fget("HITS");
        H.hits = new int[A.size()];
        H.types = new String[A.size()];
        for (int i = 0; i < H.hits.length; ++i) {
            QueryableFrame Q = (QueryableFrame)A.get(i);
            H.hits[i] = Q.fgetInt("COUNT");
            H.types[i] = Q.fgetString("TYPE");
        }
        return H;
    }

    public boolean delService(Service S) {
        return this.modifyService(S, "delservice");
    }

    public boolean addService(Service S) {
        return this.modifyService(S, "addservice");
    }

    public boolean updateService(Service S) {
        return this.modifyService(S, "updateservice");
    }

    public boolean modifyService(Service S, String type) {
        VinciFrame out = new VinciFrame();
        out.fadd("vinci:COMMAND", type);
        out.fadd("SERVICE", S.toFrame());
        VinciFrame resp = (VinciFrame)this.transmit(out);
        this.checkError(resp);
        return resp.fgetString("STATUS").toLowerCase().trim().equals("ok");
    }

    public boolean addAlias(String name, String target) {
        return this.modifyAlias("addalias", name, target);
    }

    public boolean delAlias(String name) {
        return this.modifyAlias("addalias", name, null);
    }

    public boolean modifyAlias(String type, String name, String target) {
        VinciFrame out = new VinciFrame();
        out.fadd("vinci:COMMAND", type);
        VinciFrame srv = new VinciFrame();
        this.smartAdd(srv, "NAME", name);
        this.smartAdd(srv, "TARGET", target);
        out.fadd("SERVICE", srv);
        VinciFrame resp = (VinciFrame)this.transmit(out);
        this.checkError(resp);
        return resp.fgetString("STATUS").toLowerCase().trim().equals("ok");
    }

    public int[] serveon(String name, String host, int level, int instance) {
        if (NameClient.strip(host) == null || host.trim().toLowerCase().equals("localhost")) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not resolve local host");
            }
        }
        VinciFrame out = (VinciFrame)new VinciFrame().fadd("vinci:COMMAND", "serveon").fadd("SERVICE", name).fadd("HOST", host).fadd("LEVEL", level).fadd("INSTANCE", instance);
        VinciFrame resp = (VinciFrame)this.transmit(out);
        this.checkError(resp);
        int[] result = new int[]{resp.fgetInt("PORT"), resp.fgetInt("LEVEL"), resp.fgetInt("INSTANCE")};
        return result;
    }

    public int[] serveon(String name) {
        return this.serveon(name, null, -1, 0);
    }

    private void smartAdd(VinciFrame req, String tag, String val) {
        if (val != null) {
            req.fadd(tag, val);
        }
    }

    private ServiceInfo[] constructServiceInfo(ArrayList A, String level, String name) {
        if (level == null) {
            level = "-1";
        }
        ServiceInfo[] S = new ServiceInfo[A.size()];
        for (int i = 0; i < S.length; ++i) {
            QueryableFrame L = (QueryableFrame)A.get(i);
            S[i] = new ServiceInfo(name, L.fgetString("HOST"), L.fgetString("PORT"), level, L.fgetString("INSTANCE"));
        }
        return S;
    }

    private Transportable transmit(Transportable T) {
        try {
            return BaseClient.rpc(T, this.vnsHost, this.vnsPort);
        }
        catch (Exception e) {
            VinciFrame F = new VinciFrame();
            F.fadd("vinci:ERROR", e.toString());
            return F;
        }
    }

    private void checkError(VinciFrame in) {
        String s = in.fgetString("vinci:ERROR");
        if (s != null) {
            throw new RuntimeException(s);
        }
    }

    public static void main(String[] args) {
        NameClient nc = new NameClient();
        if (args.length > 1) {
            nc.configure(args[0], Integer.parseInt(args[1]));
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        block13: while (true) {
            NameClient.prMainMenu();
            String s = NameClient.getLine(br).trim();
            if (s.equals("q")) break;
            try {
                switch (NameClient.parseMainOption(s)) {
                    case 0: {
                        NameClient.handleParseQName(br, nc);
                        continue block13;
                    }
                    case 1: {
                        NameClient.handleLookup(br, nc);
                        continue block13;
                    }
                    case 2: {
                        NameClient.handleResolve(br, nc);
                        continue block13;
                    }
                    case 3: {
                        NameClient.handleGetList(br, nc);
                        continue block13;
                    }
                    case 4: {
                        NameClient.handleGetNames(br, nc);
                        continue block13;
                    }
                    case 5: {
                        NameClient.handleGetHits(br, nc);
                        continue block13;
                    }
                    case 6: {
                        NameClient.handleGetAllHits(br, nc);
                        continue block13;
                    }
                    case 7: {
                        NameClient.handleServeon(br, nc);
                        continue block13;
                    }
                    case 8: {
                        NameClient.handleAddService(br, nc);
                        continue block13;
                    }
                }
                NameClient.pr("Unknown option");
            }
            catch (RuntimeException e) {
                NameClient.pr("" + e);
            }
        }
    }

    private static void handleParseQName(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the qname to parse : ", false);
        ServiceInfo S = NameClient.parseQName(NameClient.getLine(br));
        NameClient.pr(S.toString());
    }

    private static void handleLookup(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the service name : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the level : ", false);
        String level = NameClient.strip(NameClient.getLine(br));
        int l = -1;
        try {
            l = Integer.parseInt(level);
        }
        catch (Exception e) {
            l = -1;
        }
        NameClient.pr("Enter the host : ", false);
        String host = NameClient.strip(NameClient.getLine(br));
        NameClient.pr("Enter the instance : ", false);
        String instance = NameClient.strip(NameClient.getLine(br));
        NameClient.pr("Enter the workspace : ", false);
        String ws = NameClient.strip(NameClient.getLine(br));
        ServiceInfo[] S = nc.lookup(name, l, host, instance, ws);
        for (int i = 0; i < S.length; ++i) {
            NameClient.pr("Service " + i + ":\n" + S[i]);
        }
    }

    private static void handleResolve(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the service name : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the service host : ", false);
        String host = NameClient.getLine(br);
        NameClient.pr("Enter the service IP : ", false);
        String ip = NameClient.getLine(br);
        NameClient.pr("Enter the service workspace : ", false);
        String ws = NameClient.getLine(br);
        NameClient.pr("Enter the level : ", false);
        String level = NameClient.strip(NameClient.getLine(br));
        int l = -1;
        try {
            l = Integer.parseInt(level);
        }
        catch (Exception e) {
            l = -1;
        }
        ServiceInfo S = nc.resolve(NameClient.strip(name), NameClient.strip(host), NameClient.strip(ip), NameClient.strip(ws), l, -1);
        NameClient.pr("Service : \n" + S);
    }

    private static void handleServeon(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the service name : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the host : ", false);
        String host = NameClient.strip(NameClient.getLine(br));
        NameClient.pr("Enter the level : ", false);
        String level = NameClient.strip(NameClient.getLine(br));
        int l = -1;
        try {
            l = Integer.parseInt(level);
        }
        catch (Exception e) {
            l = -1;
        }
        NameClient.pr("Enter the instance : ", false);
        String instance = NameClient.strip(NameClient.getLine(br));
        int inst = 0;
        try {
            inst = Integer.parseInt(instance);
        }
        catch (Exception e) {
            inst = 0;
        }
        int[] temp = nc.serveon(name, host, l, inst);
        NameClient.pr("PORT: " + temp[0]);
    }

    private static void handleGetList(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the prefix : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the level : ", false);
        String level = NameClient.strip(NameClient.getLine(br));
        ServiceInterface[] S = nc.getList(name, level);
        for (int i = 0; i < S.length; ++i) {
            if (ServiceAlias.isAlias(S[i])) {
                NameClient.pr("Service alias " + i + ":\n" + ((ServiceAlias)S[i]).toXML());
                continue;
            }
            NameClient.pr("Service " + i + ":\n" + ((Service)S[i]).toXML());
        }
    }

    private static void handleGetNames(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the prefix : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the level : ", false);
        String level = NameClient.strip(NameClient.getLine(br));
        String[] S = nc.getNames(name, level);
        for (int i = 0; i < S.length; ++i) {
            NameClient.pr("Service " + i + ": " + S[i]);
        }
    }

    private static void handleGetHits(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the type : ", false);
        String type = NameClient.getLine(br);
        NameClient.pr("Result : " + nc.getHits(type));
    }

    private static void handleGetAllHits(BufferedReader br, NameClient nc) {
        HitsList H = nc.getAllHits();
        for (int i = 0; i < H.hits.length; ++i) {
            NameClient.pr("[" + i + "] " + H.types[i].trim() + " : " + H.hits[i]);
        }
        NameClient.pr("Total : " + H.totalhits);
        NameClient.pr("Starttime : " + H.starttime);
    }

    private static void handleAddService(BufferedReader br, NameClient nc) {
        NameClient.pr("Enter the service name : ", false);
        String name = NameClient.getLine(br);
        NameClient.pr("Enter the service host : ", false);
        String host = NameClient.getLine(br);
        NameClient.pr("Enter the service level : ", false);
        String level = NameClient.getLine(br);
        NameClient.pr("Enter the service minport : ", false);
        String minport = NameClient.getLine(br);
        NameClient.pr("Enter the service maxport : ", false);
        String maxport = NameClient.getLine(br);
        NameClient.pr("Enter the service port : ", false);
        String port = NameClient.getLine(br);
        Hashtable H = new Hashtable();
        NameClient.smAddHT(H, "NAME", name);
        NameClient.smAddHT(H, "HOST", host);
        NameClient.smAddHT(H, "LEVEL", level);
        NameClient.smAddHT(H, "MINPORT", minport);
        NameClient.smAddHT(H, "MAXPORT", maxport);
        NameClient.smAddHT(H, "PORT", port);
        Service S = new Service(H);
        if (nc.addService(S)) {
            System.out.println("Successfully added service.\n" + S);
        } else {
            System.out.println("Could not add the service");
        }
    }

    private static void prMainMenu() {
        NameClient.pr("\nMenu \n");
        for (int i = 0; i < options.length; ++i) {
            NameClient.pr(i + " : " + options[i]);
        }
        NameClient.pr("\nq : quit\n");
        NameClient.pr("Enter your selection : ", false);
    }

    private static void smAddHT(Hashtable H, String key, String val) {
        if (key != null && val != null) {
            H.put(key, val);
        }
    }

    private static int parseMainOption(String s) {
        s = s.toLowerCase().trim();
        for (int i = 0; i < options.length; ++i) {
            if (!s.equals(options[i])) continue;
            return i;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String pr(String s) {
        System.out.println(s);
        return s;
    }

    public static String pr(String s, boolean newline) {
        System.out.print(s + (newline ? "\n" : ""));
        return s;
    }

    private static String strip(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        return s.trim();
    }

    private static String getLine(BufferedReader br) {
        try {
            return br.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    static class HitsList {
        String[] types;
        int[] hits;
        int totalhits;
        String starttime;
    }
}

