/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class IdentifierExpression
extends Expression {
    public IdentifierExpression(int offset, String identifier) {
        super(offset);
        this.setIdentifier(identifier);
    }

    public IdentifierExpression(int offset, Identifier identifier) {
        super(offset);
        this.setIdentifierToken(identifier);
    }

    public final String getIdentifier() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setIdentifier(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getIdentifierToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setIdentifierToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final AstNodeCollection<AstType> getTypeArguments() {
        return this.getChildrenByRole(Roles.TYPE_ARGUMENT);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitIdentifierExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof IdentifierExpression) {
            IdentifierExpression otherIdentifier = (IdentifierExpression)other;
            return !otherIdentifier.isNull() && IdentifierExpression.matchString(this.getIdentifier(), otherIdentifier.getIdentifier()) && this.getTypeArguments().matches(otherIdentifier.getTypeArguments(), match);
        }
        return false;
    }
}

