/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.Error;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.GenericParameterCollection;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;

public class TypeDefinition
extends TypeReference
implements IMemberDefinition {
    private final GenericParameterCollection _genericParameters = new GenericParameterCollection(this);
    private final Collection<TypeDefinition> _declaredTypes = new Collection();
    private final Collection<FieldDefinition> _declaredFields = new Collection();
    private final Collection<MethodDefinition> _declaredMethods = new Collection();
    private final Collection<TypeReference> _explicitInterfaces = new Collection();
    private final Collection<CustomAnnotation> _customAnnotations = new Collection();
    private final Collection<SourceAttribute> _sourceAttributes = new Collection();
    private final List<GenericParameter> _genericParametersView = Collections.unmodifiableList(this._genericParameters);
    private final List<TypeDefinition> _declaredTypesView = Collections.unmodifiableList(this._declaredTypes);
    private final List<FieldDefinition> _declaredFieldsView = Collections.unmodifiableList(this._declaredFields);
    private final List<MethodDefinition> _declaredMethodsView = Collections.unmodifiableList(this._declaredMethods);
    private final List<TypeReference> _explicitInterfacesView = Collections.unmodifiableList(this._explicitInterfaces);
    private final List<CustomAnnotation> _customAnnotationsView = Collections.unmodifiableList(this._customAnnotations);
    private final List<SourceAttribute> _sourceAttributesView = Collections.unmodifiableList(this._sourceAttributes);
    private IMetadataResolver _resolver;
    private String _simpleName;
    private String _packageName;
    private String _internalName;
    private String _fullName;
    private String _signature;
    private String _erasedSignature;
    private TypeReference _baseType;
    private long _flags;
    private int _compilerVersion;
    private List<Enum> _enumConstants;
    private TypeReference _rawType;
    private MethodReference _declaringMethod;
    private ConstantPool _constantPool;
    private ITypeLoader _typeLoader;

    public TypeDefinition() {
    }

    public TypeDefinition(IMetadataResolver resolver) {
        this();
        this._resolver = (IMetadataResolver)VerifyArgument.notNull((Object)resolver, (String)"resolver");
    }

    final ITypeLoader getTypeLoader() {
        return this._typeLoader;
    }

    final void setTypeLoader(ITypeLoader typeLoader) {
        this._typeLoader = typeLoader;
    }

    public final CompilerTarget getCompilerTarget() {
        return CompilerTarget.lookup(this.getCompilerMajorVersion(), this.getCompilerMinorVersion());
    }

    public final int getCompilerMajorVersion() {
        return this._compilerVersion >>> 16;
    }

    public final int getCompilerMinorVersion() {
        return this._compilerVersion & 0xFFFF;
    }

    public final ConstantPool getConstantPool() {
        return this._constantPool;
    }

    protected final void setConstantPool(ConstantPool constantPool) {
        this._constantPool = constantPool;
    }

    protected final void setCompilerVersion(int majorVersion, int minorVersion) {
        this._compilerVersion = (majorVersion & 0xFFFF) << 16 | minorVersion & 0xFFFF;
    }

    public final IMetadataResolver getResolver() {
        return this._resolver;
    }

    protected final void setResolver(IMetadataResolver resolver) {
        this._resolver = resolver;
    }

    @Override
    public String getPackageName() {
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType != null) {
            return declaringType.getPackageName();
        }
        return this._packageName != null ? this._packageName : "";
    }

    @Override
    public String getSimpleName() {
        return this._simpleName != null ? this._simpleName : this.getName();
    }

    protected final void setSimpleName(String simpleName) {
        this._simpleName = simpleName;
    }

    protected void setPackageName(String packageName) {
        this._packageName = packageName;
        this._fullName = null;
        this._internalName = null;
    }

    @Override
    public String getFullName() {
        if (this._fullName == null) {
            this._fullName = super.getFullName();
        }
        return this._fullName;
    }

    @Override
    public String getErasedSignature() {
        if (this._erasedSignature == null) {
            this._erasedSignature = super.getErasedSignature();
        }
        return this._erasedSignature;
    }

    @Override
    public String getSignature() {
        if (this._signature == null) {
            this._signature = super.getSignature();
        }
        return this._signature;
    }

    @Override
    public String getInternalName() {
        if (this._internalName == null) {
            this._internalName = super.getInternalName();
        }
        return this._internalName;
    }

    @Override
    public <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitClassType(this, parameter);
    }

    public final MethodReference getDeclaringMethod() {
        return this._declaringMethod;
    }

    protected final void setDeclaringMethod(MethodReference declaringMethod) {
        this._declaringMethod = declaringMethod;
    }

    public final TypeReference getBaseType() {
        return this._baseType;
    }

    protected final void setBaseType(TypeReference baseType) {
        this._baseType = baseType;
    }

    public final List<Enum> getEnumConstants() {
        if (this.isEnum()) {
            return this._enumConstants != null ? this._enumConstants : Collections.emptyList();
        }
        throw Error.notEnumType(this);
    }

    protected final void setEnumConstants(Enum ... values) {
        VerifyArgument.notNull((Object)values, (String)"values");
        this._enumConstants = values.length == 0 ? null : ArrayUtilities.asUnmodifiableList((Object[])values);
    }

    public final List<TypeReference> getExplicitInterfaces() {
        return this._explicitInterfacesView;
    }

    @Override
    public final List<CustomAnnotation> getAnnotations() {
        return this._customAnnotationsView;
    }

    public final List<SourceAttribute> getSourceAttributes() {
        return this._sourceAttributesView;
    }

    @Override
    public final List<GenericParameter> getGenericParameters() {
        return this._genericParametersView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeReference getRawType() {
        if (this.isGenericType()) {
            if (this._rawType == null) {
                TypeDefinition typeDefinition = this;
                synchronized (typeDefinition) {
                    if (this._rawType == null) {
                        this._rawType = new RawType(this);
                    }
                }
            }
            return this._rawType;
        }
        return this;
    }

    @Override
    public GenericParameter findTypeVariable(String name) {
        for (GenericParameter genericParameter : this.getGenericParameters()) {
            if (!StringUtilities.equals((String)genericParameter.getName(), (String)name)) continue;
            return genericParameter;
        }
        MethodReference declaringMethod = this.getDeclaringMethod();
        if (declaringMethod != null) {
            return declaringMethod.findTypeVariable(name);
        }
        TypeReference declaringType = this.getDeclaringType();
        if (declaringType != null && !this.isStatic()) {
            return declaringType.findTypeVariable(name);
        }
        return null;
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        if (fullName && dottedName && this.isNested() && !this.isAnonymous() && this._simpleName != null) {
            return this.getDeclaringType().appendName(sb, true, true).append('.').append(this._simpleName);
        }
        return super.appendName(sb, fullName, dottedName);
    }

    protected final GenericParameterCollection getGenericParametersInternal() {
        return this._genericParameters;
    }

    protected final Collection<TypeDefinition> getDeclaredTypesInternal() {
        return this._declaredTypes;
    }

    protected final Collection<FieldDefinition> getDeclaredFieldsInternal() {
        return this._declaredFields;
    }

    protected final Collection<MethodDefinition> getDeclaredMethodsInternal() {
        return this._declaredMethods;
    }

    protected final Collection<TypeReference> getExplicitInterfacesInternal() {
        return this._explicitInterfaces;
    }

    protected final Collection<CustomAnnotation> getAnnotationsInternal() {
        return this._customAnnotations;
    }

    protected final Collection<SourceAttribute> getSourceAttributesInternal() {
        return this._sourceAttributes;
    }

    @Override
    public TypeDefinition resolve() {
        return this;
    }

    @Override
    public final long getFlags() {
        return this._flags;
    }

    protected final void setFlags(long flags) {
        this._flags = flags;
    }

    @Override
    public final int getModifiers() {
        return Flags.toModifiers(this.getFlags());
    }

    @Override
    public final boolean isFinal() {
        return Flags.testAny(this.getFlags(), 16L);
    }

    @Override
    public final boolean isNonPublic() {
        return !Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isPrivate() {
        return Flags.testAny(this.getFlags(), 2L);
    }

    @Override
    public final boolean isProtected() {
        return Flags.testAny(this.getFlags(), 4L);
    }

    @Override
    public final boolean isPublic() {
        return Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isStatic() {
        return Flags.testAny(this.getFlags(), 8L);
    }

    @Override
    public final boolean isSynthetic() {
        return Flags.testAny(this.getFlags(), 4096L);
    }

    @Override
    public final boolean isDeprecated() {
        return Flags.testAny(this.getFlags(), 131072L);
    }

    @Override
    public final boolean isPackagePrivate() {
        return !Flags.testAny(this.getFlags(), 7L);
    }

    @Override
    public JvmType getSimpleType() {
        return JvmType.Object;
    }

    public final boolean isAnnotation() {
        return this.isInterface() && Flags.testAny(this.getFlags(), 8192L);
    }

    public final boolean isClass() {
        return !this.isPrimitive() && !this.isInterface() && !this.isEnum();
    }

    public final boolean isInterface() {
        return Flags.testAny(this.getFlags(), 512L);
    }

    public final boolean isEnum() {
        return Flags.testAny(this.getFlags(), 16384L);
    }

    public final boolean isAnonymous() {
        return Flags.testAny(this.getFlags(), 0x100000000000L);
    }

    public final boolean isInnerClass() {
        return this.getDeclaringType() != null;
    }

    public final boolean isLocalClass() {
        return this.getDeclaringMethod() != null;
    }

    @Override
    public boolean isNested() {
        return this.isInnerClass() || this.isLocalClass();
    }

    @Override
    public boolean isArray() {
        return this.getSimpleType() == JvmType.Array;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public final boolean isDefinition() {
        return true;
    }

    public final List<FieldDefinition> getDeclaredFields() {
        return this._declaredFieldsView;
    }

    public final List<MethodDefinition> getDeclaredMethods() {
        return this._declaredMethodsView;
    }

    public final List<TypeDefinition> getDeclaredTypes() {
        return this._declaredTypesView;
    }

    @Override
    public boolean isCompoundType() {
        return Flags.testAny(this.getFlags(), 0x1000000L);
    }

    @Override
    protected StringBuilder appendDescription(StringBuilder sb) {
        List<TypeReference> interfaces;
        int interfaceCount;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers() & 0xFFFFFF7F)) {
            sb.append(modifier.toString());
            sb.append(' ');
        }
        if (this.isEnum()) {
            sb.append("enum ");
        } else if (this.isInterface()) {
            sb.append("interface ");
            if (this.isAnnotation()) {
                sb.append('@');
            }
        } else {
            sb.append("class ");
        }
        StringBuilder s = super.appendDescription(sb);
        TypeReference baseType = this.getBaseType();
        if (baseType != null) {
            s.append(" extends ");
            s = baseType.appendBriefDescription(s);
        }
        if ((interfaceCount = (interfaces = this.getExplicitInterfaces()).size()) > 0) {
            s.append(" implements ");
            for (int i = 0; i < interfaceCount; ++i) {
                if (i != 0) {
                    s.append(",");
                }
                s = interfaces.get(i).appendBriefDescription(s);
            }
        }
        return s;
    }

    @Override
    protected StringBuilder appendGenericSignature(StringBuilder sb) {
        StringBuilder s = super.appendGenericSignature(sb);
        TypeReference baseType = this.getBaseType();
        List<TypeReference> interfaces = this.getExplicitInterfaces();
        if (baseType == null) {
            if (interfaces.isEmpty()) {
                s = BuiltinTypes.Object.appendSignature(s);
            }
        } else {
            s = baseType.appendSignature(s);
        }
        for (TypeReference interfaceType : interfaces) {
            s = interfaceType.appendSignature(s);
        }
        return s;
    }
}

