/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.editview;

import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.caseditor.editor.ArrayValue;
import org.apache.uima.caseditor.editor.CasEditorError;
import org.apache.uima.caseditor.editor.FeatureValue;
import org.apache.uima.caseditor.editor.util.Primitives;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

final class ValueColumnLabelProvider
extends CellLabelProvider {
    ValueColumnLabelProvider() {
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof FeatureValue) {
            FeatureValue featureValue = (FeatureValue)element;
            if (featureValue.getFeature().getRange().isPrimitive()) {
                cell.setText(Primitives.getPrimitive(featureValue.getFeatureStructure(), featureValue.getFeature()).toString());
            } else {
                FeatureStructure value = (FeatureStructure)featureValue.getValue();
                if (value == null) {
                    cell.setText("null");
                } else {
                    cell.setText("[" + value.getType().getShortName() + "]");
                }
            }
        } else if (element instanceof ArrayValue) {
            ArrayValue value = (ArrayValue)element;
            if (value.getFeatureStructure() instanceof ArrayFS) {
                ArrayFS array = (ArrayFS)value.getFeatureStructure();
                FeatureStructure fs = array.get(value.slot());
                if (fs == null) {
                    cell.setText("null");
                } else {
                    cell.setText("[" + fs.getType().getShortName() + "]");
                }
            } else {
                cell.setText(value.get().toString());
            }
        } else {
            throw new CasEditorError("Unknown element!");
        }
    }
}

