"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../../../utils");
var utils_2 = require("../../utils");
var utils_3 = require("./utils");
// If it should be the last step in a line
// We don't want to newline after words which are not methods. For
// instance, g.V() should be one one line, as should __.as
var reduceSingleStepInStepGroup = function (formatSyntaxTree, config) { return function (_a, step, index, steps) {
    var stepsInStepGroup = _a.stepsInStepGroup, stepGroups = _a.stepGroups;
    var isFirstStepGroup = stepGroups.length === 0;
    var isLastStepGroup = index === steps.length - 1;
    var traversalSourceIndentationIncrease = stepGroups[0] && (0, utils_3.isTraversalSource)(stepGroups[0].steps[0]) ? 2 : 0;
    var modulatorIndentationIncrease = (0, utils_3.isModulator)(step) ? 2 : 0;
    var localIndentation = config.localIndentation + traversalSourceIndentationIncrease + modulatorIndentationIncrease;
    // This is the only step in the step group, so it is the first step in
    // the step group. It should only start with a dot if it is not the
    // first stepGroup and config.shouldPlaceDotsAfterLineBreaks
    var shouldStartWithDot = !isFirstStepGroup && config.shouldPlaceDotsAfterLineBreaks;
    // It is the last step in a group and should only end with dot if not
    // config.shouldPlaceDotsAfterLineBreaks this is not the last step in
    // steps
    var shouldEndWithDot = !isLastStepGroup && !config.shouldPlaceDotsAfterLineBreaks;
    return {
        stepsInStepGroup: [],
        stepGroups: __spreadArray(__spreadArray([], stepGroups, true), [
            {
                steps: [
                    formatSyntaxTree((0, utils_1.pipe)((0, utils_2.withIndentation)(localIndentation), (0, utils_2.withDotInfo)({ shouldStartWithDot: shouldStartWithDot, shouldEndWithDot: shouldEndWithDot }), (0, utils_2.withHorizontalPosition)(localIndentation + +config.shouldPlaceDotsAfterLineBreaks))(config))(step),
                ],
            },
        ], false),
    };
}; };
exports.default = reduceSingleStepInStepGroup;
