# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
# pylint: disable=too-few-public-methods
from __future__ import annotations

from typing import Any, Optional, TYPE_CHECKING

from superset import security_manager
from superset.commands.sql_lab.execute import CanAccessQueryValidator

if TYPE_CHECKING:
    from superset.models.sql_lab import Query


class CanAccessQueryValidatorImpl(CanAccessQueryValidator):
    def validate(
        self, query: Query, template_params: Optional[dict[str, Any]] = None
    ) -> None:
        security_manager.raise_for_access(query=query, template_params=template_params)
