/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tars.handler;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.plugin.tars.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.tars.proxy.TarsInvokePrx;

public class TarsMetaDataHandler
implements MetaDataHandler {
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void handle(MetaData metaData) {
        metaData.updateContextPath();
        MetaData metaExist = (MetaData)META_DATA.get(metaData.getPath());
        List<TarsInvokePrx> prxList = ApplicationConfigCache.getInstance().get(metaData.getPath()).getTarsInvokePrxList();
        boolean exist = prxList.stream().anyMatch(tarsInvokePrx -> tarsInvokePrx.getHost().equals(metaData.getAppName()));
        if (!exist) {
            ApplicationConfigCache.getInstance().initPrx(metaData);
        }
        if (Objects.isNull(metaExist)) {
            META_DATA.put(metaData.getPath(), metaData);
        }
    }

    public void remove(MetaData metaData) {
        metaData.updateContextPath();
        List<TarsInvokePrx> prxList = ApplicationConfigCache.getInstance().get(metaData.getPath()).getTarsInvokePrxList();
        List removePrxList = prxList.stream().filter(tarsInvokePrx -> tarsInvokePrx.getHost().equals(metaData.getAppName())).collect(Collectors.toList());
        prxList.removeAll(removePrxList);
        if (CollectionUtils.isEmpty(prxList)) {
            META_DATA.remove(metaData.getPath());
        }
    }

    public String rpcType() {
        return RpcTypeEnum.TARS.getName();
    }
}

