/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.exception.MotanAbstractException;
import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanErrorMsg;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.util.LoggerUtil;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtil {
    public static final StackTraceElement[] REMOTE_MOCK_STACK = new StackTraceElement[]{new StackTraceElement("remoteClass", "remoteMethod", "remoteFile", 1)};

    @Deprecated
    public static boolean isBizException(Exception e) {
        return e instanceof MotanBizException;
    }

    public static boolean isBizException(Throwable t) {
        return t instanceof MotanBizException;
    }

    @Deprecated
    public static boolean isMotanException(Exception e) {
        return e instanceof MotanAbstractException;
    }

    public static boolean isMotanException(Throwable t) {
        return t instanceof MotanAbstractException;
    }

    public static String toMessage(Exception e) {
        JSONObject jsonObject = new JSONObject();
        int type = 1;
        int code = 500;
        String errmsg = null;
        if (e instanceof MotanFrameworkException) {
            MotanFrameworkException mfe = (MotanFrameworkException)e;
            type = 0;
            code = mfe.getErrorCode();
            errmsg = mfe.getOriginMessage();
        } else if (e instanceof MotanServiceException) {
            MotanServiceException mse = (MotanServiceException)e;
            type = 1;
            code = mse.getErrorCode();
            errmsg = mse.getOriginMessage();
        } else if (e instanceof MotanBizException) {
            MotanBizException mbe = (MotanBizException)e;
            type = 2;
            code = mbe.getErrorCode();
            errmsg = mbe.getOriginMessage();
            if (mbe.getCause() != null) {
                errmsg = errmsg + ", org err:" + mbe.getCause().getMessage();
            }
        } else {
            errmsg = e.getMessage();
        }
        jsonObject.put("errcode", (Object)code);
        jsonObject.put("errmsg", (Object)errmsg);
        jsonObject.put("errtype", (Object)type);
        return jsonObject.toString();
    }

    public static MotanAbstractException fromMessage(String msg) {
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)msg);
                int type = jsonObject.getIntValue("errtype");
                int errcode = jsonObject.getIntValue("errcode");
                String errmsg = jsonObject.getString("errmsg");
                MotanAbstractException e = null;
                switch (type) {
                    case 1: {
                        e = new MotanServiceException(errmsg, new MotanErrorMsg(errcode, errcode, errmsg));
                        break;
                    }
                    case 2: {
                        e = new MotanBizException(errmsg, new MotanErrorMsg(errcode, errcode, errmsg));
                        break;
                    }
                    default: {
                        e = new MotanFrameworkException(errmsg, new MotanErrorMsg(errcode, errcode, errmsg));
                    }
                }
                return e;
            }
            catch (Exception e) {
                LoggerUtil.warn("build exception from msg fail. msg:" + msg);
            }
        }
        return null;
    }

    public static void setMockStackTrace(Throwable e) {
        if (e != null) {
            try {
                e.setStackTrace(REMOTE_MOCK_STACK);
            }
            catch (Exception e1) {
                LoggerUtil.warn("replace remote exception stack fail!" + e1.getMessage());
            }
        }
    }
}

