/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.closable;

import com.weibo.api.motan.closable.Closable;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.Collections;

public class ShutDownHook
extends Thread {
    private static final int DEFAULT_PRIORITY = 20;
    private static ShutDownHook instance;
    private ArrayList<closableObject> resourceList = new ArrayList();

    private ShutDownHook() {
    }

    private static void init() {
        if (instance == null) {
            instance = new ShutDownHook();
            LoggerUtil.info("ShutdownHook is initialized");
        }
    }

    public static void runHook(boolean sync) {
        if (instance != null) {
            if (sync) {
                instance.run();
            } else {
                instance.start();
            }
        }
    }

    public static void registerShutdownHook(Closable closable) {
        ShutDownHook.registerShutdownHook(closable, 20);
    }

    public static synchronized void registerShutdownHook(Closable closable, int priority) {
        if (instance == null) {
            ShutDownHook.init();
        }
        ShutDownHook.instance.resourceList.add(new closableObject(closable, priority));
        LoggerUtil.info("add resource " + closable.getClass() + " to list");
    }

    @Override
    public void run() {
        this.closeAll();
    }

    private synchronized void closeAll() {
        Collections.sort(this.resourceList);
        LoggerUtil.info("Start to close global resource due to priority");
        for (closableObject resource : this.resourceList) {
            try {
                resource.closable.close();
            }
            catch (Exception e) {
                LoggerUtil.error("Failed to close " + resource.closable.getClass(), e);
            }
            LoggerUtil.info("Success to close " + resource.closable.getClass());
        }
        LoggerUtil.info("Success to close all the resource!");
        this.resourceList.clear();
    }

    private static class closableObject
    implements Comparable<closableObject> {
        Closable closable;
        int priority;

        public closableObject(Closable closable, int priority) {
            this.closable = closable;
            this.priority = priority;
        }

        @Override
        public int compareTo(closableObject o) {
            if (this.priority > o.priority) {
                return -1;
            }
            if (this.priority == o.priority) {
                return 0;
            }
            return 1;
        }
    }
}

