/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;

public class CodecUtil {
    public static byte[] encodeObjectToBytes(Channel channel, Codec codec, Object msg) {
        try {
            byte[] data = CodecUtil.encodeMessage(channel, codec, msg);
            short type = ByteUtil.bytes2short((byte[])data, (int)0);
            if (type == -3856) {
                return CodecUtil.encodeV1(msg, data);
            }
            if (type == -3599) {
                return data;
            }
            throw new MotanFrameworkException("can not encode message, unknown magic:" + type);
        }
        catch (IOException e) {
            throw new MotanFrameworkException("encode error: isResponse=" + (msg instanceof Response), (Throwable)e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
    }

    private static byte[] encodeV1(Object msg, byte[] data) throws IOException {
        long requestId = CodecUtil.getRequestId(msg);
        byte[] result = new byte[16 + data.length];
        ByteUtil.short2bytes((short)-3599, (byte[])result, (int)0);
        result[3] = CodecUtil.getType(msg);
        ByteUtil.long2bytes((long)requestId, (byte[])result, (int)4);
        ByteUtil.int2bytes((int)data.length, (byte[])result, (int)12);
        System.arraycopy(data, 0, result, 16, data.length);
        return result;
    }

    private static byte[] encodeMessage(Channel channel, Codec codec, Object msg) throws IOException {
        byte[] data;
        if (msg instanceof Response) {
            try {
                data = codec.encode(channel, msg);
            }
            catch (Exception e) {
                LoggerUtil.error((String)("NettyEncoder encode error, identity=" + channel.getUrl().getIdentity()), (Throwable)e);
                Response oriResponse = (Response)msg;
                DefaultResponse response = MotanFrameworkUtil.buildErrorResponse((long)oriResponse.getRequestId(), (byte)oriResponse.getRpcProtocolVersion(), (Exception)e);
                data = codec.encode(channel, (Object)response);
            }
        } else {
            data = codec.encode(channel, msg);
        }
        if (msg instanceof Request) {
            MotanFrameworkUtil.logEvent((Request)((Request)msg), (String)"TRACE_CENCODE");
        } else if (msg instanceof Response) {
            MotanFrameworkUtil.logEvent((Response)((Response)msg), (String)"TRACE_SENCODE");
        }
        return data;
    }

    private static long getRequestId(Object message) {
        if (message instanceof Request) {
            return ((Request)message).getRequestId();
        }
        if (message instanceof Response) {
            return ((Response)message).getRequestId();
        }
        return 0L;
    }

    private static byte getType(Object message) {
        if (message instanceof Request) {
            return 0;
        }
        if (message instanceof Response) {
            return 1;
        }
        return -1;
    }
}

