/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer.scala;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.collection.AbstractCollectionSerializer;
import io.fury.util.GraalvmSupport;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import java.lang.reflect.Field;
import java.util.Collection;

public class SingletonCollectionSerializer
extends AbstractCollectionSerializer {
    private final Field field;
    private long offset = -1L;

    public SingletonCollectionSerializer(Fury fury, Class cls) {
        super(fury, cls, false);
        try {
            this.field = this.type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(this.type + " doesn't have `MODULE$` field", e);
        }
    }

    public Collection onCollectionWrite(MemoryBuffer buffer, Object value) {
        throw new IllegalStateException("unreachable");
    }

    @Override
    public void write(MemoryBuffer buffer, Object value) {
    }

    @Override
    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
        }
        return Platform.getObject(this.type, offset);
    }

    public Object onCollectionRead(Collection collection) {
        throw new IllegalStateException("unreachable");
    }
}

