/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api.composite;

import com.alipay.lookout.api.Counter;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.composite.CompositeMetric;
import java.util.Collection;
import java.util.Iterator;

class CompositeCounter
extends CompositeMetric
implements Counter {
    public CompositeCounter(Id id, Collection<Registry> registries) {
        super(id, registries);
    }

    @Override
    public void inc() {
        for (Registry r : this.registries) {
            this.getMetric(r).inc();
        }
    }

    @Override
    public void inc(long amount) {
        for (Registry r : this.registries) {
            this.getMetric(r).inc(amount);
        }
    }

    @Override
    public void dec() {
        for (Registry r : this.registries) {
            this.getMetric(r).dec();
        }
    }

    @Override
    public void dec(long n) {
        for (Registry r : this.registries) {
            this.getMetric(r).dec(n);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? this.getMetric((Registry)it.next()).count() : 0L;
    }

    protected Counter getMetric(Registry registry) {
        return registry.counter(this.id);
    }
}

