/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.jackson.io.JacksonSupplierSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.OutputStream;

public class JacksonSerializer<T>
extends AbstractSerializer<T> {
    static final String MODULE_ID = "jjwt-jackson";
    static final Module MODULE;
    static final ObjectMapper DEFAULT_OBJECT_MAPPER;
    protected final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper cannot be null.");
        this.objectMapper = objectMapper.registerModule(MODULE);
    }

    protected void doSerialize(T t, OutputStream out) throws Exception {
        Assert.notNull((Object)out, (String)"OutputStream cannot be null.");
        ObjectWriter writer = this.objectMapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        writer.writeValue(out, t);
    }

    static {
        SimpleModule module = new SimpleModule(MODULE_ID);
        module.addSerializer((JsonSerializer)JacksonSupplierSerializer.INSTANCE);
        MODULE = module;
        DEFAULT_OBJECT_MAPPER = new ObjectMapper().registerModule(MODULE);
    }
}

