/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelAttributeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry, boolean useDefaultResolution) {
        super(adapterRegistry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterType(parameter, type -> !BeanUtils.isSimpleProperty((Class)type));
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Class resolvedType = parameter.getParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(resolvedType);
        Assert.state((adapter == null || !adapter.isMultiValue() ? 1 : 0) != 0, (String)"Multi-value publisher is not supported");
        String name = ModelInitializer.getNameForParameter(parameter);
        Mono dataBinderMono = this.initDataBinder(name, adapter != null ? parameter.nested() : parameter, context, exchange2).doOnNext(binder -> {
            BindingResult errors = binder.getBindingResult();
            if (errors.hasErrors()) {
                throw new WebExchangeBindException(parameter, errors);
            }
        });
        Sinks.One bindingResultSink = Sinks.unsafe().one();
        Map model = context.getModel().asMap();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultSink.asMono());
        return dataBinderMono.flatMap(binder -> {
            Object attribute = binder.getTarget();
            Assert.state((attribute != null ? 1 : 0) != 0, (String)"Expected model attribute instance");
            return (!this.bindingDisabled(parameter) ? this.bindRequestParameters((WebExchangeDataBinder)binder, exchange2) : Mono.empty()).doOnError(arg_0 -> ((Sinks.One)bindingResultSink).tryEmitError(arg_0)).doOnSuccess(aVoid -> {
                this.validateIfApplicable((WebExchangeDataBinder)binder, parameter, exchange2);
                BindingResult bindingResult = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResult);
                model.put(name, attribute);
                bindingResultSink.tryEmitValue((Object)bindingResult);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapter != null) {
                    Mono mono = errors.hasErrors() ? Mono.error((Throwable)new WebExchangeBindException(parameter, errors)) : Mono.just((Object)attribute);
                    return adapter.fromPublisher((Publisher)mono);
                }
                if (errors.hasErrors() && !this.hasErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return attribute;
            }));
        });
    }

    private Mono<WebExchangeDataBinder> initDataBinder(String name, MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Object value = context.getModel().asMap().get(name);
        if (value == null) {
            value = this.removeReactiveAttribute(name, context.getModel());
        }
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
        if (value != null) {
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, value);
            Assert.isTrue((adapter == null || !adapter.isMultiValue() ? 1 : 0) != 0, (String)"Multi-value publisher is not supported");
            return (adapter != null ? Mono.from((Publisher)adapter.toPublisher(value)) : Mono.just(value)).map(attr -> context.createDataBinder(exchange2, attr, name, type));
        }
        WebExchangeDataBinder binder = context.createDataBinder(exchange2, null, name, type);
        return this.constructAttribute(binder, exchange2).thenReturn((Object)binder);
    }

    @Nullable
    private Object removeReactiveAttribute(String name, Model model) {
        for (Map.Entry entry : model.asMap().entrySet()) {
            ReactiveAdapter adapter;
            if (!((String)entry.getKey()).startsWith(name) || (adapter = this.getAdapterRegistry().getAdapter(null, entry.getValue())) == null || !((String)entry.getKey()).equals(name + ClassUtils.getShortName((Class)adapter.getReactiveType()))) continue;
            model.asMap().remove(entry.getKey());
            return entry.getValue();
        }
        return null;
    }

    protected Mono<Void> constructAttribute(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.construct(exchange2);
    }

    private boolean bindingDisabled(MethodParameter parameter) {
        ModelAttribute modelAttribute = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        return modelAttribute != null && !modelAttribute.binding();
    }

    protected Mono<Void> bindRequestParameters(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder.bind(exchange2);
    }

    private boolean hasErrorsArgument(MethodParameter parameter) {
        int i2 = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        return paramTypes.length > i2 + 1 && Errors.class.isAssignableFrom(paramTypes[i2 + 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter, ServerWebExchange exchange2) {
        LocaleContext localeContext = null;
        try {
            for (Annotation ann : parameter.getParameterAnnotations()) {
                Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
                if (validationHints == null) continue;
                if (localeContext == null) {
                    localeContext = exchange2.getLocaleContext();
                    LocaleContextHolder.setLocaleContext((LocaleContext)localeContext);
                }
                binder.validate(validationHints);
            }
        }
        finally {
            if (localeContext != null) {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }
}

