/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySelectorRefresh
extends AbstractDataRefresh<ProxySelectorData> {
    private static final Logger LOG = LoggerFactory.getLogger(ProxySelectorRefresh.class);
    private final List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers;

    public ProxySelectorRefresh(List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers) {
        this.proxySelectorDataSubscribers = proxySelectorDataSubscribers;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.PROXY_SELECTOR.name());
    }

    @Override
    protected ConfigData<ProxySelectorData> fromJson(JsonObject data) {
        return (ConfigData)GsonUtils.getGson().fromJson((JsonElement)data, new TypeToken<ConfigData<ProxySelectorData>>(){}.getType());
    }

    @Override
    protected void refresh(List<ProxySelectorData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all ProxySelector data cache");
            return;
        }
        data.forEach(d -> this.proxySelectorDataSubscribers.forEach(pss -> pss.onSubscribe(d)));
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<ProxySelectorData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.PROXY_SELECTOR);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.PROXY_SELECTOR);
    }
}

