/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

public enum ClickHouseCompression {
    NONE("", "", ""),
    BROTLI("application/x-brotli", "br", "br"),
    BZ2("application/x-bzip2", "bz2", "bz2"),
    DEFLATE("application/deflate", "deflate", "zz"),
    GZIP("application/gzip", "gzip", "gz"),
    LZMA("application/x-lzma", "lzma", "xz"),
    LZ4("application/x-lz4", "lz4", "lz4"),
    ZIP("application/zip", "zip", "zip"),
    ZSTD("application/zstd", "zstd", "zst");

    private String mimeType;
    private String encoding;
    private String fileExt;

    private ClickHouseCompression(String mimeType, String encoding, String fileExt) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.fileExt = fileExt;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public String encoding() {
        return this.encoding;
    }

    public String fileExtension() {
        return this.fileExt;
    }

    public static ClickHouseCompression fromMimeType(String mimeType) {
        ClickHouseCompression compression = NONE;
        if (mimeType != null) {
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.mimeType.equals(mimeType)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }

    public static ClickHouseCompression fromEncoding(String encoding) {
        ClickHouseCompression compression = NONE;
        if (encoding != null) {
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.encoding.equals(encoding)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }

    public static ClickHouseCompression fromFileName(String file) {
        ClickHouseCompression compression = NONE;
        int index = 0;
        if (file != null && (index = file.lastIndexOf(46)) > 0) {
            String ext = file.substring(index + 1).toLowerCase();
            for (ClickHouseCompression c : ClickHouseCompression.values()) {
                if (!c.fileExt.equals(ext)) continue;
                compression = c;
                break;
            }
        }
        return compression;
    }
}

