/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config.source;

import com.alipay.sofa.common.config.source.AbstractConfigSource;
import com.alipay.sofa.common.utils.StringUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.concurrent.ExecutionException;

public class ConfigSourceCacheWrapper
extends AbstractConfigSource {
    public static final int DEFAULT_MAX_SIZE = 1000;
    private AbstractConfigSource delegate;
    private LoadingCache<String, String> cache;

    public ConfigSourceCacheWrapper(final AbstractConfigSource delegate, CacheBuilder<String, String> cb) {
        this.delegate = delegate;
        this.cache = cb.build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) {
                String value = delegate.doGetConfig(key);
                if (value == null) {
                    return "";
                }
                return value;
            }
        });
    }

    public ConfigSourceCacheWrapper(final AbstractConfigSource delegate, long expireAfterSecond) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(expireAfterSecond)).maximumSize(1000L).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) {
                String value = delegate.doGetConfig(key);
                if (value == null) {
                    return "";
                }
                return value;
            }
        });
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String doGetConfig(String key) {
        if (key == null) {
            return null;
        }
        try {
            return (String)this.cache.get((Object)key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            return null;
        }
    }

    @Override
    public boolean hasKey(String key) {
        return StringUtil.isNotBlank(this.doGetConfig(key));
    }

    @Override
    public int getOrder() {
        return this.delegate.getOrder();
    }
}

