/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.dubbo.rpc.proxy.InvokerInvocationHandler;
import org.apache.dubbo.rpc.support.RpcUtils;

public class InvocationUtil {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(InvokerInvocationHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Invoker<?> invoker, RpcInvocation rpcInvocation) throws Throwable {
        RpcContext.RestoreServiceContext originServiceContext = RpcContext.storeServiceContext();
        try {
            URL url = invoker.getUrl();
            String serviceKey = url.getServiceKey();
            rpcInvocation.setTargetServiceUniqueName(serviceKey);
            RpcServiceContext.getServiceContext().setConsumerUrl(url);
            if (ProfilerSwitch.isEnableSimpleProfiler()) {
                long usage;
                Object object;
                ProfilerEntry parentProfiler = Profiler.getBizProfiler();
                ProfilerEntry bizProfiler = parentProfiler != null ? Profiler.enter(parentProfiler, "Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + rpcInvocation.getMethodName()) : Profiler.start("Receive request. Client invoke begin. ServiceKey: " + serviceKey + " MethodName:" + rpcInvocation.getMethodName());
                rpcInvocation.put("DUBBO_INVOKE_PROFILER", bizProfiler);
                try {
                    object = invoker.invoke(rpcInvocation).recreate();
                }
                catch (Throwable throwable) {
                    long usage2;
                    Profiler.release(bizProfiler);
                    Long timeout = RpcUtils.convertToNumber(rpcInvocation.getObjectAttachmentWithoutConvert("timeout"));
                    if (timeout == null) {
                        timeout = url.getMethodPositiveParameter(rpcInvocation.getMethodName(), "timeout", 1000);
                    }
                    if ((double)(usage2 = bizProfiler.getEndTime() - bizProfiler.getStartTime()) / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout.longValue()) {
                        StringBuilder attachment = new StringBuilder();
                        rpcInvocation.foreachAttachment(entry -> attachment.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";\n"));
                        logger.warn("3-4", "", "", String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", rpcInvocation.getProtocolServiceKey(), rpcInvocation.getMethodName(), usage2 / 1000000L, usage2 % 1000000L, timeout, attachment, Profiler.buildDetail(bizProfiler)));
                    }
                    throw throwable;
                }
                Profiler.release(bizProfiler);
                Long timeout = RpcUtils.convertToNumber(rpcInvocation.getObjectAttachmentWithoutConvert("timeout"));
                if (timeout == null) {
                    timeout = url.getMethodPositiveParameter(rpcInvocation.getMethodName(), "timeout", 1000);
                }
                if ((double)(usage = bizProfiler.getEndTime() - bizProfiler.getStartTime()) / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout.longValue()) {
                    StringBuilder attachment = new StringBuilder();
                    rpcInvocation.foreachAttachment(entry -> attachment.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";\n"));
                    logger.warn("3-4", "", "", String.format("[Dubbo-Consumer] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\ninvocation context:\n%sthread info: \n%s", rpcInvocation.getProtocolServiceKey(), rpcInvocation.getMethodName(), usage / 1000000L, usage % 1000000L, timeout, attachment, Profiler.buildDetail(bizProfiler)));
                }
                return object;
            }
            Object object = invoker.invoke(rpcInvocation).recreate();
            return object;
        }
        finally {
            RpcContext.restoreServiceContext(originServiceContext);
        }
    }
}

