/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.remoting.transport.ExceedPayloadLimitException;
import org.apache.dubbo.rpc.protocol.rest.netty.NettyHttpResponse;

public class ChunkOutputStream
extends OutputStream {
    final ByteBuf buffer;
    final ChannelHandlerContext ctx;
    final NettyHttpResponse response;
    int chunkSize = 0;

    ChunkOutputStream(NettyHttpResponse response, ChannelHandlerContext ctx, int chunkSize) {
        this.response = response;
        if (chunkSize < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = Unpooled.buffer((int)0, (int)chunkSize);
        this.chunkSize = chunkSize;
        this.ctx = ctx;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.maxWritableBytes() < 1) {
            this.throwExceedPayloadLimitException(this.buffer.readableBytes() + 1);
        }
        this.buffer.writeByte(b);
    }

    private void throwExceedPayloadLimitException(int dataSize) throws ExceedPayloadLimitException {
        throw new ExceedPayloadLimitException("Data length too large: " + dataSize + ", max payload: " + this.chunkSize);
    }

    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException();
        }
        this.buffer.clear();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int dataLengthLeftToWrite = len;
        int dataToWriteOffset = off;
        if (this.buffer.maxWritableBytes() < dataLengthLeftToWrite) {
            this.throwExceedPayloadLimitException(this.buffer.readableBytes() + len);
        }
        this.buffer.writeBytes(b, dataToWriteOffset, dataLengthLeftToWrite);
    }

    @Override
    public void flush() throws IOException {
        int readable = this.buffer.readableBytes();
        if (readable == 0) {
            return;
        }
        if (!this.response.isCommitted()) {
            this.response.prepareChunkStream();
        }
        this.ctx.writeAndFlush((Object)new DefaultHttpContent(this.buffer.copy()));
        this.buffer.clear();
        super.flush();
    }
}

