/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.command.util.SerializeCheckUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="serializeWarnedClasses", summary="get serialize warned classes")
public class SerializeWarnedClasses
implements BaseCommand {
    private final SerializeCheckUtils serializeCheckUtils;

    public SerializeWarnedClasses(FrameworkModel frameworkModel) {
        this.serializeCheckUtils = frameworkModel.getBeanFactory().getBean(SerializeCheckUtils.class);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (commandContext.isHttp()) {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            result.put("warnedClasses", this.serializeCheckUtils.getWarnedClasses());
            return JsonUtils.toJson(result);
        }
        return "WarnedClasses: \n" + this.serializeCheckUtils.getWarnedClasses().stream().sorted().collect(Collectors.joining("\n")) + "\n\n";
    }
}

